/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.hg.peer.AbstractFigureFrameProxy;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.EventUtilities;
import com.mathworks.hg.peer.FigureClientProxyPanel;
import com.mathworks.hg.peer.FigureDTClientEventNotification;
import com.mathworks.hg.peer.FigureDTClientListener;
import com.mathworks.hg.peer.FigureJavaEventNotification;
import com.mathworks.hg.peer.FigureMenuBarNotification;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.FigurePanelProxyNotification;
import com.mathworks.hg.peer.FiguresGroupListener;
import com.mathworks.hg.peer.OffscreenWindowProvider;
import com.mathworks.hg.peer.PaintDisabled;
import com.mathworks.hg.peer.PositionableFigureClientProxy;
import com.mathworks.hg.peer.ShowClientState;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class FigureClientProxy
implements FigureNotificationHandler,
PositionableFigureClientProxy {
    private static ImageIcon sIcon = null;
    private String fGroupName;
    private Desktop fDesktop;
    private AbstractFigureFrameProxy fFrameProxy;
    private String fTitle;
    private boolean fLastDocked = false;
    private boolean fJustOpened = false;
    private DTLocation fLastUndockedLocation = DTLocation.createExternal((int)0, (int)0, (int)0, (int)0);
    private DTLocation fLastDockedLocation = DTLocation.createInternal((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
    private boolean fMenubarVisible = false;
    private FigureDTClientBase fClient;
    private boolean fLightWeight = false;
    private boolean fShowTopSeparator = true;
    private FigureDTClientListener fFigureDTClientListener;
    private ClientProxyNotificationHandler fNotificationHandler;
    private Container fContentContainer;
    private boolean fCloseRequestEnabled;
    private Object fCloseTransaction = null;
    private MJPanel fContentPane = null;
    private ShowClientState fShowClientState = ShowClientState.NOT_SET;
    private ShowHandler fShowHandler = new ShowEnabledHandler();
    private Point fLastGroupContainerLocation = null;
    private final Object fLockLastGroupContainerLocation = new Object();
    private final Object fLocationLock = new Object();

    public FigureClientProxy(Desktop desktop, String string, boolean bl, String string2) {
        this.fDesktop = desktop != null ? desktop : FigureClientProxy.getMatlabDesktop();
        this.fGroupName = string;
        this.fTitle = string2;
        this.fLightWeight = bl;
        this.fNotificationHandler = new ClientProxyNotificationHandler();
        this.fFigureDTClientListener = new FigureDTClientListener();
        this.fFigureDTClientListener.setNotificationSuccessor(this);
    }

    public void doInitialize(boolean bl) {
        this.fClient = new FigureDTClientBase(this.fLightWeight);
        this.fContentPane = new FigureClientProxyPanel(new BorderLayout(), this);
        this.setName("fClientProxy");
        this.initializeShowHandler(bl);
        this.fClient.setLayout(new BorderLayout(0, 0));
        this.fClient.add((Component)this.fContentPane, "Center");
    }

    public void setFigureFrame(AbstractFigureFrameProxy abstractFigureFrameProxy) {
        this.fFrameProxy = abstractFigureFrameProxy;
        if (this.fFrameProxy != null) {
            this.fFrameProxy.setNotificationSuccessor(this);
        }
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        this.doHandleNotification(figureNotification);
    }

    private void doHandleNotification(FigureNotification figureNotification) {
        if (this.fNotificationHandler != null) {
            this.fNotificationHandler.handleNotification(figureNotification);
        }
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    private static Desktop getMatlabDesktop() {
        return MatlabDesktopServices.getDesktop();
    }

    public boolean registerWithDesktop() {
        return this.registerWithDesktop(false, this.getLastUndockedLocation());
    }

    public boolean registerWithDesktop(boolean bl, DTLocation dTLocation) {
        boolean bl2 = false;
        if (this.fDesktop != null) {
            if (!this.fDesktop.hasClient((Component)((Object)this.fClient))) {
                this.fDesktop.addClient((Component)((Object)this.fClient), this.fTitle, bl, dTLocation, bl);
            }
            bl2 = true;
        }
        return bl2;
    }

    public void hideClient() {
        this.fShowHandler.hideClient();
    }

    public void dispose() {
        this.fFrameProxy = null;
        this.fContentContainer = null;
        this.fShowHandler.dispose();
        this.fShowClientState = ShowClientState.NOT_SET;
        this.setNotificationSuccessor(null);
        this.fShowHandler = null;
        this.fNotificationHandler = null;
        this.fClient.dispose();
        this.fClient = null;
    }

    private void initializeShowHandler(boolean bl) {
        assert (!this.fShowClientState.isValid() || bl && !this.fShowClientState.isShowEnabled() || !bl && this.fShowClientState.isShowEnabled());
        if (!this.fShowClientState.isValid()) {
            this.assignShowHandler(bl ? ShowClientState.SHOW_DISABLED : ShowClientState.SHOW_ENABLED);
            this.fShowHandler.initialize();
        }
    }

    private void assignShowHandler(ShowClientState showClientState) {
        assert (showClientState.isValid());
        this.fShowHandler = showClientState.isShowEnabled() ? new ShowEnabledHandler() : new ShowDisabledHandler();
        this.fShowClientState = showClientState;
    }

    void swapShowHandler(ShowClientState showClientState, Container container, Component component) {
        if (showClientState != this.fShowClientState) {
            boolean bl;
            assert (showClientState.isValid());
            boolean bl2 = bl = component.isDisplayable() && component.isVisible();
            if (this.fShowHandler instanceof ShowDisabledHandler) {
                ((ShowDisabledHandler)this.fShowHandler).unparent();
            } else {
                container.remove(component);
            }
            this.assignShowHandler(showClientState);
            if (this.fShowHandler instanceof ShowDisabledHandler) {
                ((ShowDisabledHandler)this.fShowHandler).reparent(component, bl);
            } else {
                container.add(component);
            }
            this.fClient.validate();
        }
    }

    public void showClient(boolean bl) {
        DTLocation dTLocation = bl ? this.getLastDockedLocation() : this.getLastUndockedLocation();
        this.showClient(dTLocation);
    }

    public void disableShow() {
        assert (EventQueue.isDispatchThread()) : "Must call disableShow from the EDT";
        if (this.fShowClientState.isValid()) {
            if (this.fShowClientState.isShowEnabled()) {
                this.hideClient();
                this.fShowClientState = ShowClientState.NOT_SET;
            }
            this.initializeShowHandler(true);
        }
    }

    private void showClient(DTLocation dTLocation) {
        this.fShowHandler.showClient(dTLocation);
    }

    public void showClientHidden() {
        this.fShowHandler.showClientHidden();
    }

    public void closeClient() {
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient))) {
            this.fDesktop.closeClient((Component)((Object)this.fClient));
        }
    }

    public void toFront() {
        if (this.fDesktop != null) {
            this.fDesktop.setClientSelected((Component)((Object)this.fClient), true);
        }
    }

    public boolean isSelected() {
        if (this.fDesktop != null) {
            return this.fDesktop.isClientSelected((Component)((Object)this.fClient));
        }
        return false;
    }

    Container getMDIContainer() {
        return this.fDesktop == null ? null : this.fDesktop.getGroupContainer(this.getGroupName());
    }

    public boolean isDockedInMDIRegion() {
        return this.getMDIContainer() != null;
    }

    private void addClientListener(DTClientListener dTClientListener) {
        if (this.fDesktop != null) {
            this.fDesktop.addClientListener((Component)((Object)this.fClient), dTClientListener);
        }
    }

    private void removeClientListener(DTClientListener dTClientListener) {
        if (this.fDesktop != null) {
            this.fDesktop.removeClientListener((Component)((Object)this.fClient), dTClientListener);
        }
    }

    protected void addGroupListener(String string, FiguresGroupListener figuresGroupListener) {
        assert (string != null);
        if (this.fDesktop != null) {
            this.fDesktop.addGroupListener(string, (DTGroupListener)figuresGroupListener);
            this.fClient.addAncestorListener(figuresGroupListener);
        }
    }

    protected void removeGroupListener(String string, FiguresGroupListener figuresGroupListener) {
        assert (string != null);
        if (this.fDesktop != null) {
            this.fDesktop.removeGroupListener(string, (DTGroupListener)figuresGroupListener);
            this.fClient.removeAncestorListener(figuresGroupListener);
        }
    }

    public Point getLocation() {
        Rectangle rectangle = this.isClientDocked() ? this.getClientRectangle() : this.getCachedClientRectangle();
        return rectangle.getLocation();
    }

    protected DTLocation getClientLocation() {
        return this.fDesktop == null ? null : this.fDesktop.getClientLocation((Component)((Object)this.fClient));
    }

    private void setClientLocation(DTLocation dTLocation) {
        if (dTLocation != null) {
            assert (!dTLocation.isDocked());
            this.setLastUndockedLocation(dTLocation);
            if (this.fDesktop != null) {
                this.fDesktop.setClientLocation((Component)((Object)this.fClient), dTLocation);
            }
        }
    }

    @Override
    public boolean isClientMaximized() {
        DTLocation dTLocation = this.getClientLocation();
        if (dTLocation == null) {
            dTLocation = this.getLastUndockedLocation();
        }
        return dTLocation.isMaximized();
    }

    @Override
    public Rectangle getCachedClientRectangle() {
        return this.getLastUndockedLocation().getFrameBounds();
    }

    @Override
    public void setCachedClientRectangle(Rectangle rectangle) {
        this.setLastUndockedLocation(DTLocation.createExternal((int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height));
    }

    @Override
    public Rectangle getClientRectangle() {
        DTLocation dTLocation = this.getClientLocation();
        if (dTLocation == null) {
            dTLocation = this.getLastUndockedLocation();
        }
        return dTLocation.getFrameBounds();
    }

    @Override
    public void setClientRectangle(Rectangle rectangle) {
        assert (rectangle != null);
        if (this.isClientDocked()) {
            assert (false);
            return;
        }
        if (this.fShowClientState.isValid() && this.fShowClientState.isPrinting()) {
            return;
        }
        this.setClientLocation(DTLocation.createExternal((int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height));
    }

    public void setClientWindowStyle(boolean bl, boolean bl2) {
        assert (!bl || !bl2);
        assert (this.fFrameProxy != null) : "Figure client has no frame.";
        if (!this.isClientDocked() && !bl) {
            if (bl2 != this.fFrameProxy.isModal()) {
                this.fFrameProxy.setModal(bl2);
            }
        } else if (this.fDesktop != null) {
            this.fFrameProxy.setModal(bl2);
            this.fDesktop.setClientDocked((Component)((Object)this.fClient), bl);
        }
    }

    @Override
    public boolean isShowing() {
        return this.fShowHandler.isShowing();
    }

    public boolean isHidden() {
        return this.fShowHandler.isHidden();
    }

    public Dimension getContainerSize() {
        Container container;
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient)) && (container = this.fDesktop.getGroupContainer(this.getGroupName())) != null) {
            Dimension dimension = container.getSize();
            Insets insets = this.fDesktop.getGroupContainerInsets(this.getGroupName());
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            return dimension;
        }
        return null;
    }

    @Override
    public Insets getDockedClientInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient))) {
            insets = this.fDesktop.getInternalFrameInsets((Component)((Object)this.fClient));
        }
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLastGroupContainerLocation() {
        Container container;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fDesktop != null && (container = this.fDesktop.getGroupContainer(this.getGroupName())) != null) {
            Point point = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point, container);
            point = this.adjustLastGroupContainerLocationIfTiled((Component)((Object)this.fClient), container, point);
            Object object = this.fLockLastGroupContainerLocation;
            synchronized (object) {
                this.fLastGroupContainerLocation = new Point(point);
            }
        }
    }

    protected Point adjustLastGroupContainerLocationIfTiled(Component component, Container container, Point point) {
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getContainerLocation() {
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient))) {
            Point point = null;
            Object object = this.fLockLastGroupContainerLocation;
            synchronized (object) {
                if (this.fLastGroupContainerLocation != null) {
                    point = new Point(this.fLastGroupContainerLocation);
                }
            }
            if (point != null && (object = this.fDesktop.getGroupContainerInsets(this.getGroupName())) != null) {
                point.translate(((Insets)object).left, ((Insets)object).top);
            }
            return point;
        }
        return null;
    }

    private void setDesktop(Desktop desktop, DTLocation dTLocation, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call setDesktop from the EDT";
        if (this.fDesktop == desktop) {
            // empty if block
        }
        if (null != this.fDesktop) {
            this.fDesktop.removeClientListener((Component)((Object)this.fClient), (DTClientListener)this.fFigureDTClientListener);
            if (this.fDesktop.hasClient((Component)((Object)this.fClient))) {
                this.fDesktop.removeClient((Component)((Object)this.fClient));
            }
            this.fDesktop = null;
        }
        if (null != desktop) {
            this.fDesktop = desktop;
            this.registerWithDesktop(bl, dTLocation);
            this.addClientListener((DTClientListener)this.fFigureDTClientListener);
        }
    }

    public void setGroupName(Desktop desktop, String string, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call setGroupName from the EDT";
        this.fGroupName = string;
        if (this.fDesktop != null) {
            DTLocation dTLocation = this.fDesktop.getClientLocation((Component)((Object)this.fClient));
            if (dTLocation == null) {
                dTLocation = this.getLastUndockedLocation();
            }
            this.setDesktop(null, null, bl);
            this.setClientGroup(this.fGroupName);
            this.setDesktop(desktop, dTLocation, bl);
        }
    }

    public void setGroupName(String string, boolean bl) {
        this.setGroupName(this.fDesktop, string, bl);
    }

    public String getGroupName() {
        return this.fGroupName;
    }

    public Desktop getDesktop() {
        return this.fDesktop;
    }

    public static ImageIcon getClientIcon() {
        if (null == sIcon) {
            sIcon = PlatformInfo.isWindows() ? ApplicationIcon.FIGURE_32x32.getIcon() : ApplicationIcon.FIGURE_48x48.getIcon();
        }
        return sIcon;
    }

    public void setClientIcon(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = null == imageIcon ? FigureClientProxy.getClientIcon() : imageIcon;
        this.fClient.setClientIcon(imageIcon2);
    }

    public JPanel getContentPane() {
        return this.fContentPane;
    }

    public void setClientToolBars(Vector<JToolBar> vector) {
        assert (vector != null);
        if (vector != null) {
            assert (SwingUtilities.isEventDispatchThread());
            assert (this.fFrameProxy != null) : "Figure client has no frame.";
            int n = vector.size();
            MJToolBar[] mJToolBarArray = new MJToolBar[n];
            vector.toArray(mJToolBarArray);
            this.fClient.setClientToolBars((JToolBar[])mJToolBarArray);
            if (n > 0) {
                this.fFrameProxy.fireToolbarPreferredHeight((JToolBar[])mJToolBarArray, this.fShowTopSeparator);
            } else {
                this.fFrameProxy.fireToolbarContainerEvent(0);
            }
        }
    }

    public void setClientMenuBar(JMenuBar jMenuBar) {
        if (null == jMenuBar) {
            this.fMenubarVisible = false;
        } else {
            this.fClient.setClientDontMergeMenu(true);
            this.fMenubarVisible = true;
        }
        this.fClient.setClientMenuBar(jMenuBar);
    }

    public void setClientTitle(String string) {
        this.fTitle = string;
        this.fClient.setClientTitle(string);
    }

    public void setClientGroup(String string) {
        this.fClient.setClientGroup(string);
    }

    public void setClientDockable(boolean bl) {
        this.fClient.setClientDockable(bl);
    }

    public void showClientTopSeparator(boolean bl) {
        this.fClient.showClientTopSeparator(bl);
    }

    public void vetoClientClose() {
        if (null != this.fCloseTransaction) {
            Object object = this.fCloseTransaction;
            this.fCloseTransaction = null;
            this.fClient.vetoClientClose(object);
        }
    }

    public void approveClientClose() {
        if (null != this.fCloseTransaction) {
            Object object = this.fCloseTransaction;
            this.fCloseTransaction = null;
            this.fClient.approveClientClose(object);
        }
    }

    private void deferClientClose(Object object) {
        this.fCloseTransaction = object;
        this.fClient.deferClientClose();
    }

    private boolean isCloseRequestEnabled() {
        return this.fCloseRequestEnabled;
    }

    public void setCloseRequestEnabled(boolean bl) {
        this.fCloseRequestEnabled = bl;
    }

    public DTClientBase getClient() {
        return this.fClient;
    }

    public void setName(String string) {
        this.fClient.setName(string);
    }

    public Window getWindow() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this.fClient));
    }

    public void setCursor(Cursor cursor) {
        this.fClient.setCursor(cursor);
    }

    @Override
    public boolean isClientDocked() {
        if (this.fDesktop != null) {
            DTLocation dTLocation = this.getClientLocation();
            if (dTLocation == null) {
                return false;
            }
            return this.fDesktop.isClientDocked((Component)((Object)this.fClient));
        }
        return false;
    }

    public void validateFigure() {
        this.fShowHandler.validateFigure();
    }

    protected boolean correctDTClientPositionEventType(boolean bl, DTLocation dTLocation) {
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DTLocation getLastUndockedLocation() {
        DTLocation dTLocation = null;
        Object object = this.fLocationLock;
        synchronized (object) {
            dTLocation = DTLocation.clone((DTLocation)this.fLastUndockedLocation);
        }
        assert (dTLocation != null);
        return dTLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastUndockedLocation(DTLocation dTLocation) {
        assert (dTLocation != null);
        Object object = this.fLocationLock;
        synchronized (object) {
            this.fLastUndockedLocation = DTLocation.clone((DTLocation)dTLocation);
        }
        this.fShowHandler.setSize(dTLocation.getFrameSize());
        this.fLastDocked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DTLocation getLastDockedLocation() {
        DTLocation dTLocation = null;
        Object object = this.fLocationLock;
        synchronized (object) {
            dTLocation = DTLocation.clone((DTLocation)this.fLastDockedLocation);
        }
        assert (dTLocation != null);
        return dTLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastDockedLocation(DTLocation dTLocation) {
        assert (dTLocation != null);
        assert (dTLocation.isDocked());
        Object object = this.fLocationLock;
        synchronized (object) {
            this.fLastDockedLocation = DTLocation.clone((DTLocation)dTLocation);
        }
        this.fLastDocked = true;
    }

    private static class PaintDisabledJPanel
    extends JPanel
    implements PaintDisabled.PaintDisabledHandler {
        private boolean fPaintDisabled = false;

        PaintDisabledJPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public void setPaintDisabled(boolean bl) throws OutputHelperProcessingException {
            this.fPaintDisabled = bl;
        }

        @Override
        public boolean isPaintDisabled() {
            return this.fPaintDisabled;
        }
    }

    private class ShowDisabledHandler
    implements ShowHandler {
        private PaintDisabledJPanel fPanel;

        private ShowDisabledHandler() {
        }

        @Override
        public void hideClient() {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ShowDisabledHandler.this.fPanel != null) {
                            ShowDisabledHandler.this.fPanel.setVisible(false);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        @Override
        public void showClient(DTLocation dTLocation) {
            this.showClientInvisible(dTLocation.getFrameBounds().getSize());
        }

        @Override
        public void showClientHidden() {
            DTLocation dTLocation = FigureClientProxy.this.getLastDockedLocation();
            Dimension dimension = dTLocation == null ? new Dimension(560, 420) : dTLocation.getFrameSize();
            this.showClientInvisible(dimension);
        }

        @Override
        public boolean isShowing() {
            return this.fPanel != null && this.fPanel.isVisible();
        }

        @Override
        public boolean isHidden() {
            return this.fPanel == null || !this.fPanel.isVisible();
        }

        @Override
        public void dispose() {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShowDisabledHandler.this.unparent();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void unparent() {
            OffscreenWindowProvider.remove(this.fPanel);
            this.fPanel.remove((Component)((Object)FigureClientProxy.this.fClient));
        }

        @Override
        public void initialize() {
            FigureClientProxy.this.setDesktop(null, null, false);
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShowDisabledHandler.this.reparent((Component)((Object)FigureClientProxy.this.fClient), false);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void reparent(Component component, boolean bl) {
            assert (EventQueue.isDispatchThread()) : "Must call reparent from the EDT";
            this.fPanel = new PaintDisabledJPanel(new BorderLayout());
            this.fPanel.add(component);
            this.setSize(component.getSize());
            if (component instanceof PaintDisabled.PaintDisabledHandler) {
                try {
                    this.fPanel.setPaintDisabled(((PaintDisabled.PaintDisabledHandler)((Object)component)).isPaintDisabled());
                }
                catch (OutputHelperProcessingException outputHelperProcessingException) {
                    outputHelperProcessingException.printStackTrace();
                }
            }
            OffscreenWindowProvider.getWindow().add(this.fPanel);
            this.fPanel.setVisible(bl);
        }

        private void showClientInvisible(final Dimension dimension) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShowDisabledHandler.this.fPanel.setVisible(true);
                        FigureClientProxy.this.fClient.setVisible(true);
                        ShowDisabledHandler.this.setSize(dimension);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        @Override
        public void validateFigure() {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ShowDisabledHandler.this.fPanel != null) {
                            ShowDisabledHandler.this.fPanel.validate();
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        @Override
        public void setSize(final Dimension dimension) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ShowDisabledHandler.this.fPanel != null) {
                            ShowDisabledHandler.this.fPanel.setSize(dimension);
                            ShowDisabledHandler.this.fPanel.validate();
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private class ShowEnabledHandler
    implements ShowHandler {
        private FocusListener fFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                FigureClientProxy.this.handleNotification(new FigureJavaEventNotification(focusEvent));
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FigureClientProxy.this.handleNotification(new FigureJavaEventNotification(focusEvent));
            }
        };

        private ShowEnabledHandler() {
        }

        @Override
        public void hideClient() {
            if (FigureClientProxy.this.fDesktop != null) {
                if (FigureClientProxy.this.isClientDocked()) {
                    FigureClientProxy.this.fLastDockedLocation = FigureClientProxy.this.getClientLocation();
                    assert (FigureClientProxy.this.fLastDockedLocation.isDocked());
                }
                FigureClientProxy.this.fDesktop.hideClient((Component)((Object)FigureClientProxy.this.fClient));
            }
        }

        @Override
        public void showClient(DTLocation dTLocation) {
            if (FigureClientProxy.this.fDesktop != null) {
                FigureClientProxy.this.fDesktop.showClient((Component)((Object)FigureClientProxy.this.fClient), dTLocation, true);
            }
        }

        @Override
        public void showClientHidden() {
            if (FigureClientProxy.this.fDesktop != null) {
                DTLocation dTLocation = FigureClientProxy.this.fDesktop.getClientLocation((Component)((Object)FigureClientProxy.this.fClient));
                if (dTLocation != null && !dTLocation.isDocked()) {
                    FigureClientProxy.this.setLastUndockedLocation(dTLocation);
                }
                FigureClientProxy.this.fDesktop.showClientHidden((Component)((Object)FigureClientProxy.this.fClient), FigureClientProxy.this.getLastUndockedLocation(), true);
            }
        }

        @Override
        public boolean isShowing() {
            return FigureClientProxy.this.fDesktop != null && FigureClientProxy.this.fDesktop.isClientShowing((Component)((Object)FigureClientProxy.this.fClient));
        }

        @Override
        public boolean isHidden() {
            return FigureClientProxy.this.fDesktop != null && FigureClientProxy.this.fDesktop.isClientHidden((Component)((Object)FigureClientProxy.this.fClient));
        }

        @Override
        public void dispose() {
            FigureClientProxy.this.setDesktop(null, null, false);
            FigureClientProxy.this.removeClientListener((DTClientListener)FigureClientProxy.this.fFigureDTClientListener);
            FigureClientProxy.this.fClient.removeFocusListener(this.fFocusListener);
            FigureClientProxy.this.fClient.remove((Component)FigureClientProxy.this.fContentPane);
            FigureClientProxy.this.fContentPane = null;
        }

        @Override
        public void initialize() {
            FigureClientProxy.this.setClientGroup(FigureClientProxy.this.fGroupName);
            FigureClientProxy.this.setClientIcon(FigureClientProxy.getClientIcon());
            FigureClientProxy.this.showClientTopSeparator(true);
            if (FigureClientProxy.this.fDesktop != null) {
                FigureClientProxy.this.registerWithDesktop();
                FigureClientProxy.this.fClient.setClientDockable(FigureClientProxy.this.fDesktop.hasMainFrame());
                FigureClientProxy.this.addClientListener((DTClientListener)FigureClientProxy.this.fFigureDTClientListener);
                FigureClientProxy.this.fClient.addFocusListener(this.fFocusListener);
            }
        }

        @Override
        public void validateFigure() {
            DTFrame dTFrame;
            if (this.isShowing() && FigureClientProxy.this.fDesktop != null && (dTFrame = FigureClientProxy.this.fDesktop.getContainingFrame((Component)((Object)FigureClientProxy.this.fClient))) != null) {
                dTFrame.getRootPane().validate();
            }
        }

        @Override
        public void setSize(Dimension dimension) {
        }
    }

    private static interface ShowHandler {
        public void hideClient();

        public void showClient(DTLocation var1);

        public void showClientHidden();

        public boolean isShowing();

        public boolean isHidden();

        public void dispose();

        public void initialize();

        public void validateFigure();

        public void setSize(Dimension var1);
    }

    private class FigureDTClientBase
    extends DTClientBase {
        private MouseWheelListener fMouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                EventUtilities.fixYOnScreenValue(mouseWheelEvent);
                FigureJavaEventNotification figureJavaEventNotification = new FigureJavaEventNotification(mouseWheelEvent);
                FigureClientProxy.this.doHandleNotification(figureJavaEventNotification);
            }
        };

        private FigureDTClientBase(boolean bl) {
            this.initialize(bl);
        }

        protected DTSingleClientFrame createFrame(Desktop desktop, String string) {
            assert (FigureClientProxy.this.fFrameProxy != null) : "Figure client has no frame.";
            return FigureClientProxy.this.fFrameProxy.createFigurePeerFrame(desktop, string, FigureClientProxy.this.isHidden());
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Dimension dimension2 = FigureClientProxy.this.fContentPane.getPreferredSize();
            if (dimension.width > dimension2.width) {
                dimension.width = dimension2.width;
            }
            return dimension;
        }

        void dispose() {
            this.removeMouseWheelListener(this.fMouseWheelListener);
            this.fMouseWheelListener = null;
        }

        private void initialize(boolean bl) {
            this.setMultipleInstances(true);
            this.setDontReopen(true);
            this.setHeavyweight(!bl);
            this.setStatusBar(DTClientProperty.NULL_STATUS_BAR);
            this.setDontMergeMenu(true);
            this.setOfferToolBarToggles(false);
            this.setDebuggerToFront(true);
            this.setUndockedBounding(DTProperty.Bounding.NONE);
            this.setAllowForcedClose(false);
            this.addMouseWheelListener(this.fMouseWheelListener);
        }

        public void setClientDockable(boolean bl) {
            this.setDockable(bl);
        }

        public void setClientIcon(Icon icon) {
            this.setIcon(icon);
        }

        public void setClientToolBars(JToolBar[] jToolBarArray) {
            this.setToolBars(jToolBarArray);
        }

        public void setClientMenuBar(JMenuBar jMenuBar) {
            this.setMenuBar(jMenuBar);
        }

        public void setClientDontMergeMenu(boolean bl) {
            this.setDontMergeMenu(bl);
        }

        public void setClientTitle(String string) {
            this.setTitle(string);
        }

        public void setClientGroup(String string) {
            this.setGroup(string);
        }

        public void showClientTopSeparator(boolean bl) {
            FigureClientProxy.this.fShowTopSeparator = bl;
            this.setWantTopSeparator(bl);
        }

        public void approveClientClose(Object object) {
            this.approveClose(object);
        }

        public void vetoClientClose(Object object) {
            this.vetoClose(object);
        }

        public void deferClientClose() {
            this.deferClose();
        }
    }

    private class ClientProxyNotificationHandler
    extends FigureNotificationHandlerImpl {
        private ClientProxyNotificationHandler() {
        }

        @Override
        public void handleNotification(FigureNotification figureNotification) {
            if (figureNotification instanceof FigureMenuBarNotification) {
                this.handleMenuBarNotification((FigureMenuBarNotification)figureNotification);
                return;
            }
            if (figureNotification instanceof FigureDTClientEventNotification) {
                this.handleDTClientEventNotification((FigureDTClientEventNotification)figureNotification);
                return;
            }
            if (figureNotification instanceof FigureJavaEventNotification) {
                this.handleJavaEventNotification((FigureJavaEventNotification)figureNotification);
                return;
            }
            if (figureNotification instanceof FigurePanelProxyNotification && figureNotification.getType() == 1) {
                JPanel jPanel = FigureClientProxy.this.getContentPane();
                Container container = ((FigurePanelProxyNotification)figureNotification).getContainer();
                if (!container.equals(FigureClientProxy.this.fContentContainer)) {
                    if (FigureClientProxy.this.fContentContainer != null) {
                        jPanel.remove(FigureClientProxy.this.fContentContainer);
                    }
                    FigureClientProxy.this.fContentContainer = container;
                    FigureClientProxy.this.getContentPane().add((Component)FigureClientProxy.this.fContentContainer, "Center");
                    FigureClientProxy.this.getContentPane().validate();
                }
            }
            super.handleNotification(figureNotification);
        }

        private void handleMenuBarNotification(FigureMenuBarNotification figureMenuBarNotification) {
            FigureMenuBarNotification figureMenuBarNotification2 = figureMenuBarNotification;
            switch (figureMenuBarNotification2.getType()) {
                case 2: {
                    FigureClientProxy.this.setClientMenuBar((JMenuBar)figureMenuBarNotification2.getMenuBar());
                    return;
                }
                case 3: {
                    FigureClientProxy.this.setClientMenuBar(null);
                    return;
                }
                case 4: {
                    if (FigureClientProxy.this.fMenubarVisible) break;
                    figureMenuBarNotification2 = new FigureMenuBarNotification(1, 0, null);
                    break;
                }
            }
            super.handleNotification(figureMenuBarNotification2);
        }

        private void handleDTClientEventNotification(FigureDTClientEventNotification figureDTClientEventNotification) {
            DTClientEvent dTClientEvent = figureDTClientEventNotification.getEvent();
            FigureJavaEventNotification figureJavaEventNotification = null;
            switch (dTClientEvent.getType()) {
                case 2: {
                    if (!FigureClientProxy.this.isClientDocked()) break;
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 205);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 12: {
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 201);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 11: {
                    if (!FigureClientProxy.this.isCloseRequestEnabled()) break;
                    DebugUtilities.logMessage(1024, "FigureClientProxy.DTClientEvent.CLOSING closeRequest is enabled", this);
                    FigureClientProxy.this.deferClientClose(dTClientEvent.getData());
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 201);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 3: {
                    if (!FigureClientProxy.this.isClientDocked()) break;
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 206);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 10: {
                    if (FigureClientProxy.this.isClientDocked()) {
                        ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 200);
                        figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    }
                    FigureClientProxy.this.fJustOpened = true;
                    break;
                }
                case 8: 
                case 9: {
                    Object object;
                    boolean bl;
                    DTLocation dTLocation = (DTLocation)dTClientEvent.getData();
                    assert (dTLocation != null);
                    boolean bl2 = bl = dTClientEvent.getType() == 8;
                    if (FigureClientProxy.this.isClientDocked()) {
                        FigureClientProxy.this.updateLastGroupContainerLocation();
                        if (bl && ((object = FigureClientProxy.this.getLastDockedLocation()).getFrameWidth() != dTLocation.getFrameWidth() || object.getFrameHeight() != dTLocation.getFrameHeight() || !FigureClientProxy.this.fLastDocked)) {
                            bl = false;
                        }
                        FigureClientProxy.this.setLastDockedLocation(dTLocation);
                    } else {
                        if (bl && (FigureClientProxy.this.fLastDocked || FigureClientProxy.this.fJustOpened)) {
                            bl = false;
                        }
                        bl = FigureClientProxy.this.correctDTClientPositionEventType(bl, dTLocation);
                        FigureClientProxy.this.setLastUndockedLocation(dTLocation);
                    }
                    FigureClientProxy.this.fJustOpened = false;
                    if (dTLocation.getFrameWidth() <= 0 && dTLocation.getFrameHeight() <= 0) break;
                    object = new FigureMoveResizeNotification(bl);
                    FigureClientProxy.this.doHandleNotification((FigureNotification)object);
                    break;
                }
                default: {
                    super.handleNotification(figureDTClientEventNotification);
                }
            }
            super.handleNotification(figureJavaEventNotification);
        }

        private void handleJavaEventNotification(FigureJavaEventNotification figureJavaEventNotification) {
            AWTEvent aWTEvent = figureJavaEventNotification.getEvent();
            if (aWTEvent instanceof KeyEvent) {
                if (((KeyEvent)aWTEvent).getKeyCode() != 9) {
                    FigureClientProxy.this.fClient.dispatchEvent(aWTEvent);
                }
            } else if (aWTEvent instanceof WindowEvent && aWTEvent.getID() == 206 && FigureClientProxy.this.isClientDocked()) {
                return;
            }
            super.handleNotification(figureJavaEventNotification);
        }
    }
}

