/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.peer.FigurePeerWindowEvent;
import com.mathworks.hg.peer.FigurePeerWindowListener;
import java.awt.Component;
import java.util.Vector;

public class FigureWindowActiveState {
    private boolean fIsActive;
    private boolean fWindowOpened;
    private boolean fIsWindowActiveSinceLastShow;
    private boolean fIsWindowActive;
    private transient Vector figurePeerWindowListeners;

    public boolean isWindowActive() {
        return this.fIsActive;
    }

    public void setWindowActive(boolean bl) {
        this.fIsActive = bl;
    }

    public boolean isWindowActiveSinceLastShow() {
        return this.fIsWindowActiveSinceLastShow;
    }

    public void setWindowActiveSinceLastShow(boolean bl) {
        this.fIsWindowActiveSinceLastShow = bl;
    }

    public boolean isWindowOpened() {
        return this.fWindowOpened;
    }

    public void setWindowOpened(boolean bl) {
        this.fWindowOpened = bl;
    }

    public boolean isActivatedEventReceived() {
        return this.fIsWindowActive;
    }

    public void setActivatedEventReceived(boolean bl) {
        this.fIsWindowActive = bl;
    }

    public synchronized void removeFigurePeerWindowListener(FigurePeerWindowListener figurePeerWindowListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerWindowListener", this);
        if (this.figurePeerWindowListeners != null && this.figurePeerWindowListeners.contains(figurePeerWindowListener)) {
            Vector vector = (Vector)this.figurePeerWindowListeners.clone();
            vector.removeElement(figurePeerWindowListener);
            this.figurePeerWindowListeners = vector;
        }
    }

    public synchronized void addFigurePeerWindowListener(FigurePeerWindowListener figurePeerWindowListener) {
        Vector vector;
        DebugUtilities.logMessage(288, "FigureWindowActiveState.addFigurePeerWindowListener", this);
        Vector vector2 = vector = this.figurePeerWindowListeners == null ? new Vector(2) : (Vector)this.figurePeerWindowListeners.clone();
        if (!vector.contains(figurePeerWindowListener)) {
            vector.addElement(figurePeerWindowListener);
            this.figurePeerWindowListeners = vector;
        }
    }

    public void fireFigurePeerWindowEvent(FigurePeerWindowEvent figurePeerWindowEvent) {
        DebugUtilities.logMessage(544, "FigureWindowActiveState.fireFigurePeerWindowEvent", this);
        if (this.figurePeerWindowListeners != null) {
            Vector vector = this.figurePeerWindowListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((FigurePeerWindowListener)vector.elementAt(i)).figurePeerWindowEvent(figurePeerWindowEvent);
            }
        }
    }

    public void figureOpened(FigurePeerWindowEvent figurePeerWindowEvent) {
        DebugUtilities.logMessage(16928, "FigureWindowActiveState.figureOpened", this);
        boolean bl = this.isWindowActive();
        this.fireFigurePeerWindowEvent(figurePeerWindowEvent);
        this.setWindowOpened(true);
        if (bl) {
            this.fireActivate(figurePeerWindowEvent.getComponent());
        }
    }

    public void figureActivated(FigurePeerWindowEvent figurePeerWindowEvent) {
        boolean bl = this.isWindowActive();
        this.setWindowActive(true);
        DebugUtilities.logMessage(16384, "FigureWindowActiveState.figureActivated", this);
        if (!bl) {
            this.fireActivate(figurePeerWindowEvent.getComponent());
        }
    }

    private void fireActivate(Component component) {
        if (this.isWindowActive() && this.isWindowOpened()) {
            this.setWindowActiveSinceLastShow(true);
            DebugUtilities.logMessage(16384, "FigureWindowActiveState.fireActivated + FIRE", this);
            FigurePeerWindowEvent figurePeerWindowEvent = new FigurePeerWindowEvent(component, 205);
            this.fireFigurePeerWindowEvent(figurePeerWindowEvent);
        }
    }

    public void figureDeactivated(FigurePeerWindowEvent figurePeerWindowEvent) {
        boolean bl = this.isWindowActive();
        this.setWindowActive(false);
        DebugUtilities.logMessage(16384, "FigureWindowActiveState.figureDeactivated", this);
        if (bl) {
            DebugUtilities.logMessage(16384, "FigureWindowActiveState.figureDeactivated + FIRE", this);
            this.fireFigurePeerWindowEvent(figurePeerWindowEvent);
        }
    }

    public void figureClosing(FigurePeerWindowEvent figurePeerWindowEvent) {
        DebugUtilities.logMessage(16928, "FigureWindowActiveState.windowClosing", this);
        FigureEditableComponentManager.commitCurrentEditableComponent();
        this.fireFigurePeerWindowEvent(figurePeerWindowEvent);
    }

    public void figureClosed(FigurePeerWindowEvent figurePeerWindowEvent) {
        DebugUtilities.logMessage(16928, "FigureWindowActiveState.windowClosed", this);
        this.setWindowActive(false);
        this.setWindowOpened(false);
        this.fireFigurePeerWindowEvent(figurePeerWindowEvent);
    }
}

