/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.jogamp.opengl.util.TileRendererBase;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.JavaSceneServerPeerAdapter;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLJPanel;

public class GLEventListenerWithReset
implements GLEventListener,
TileRendererBase.TileRendererListener {
    private JavaSceneServerPeerInterface fJSSP;
    private static int sListenerCounter = 0;
    private int fListenerId = -1;
    private boolean fSizeValid;
    private static int sLastAvailableMem = 0;
    private TileRendererBase fTileRendererInUse = null;
    private boolean fTiling = false;

    public GLEventListenerWithReset(JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        this.fJSSP = javaSceneServerPeerInterface == null ? new JavaSceneServerPeerAdapter() : javaSceneServerPeerInterface;
    }

    private static void initMaxDimensions(JavaSceneServerPeerInterface javaSceneServerPeerInterface, GLAutoDrawable gLAutoDrawable) {
        Dimension dimension = javaSceneServerPeerInterface.getMaxViewportSize();
        GL gL = gLAutoDrawable.getGL();
        int[] nArray = new int[2];
        gL.glGetIntegerv(3386, IntBuffer.wrap(nArray));
        if (dimension == null || nArray[0] * nArray[1] < dimension.width * dimension.height) {
            javaSceneServerPeerInterface.setMaxViewportSize(new Dimension(nArray[0], nArray[1]));
        }
    }

    public static int getLastAvailableGPUMemory() {
        return sLastAvailableMem;
    }

    private void measureGPUMemory(GL gL) {
        if (gL.isExtensionAvailable("GL_NVX_gpu_memory_info")) {
            int[] nArray = new int[]{0};
            gL.glGetIntegerv(36937, nArray, 0);
            DebugUtilities.logMessage(32768, "  NVIDIA free memory: " + nArray[0], this);
            sLastAvailableMem = nArray[0];
        } else if (gL.isExtensionAvailable("GL_ATI_meminfo")) {
            int[] nArray = new int[]{0, 0, 0, 0};
            gL.glGetIntegerv(34813, nArray, 0);
            DebugUtilities.logMessage(32768, "  ATI renderbuffer free memory: [ " + nArray[0] + " " + nArray[1] + " " + nArray[2] + " " + nArray[3] + " ]", this);
            sLastAvailableMem = nArray[1];
        }
    }

    public void startTileRendering(TileRendererBase tileRendererBase) {
    }

    public void endTileRendering(TileRendererBase tileRendererBase) {
        this.fJSSP.resetTiling();
    }

    public void addTileRendererNotify(TileRendererBase tileRendererBase) {
        DebugUtilities.logMessage(32768, "GLEventListenerWithReset.addTileRendererNotify " + this.fListenerId, null);
        this.fTileRendererInUse = tileRendererBase;
        this.fTiling = true;
    }

    public void removeTileRendererNotify(TileRendererBase tileRendererBase) {
        DebugUtilities.logMessage(32768, "GLEventListenerWithReset.removeTileRendererNotify " + this.fListenerId, null);
        assert (tileRendererBase.equals(this.fTileRendererInUse));
        this.fTileRendererInUse = null;
        this.fTiling = false;
    }

    public void reshapeTile(TileRendererBase tileRendererBase, int n, int n2, int n3, int n4, int n5, int n6) {
        DebugUtilities.logMessage(32768, "GLEventListenerWithReset.reshapeTile " + this.fListenerId + " [" + n + " " + n2 + " " + n3 + " " + n4 + "] " + "image " + n5 + "x" + n6, this);
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, n3, n4);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, n5, n6);
        this.fJSSP.setTile(double_, double_2);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        DebugUtilities.logMessage(32768, "GLEventListenerWithReset.init " + (sListenerCounter + 1), this);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getChosenGLCapabilities();
        DebugUtilities.logMessage(32768, "  chosen capabilities", gLCapabilitiesImmutable);
        this.measureGPUMemory(gLAutoDrawable.getGL());
        GLEventListenerWithReset.initMaxDimensions(this.fJSSP, gLAutoDrawable);
        this.validateSize(this.fJSSP.getViewportWidth(), this.fJSSP.getViewportHeight());
        this.fListenerId = ++sListenerCounter;
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        DebugUtilities.logMessage(32768, "GLEventListenerWithReset.dispose " + this.fListenerId, this);
        if (this.fListenerId >= 0) {
            this.fJSSP.restart(this.fListenerId, false);
        } else {
            this.fJSSP.reportError("MATLAB:HG:Java:RestartContext", "No context ID defined in dispose");
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.validateSize(n3, n4);
        DebugUtilities.logMessage(32768, "GLEventListenerWithReset.reshape " + this.fListenerId + " (" + n + " " + n2 + " " + n3 + " " + n4 + ")", this);
        this.fJSSP.reshape(n, n2, n3, n4);
    }

    private boolean validateSize(int n, int n2) {
        if (!this.fTiling) {
            this.fSizeValid = true;
        } else {
            Dimension dimension = this.fJSSP.getMaxViewportSize();
            if (n <= dimension.width && n2 <= dimension.height) {
                this.fSizeValid = true;
            } else {
                this.fJSSP.reportError("MATLAB:HG:Java:ViewportTooLarge", "Viewport [" + n + "x" + n2 + "]" + " too large for OpenGL implementation:" + " max [" + dimension.width + "x" + dimension.height + "]");
                this.fSizeValid = false;
            }
        }
        return this.fSizeValid;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        DebugUtilities.logMessage(32768, "GLEventListenerWithReset.display " + this.fListenerId, this);
        if (!this.fTiling && !this.fSizeValid) {
            return;
        }
        boolean bl = false;
        if (gLAutoDrawable instanceof GLJPanel) {
            GLJPanel gLJPanel = (GLJPanel)gLAutoDrawable;
            bl = gLAutoDrawable.isGLOriented() && gLJPanel.getSkipGLOrientationVerticalFlip();
        }
        this.fJSSP.display(this.fListenerId, bl);
    }
}

