/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ActiveXCanvas;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.peer.HGPrintingInterface;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.OffscreenWindowProvider;
import com.mathworks.hg.peer.PaintDisabled;
import com.mathworks.hg.peer.TransparentPanel;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.hg.print.HGOutputFlags;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class HeavyweightLightweightContainerFactory {
    static final int WORKAROUND_NONE = 0;
    static final int WORKAROUND_BEFORE_RESHAPE = 1;
    static final int WORKAROUND_AFTER_RESHAPE = 2;
    private static int sUseWorkaround = 1;

    private HeavyweightLightweightContainerFactory() {
    }

    public static Container getUIComponentContainer(UIComponentParent uIComponentParent) {
        assert (uIComponentParent != null);
        return HeavyweightLightweightContainerFactory.getUIComponentContainer();
    }

    public static Container getUIComponentContainer() {
        return new UIComponentLightweightContainer();
    }

    public static Container getFigurePanelContainer() {
        return HeavyweightLightweightContainerFactory.getFigurePanelContainer(false);
    }

    public static Container getFigurePanelContainer(boolean bl) {
        FigurePanelContainerLight figurePanelContainerLight = new FigurePanelContainerLight(bl);
        figurePanelContainerLight.setFigureContainer(true);
        figurePanelContainerLight.setOpaque(true);
        return figurePanelContainerLight;
    }

    public static Container getUIPanelContainer() {
        return new UIPanelLightweightContainer();
    }

    public static ActiveXCanvas getActiveXContainer(UIComponentParent uIComponentParent) {
        return new ActiveXCanvas(uIComponentParent){

            @Override
            public void reshape(int n, int n2, int n3, int n4) {
                if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 2) {
                    HeavyweightLightweightContainerFactory.usePaintingIssueWorkaround(this);
                }
                super.reshape(n, n2, n3, n4);
                if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 1) {
                    HeavyweightLightweightContainerFactory.usePaintingIssueWorkaround(this);
                }
            }
        };
    }

    static void usePaintingIssueWorkaround(Component component) {
        Container container;
        if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 0 && component != null && component.isVisible() && (container = component.getParent()) != null) {
            container.invalidate();
        }
    }

    public static void setUseWorkaround(int n) {
        sUseWorkaround = n;
    }

    public static int getUseWorkaround() {
        return sUseWorkaround;
    }

    public static class FigurePanelContainerPrinter {
        private Container fContainer;
        private boolean fComponentContainer = true;
        private boolean fFigureContainer;

        FigurePanelContainerPrinter(Container container, boolean bl, boolean bl2) {
            this.fContainer = container;
            this.fComponentContainer = bl;
            this.fFigureContainer = bl2;
        }

        private static void visitChildren(Container container, HGOutputFlags hGOutputFlags) {
            int n;
            for (int i = n = container.getComponentCount(); i > 0; --i) {
                Component component = container.getComponent(i - 1);
                if (component instanceof FigurePrintable) {
                    ((FigurePrintable)((Object)component)).setHGOutputFlags(hGOutputFlags);
                }
                if (component instanceof Container) {
                    FigurePanelContainerPrinter.visitChildren((Container)component, hGOutputFlags);
                }
                if (!(component instanceof HGPrintingInterface)) continue;
                ((HGPrintingInterface)((Object)component)).setClearBackgroundOnPrint(hGOutputFlags.getClearBackground());
            }
        }

        public Exception printFigurePanel(Graphics graphics, HGOutputFlags hGOutputFlags) {
            Component component;
            int n;
            assert (graphics instanceof Graphics2D);
            int n2 = this.fContainer.getComponentCount();
            if (this.fFigureContainer) {
                if (hGOutputFlags.getClearBackground()) {
                    ((FigurePanelContainerLight)((Object)this.fContainer)).paintBackground(graphics);
                }
                FigurePanelContainerPrinter.visitChildren(this.fContainer, hGOutputFlags);
            }
            Component[] componentArray = new Component[n2];
            for (n = n2; n > 0; --n) {
                componentArray[this.fContainer.getComponentZOrder((Component)component)] = component = this.fContainer.getComponent(n - 1);
            }
            for (n = n2; n > 0; --n) {
                component = componentArray[n - 1];
                if (this.fComponentContainer && !(component instanceof FigureComponent) && !(component instanceof FigurePanelContainer)) {
                    String string = "Unexpected component requested print: " + component;
                    DebugUtilities.logMessage(16, string, this);
                    if (!hGOutputFlags.getDebugMode()) continue;
                    System.out.println(string);
                    continue;
                }
                if (!hGOutputFlags.getPrintUI() && component instanceof FigurePanelContainer) {
                    if (!hGOutputFlags.getDebugMode()) continue;
                    System.out.println("Not printing UI based on '-noui' flag");
                    continue;
                }
                try {
                    component.printAll(graphics);
                    continue;
                }
                catch (JavaSceneServerPeer.HGGLRuntimeException hGGLRuntimeException) {
                    if (hGOutputFlags.getCalledFromMATLAB()) {
                        JavaSceneServerPeer.HGGLRuntimeException hGGLRuntimeException2 = hGGLRuntimeException;
                        return hGGLRuntimeException2;
                    }
                    throw hGGLRuntimeException;
                }
                finally {
                    if (this.fFigureContainer) {
                        FigurePanelContainerPrinter.visitChildren(this.fContainer, new HGOutputFlags());
                    }
                }
            }
            return null;
        }
    }

    public static class PrintableContainerUtility {
        private boolean fPrinting;

        public void setPrinting(boolean bl) {
            this.fPrinting = bl;
        }

        public Component getComponent(Component component) {
            Component component2 = component;
            if (this.fPrinting && component instanceof Container && component instanceof UIComponentHost) {
                Container container = (Container)component;
                assert (container.getComponentCount() == 1);
                component2 = container.getComponent(0);
                component2.setBounds(container.getBounds());
            }
            return component2;
        }
    }

    public static interface FigurePrintable {
        @Deprecated
        public void setPrintUI(boolean var1);

        public HGOutputFlags getHGOutputFlags();

        public void setHGOutputFlags(HGOutputFlags var1);

        public boolean getClearBackground();
    }

    public static class PrintHelper {
        private PrintHelper() {
        }

        public static void printAllComponents(Container container, Graphics graphics) {
            int n;
            for (int i = n = container.getComponentCount(); i > 0; --i) {
                Component component = container.getComponent(i - 1);
                if (!component.isVisible()) continue;
                Graphics graphics2 = graphics.create(component.getX(), component.getY(), component.getWidth(), component.getHeight());
                component.printAll(graphics2);
                graphics2.dispose();
            }
        }
    }

    public static class FigurePanelContainerLight
    extends MJPanel
    implements FigurePanelContainer,
    FigurePrintable,
    PaintDisabled.PaintDisabledHandler {
        private PrintableContainerUtility fPrintableContainerUtility = new PrintableContainerUtility();
        private boolean fFigureContainer;
        private boolean fComponentContainer;
        private HGOutputFlags fFlags = new HGOutputFlags();
        private boolean fIsTopLayer;
        private Container fOldParent;
        private boolean fPaintDisabled = false;
        private boolean fInSetPaintDisabled = false;

        public FigurePanelContainerLight(boolean bl) {
            this.fFlags.setPrintUI(true);
            this.fIsTopLayer = bl;
        }

        private void disablePaint() throws OutputHelperProcessingException {
            if (OffscreenWindowProvider.isComponentReallyVisible((Component)((Object)this))) {
                PaintDisabled.installRepaintManager((JComponent)((Object)this));
            }
            this.fOldParent = this.getParent();
            if (this.isTopLayer()) {
                assert (this.fOldParent instanceof PaintDisabled.PaintDisabledTargetHandler) : "Parent must be a PaintDisabledTargetHandler";
                ((PaintDisabled.PaintDisabledTargetHandler)((Object)this.fOldParent)).setPaintDisabledTarget((Component)((Object)this));
            }
            PaintDisabled.visitChildren(this.fOldParent, true);
            PaintDisabled.setPaintDisabled(this.fOldParent, true);
            this.fPaintDisabled = true;
        }

        private void enablePaint() {
            assert (this.fOldParent != null);
            try {
                PaintDisabled.setPaintDisabled(this.fOldParent, false);
                PaintDisabled.visitChildren(this.fOldParent, false);
            }
            catch (OutputHelperProcessingException outputHelperProcessingException) {
                System.err.println(outputHelperProcessingException);
            }
            if (this.isTopLayer()) {
                assert (this.fOldParent instanceof PaintDisabled.PaintDisabledTargetHandler) : "Parent must be a PaintDisabledTargetHandler";
                ((PaintDisabled.PaintDisabledTargetHandler)((Object)this.fOldParent)).setPaintDisabledTarget(null);
            }
            this.fOldParent = null;
            PaintDisabled.removeRepaintManager();
            this.fPaintDisabled = false;
        }

        private void doSetPaintDisabled(boolean bl) throws OutputHelperProcessingException {
            if (this.fPaintDisabled == bl) {
                return;
            }
            if (bl) {
                try {
                    this.disablePaint();
                }
                catch (OutputHelperProcessingException outputHelperProcessingException) {
                    this.enablePaint();
                    throw outputHelperProcessingException;
                }
            } else {
                this.enablePaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPaintDisabled(boolean bl) throws OutputHelperProcessingException {
            assert (EventQueue.isDispatchThread());
            if (this.fInSetPaintDisabled) {
                return;
            }
            try {
                this.fInSetPaintDisabled = true;
                this.doSetPaintDisabled(bl);
            }
            finally {
                this.fInSetPaintDisabled = false;
            }
        }

        @Override
        public boolean isPaintDisabled() {
            return this.fPaintDisabled;
        }

        public boolean isTopLayer() {
            return this.fIsTopLayer;
        }

        public boolean isOptimizedDrawingEnabled() {
            return true;
        }

        @Override
        @Deprecated
        public void setPrintUI(boolean bl) {
            this.fFlags.setPrintUI(bl);
        }

        @Override
        public HGOutputFlags getHGOutputFlags() {
            return this.fFlags;
        }

        @Override
        public void setHGOutputFlags(HGOutputFlags hGOutputFlags) {
            this.fFlags = hGOutputFlags;
        }

        @Override
        public boolean getClearBackground() {
            return this.fFlags.getClearBackground();
        }

        public void paintBackground(Graphics graphics) {
            this.paintComponent(graphics);
        }

        @Override
        public void setFigureContainer(boolean bl) {
            this.fFigureContainer = bl;
        }

        @Override
        public void setComponentContainer(boolean bl) {
            this.fComponentContainer = bl;
        }

        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public Exception printFigurePanel(Graphics graphics, HGOutputFlags hGOutputFlags) {
            this.fFlags = hGOutputFlags;
            return new FigurePanelContainerPrinter((Container)((Object)this), this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, this.fFlags);
        }

        @Override
        public Container getTargetContainer() {
            return this;
        }

        public Component getComponent(int n) {
            return this.fPrintableContainerUtility.getComponent(super.getComponent(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printChildren(Graphics graphics) {
            this.fPrintableContainerUtility.setPrinting(true);
            try {
                super.printChildren(graphics);
            }
            finally {
                this.fPrintableContainerUtility.setPrinting(false);
            }
        }

        public void printAll(Graphics graphics) {
            this.printComponent(graphics);
            this.printBorder(graphics);
            PrintHelper.printAllComponents((Container)((Object)this), graphics);
        }
    }

    public static class FigureComponentContainerLight
    extends TransparentPanel
    implements FigurePanelContainer,
    FigurePrintable {
        private PrintableContainerUtility fPrintableContainerUtility = new PrintableContainerUtility();
        private boolean fFigureContainer;
        private boolean fComponentContainer;
        private HGOutputFlags fFlags = new HGOutputFlags();

        public FigureComponentContainerLight() {
            this.fFlags.setPrintUI(true);
        }

        @Override
        @Deprecated
        public void setPrintUI(boolean bl) {
            this.fFlags.setPrintUI(bl);
        }

        @Override
        public HGOutputFlags getHGOutputFlags() {
            return this.fFlags;
        }

        @Override
        public void setHGOutputFlags(HGOutputFlags hGOutputFlags) {
            this.fFlags = hGOutputFlags;
        }

        @Override
        public boolean getClearBackground() {
            return this.fFlags.getClearBackground();
        }

        @Override
        public void setFigureContainer(boolean bl) {
            this.fFigureContainer = bl;
        }

        @Override
        public void setComponentContainer(boolean bl) {
            this.fComponentContainer = bl;
        }

        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public Exception printFigurePanel(Graphics graphics, HGOutputFlags hGOutputFlags) {
            this.fFlags = hGOutputFlags;
            return new FigurePanelContainerPrinter((Container)((Object)this), this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, hGOutputFlags);
        }

        @Override
        public Container getTargetContainer() {
            return this;
        }

        public Component getComponent(int n) {
            return this.fPrintableContainerUtility.getComponent(super.getComponent(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printChildren(Graphics graphics) {
            this.fPrintableContainerUtility.setPrinting(true);
            try {
                super.printChildren(graphics);
            }
            finally {
                this.fPrintableContainerUtility.setPrinting(false);
            }
        }

        public void printAll(Graphics graphics) {
            this.printComponent(graphics);
            this.printBorder(graphics);
            PrintHelper.printAllComponents((Container)((Object)this), graphics);
        }
    }

    public static class UIComponentLightweightContainer
    extends MJPanel
    implements UIComponentHost {
        public UIComponentLightweightContainer() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
        }
    }

    public static interface UIComponentHost {
    }

    public static class UIPanelLightweightContainer
    extends MJPanel
    implements UIPanelHost {
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        public void printAll(Graphics graphics) {
            this.printComponent(graphics);
            this.printBorder(graphics);
            PrintHelper.printAllComponents((Container)((Object)this), graphics);
        }
    }

    public static interface UIPanelHost {
    }
}

