/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.jmi.Matlab;
import com.mathworks.util.PlatformInfo;

public class LightWeightManager {
    private boolean fInitialized = false;
    private boolean fUseLightWeightContainer = true;

    private void initialize() {
        if (this.fInitialized) {
            return;
        }
        this.setUsingLightWeightContainerImpl(this.isMacintosh() || !this.isMatlabAvailable());
    }

    protected boolean isMacintosh() {
        return LightWeightManager.defaultIsMacintosh();
    }

    protected boolean isMatlabAvailable() {
        return LightWeightManager.defaultIsMatlabAvailable();
    }

    protected static boolean defaultIsMacintosh() {
        return PlatformInfo.isMacintosh();
    }

    protected static boolean defaultIsMatlabAvailable() {
        return Matlab.isMatlabAvailable();
    }

    public static boolean defaultUseLightWeightContainer() {
        return LightWeightManager.defaultIsMacintosh() || !LightWeightManager.defaultIsMatlabAvailable();
    }

    public boolean useLightWeightContainer() {
        this.initialize();
        return this.fUseLightWeightContainer;
    }

    private void setUsingLightWeightContainerImpl(boolean bl) {
        this.fInitialized = true;
        this.fUseLightWeightContainer = bl;
    }

    public void setUseLightWeightContainer(boolean bl) throws InvalidConfigurationException {
        if (!bl && this.isMacintosh()) {
            throw new InvalidConfigurationException("Heavyweight not available on Macintosh");
        }
        if (!bl && !this.isMatlabAvailable()) {
            throw new InvalidConfigurationException("Heavyweight support only available when MATLAB is running");
        }
        this.setUsingLightWeightContainerImpl(bl);
    }

    public static class InvalidConfigurationException
    extends Exception {
        InvalidConfigurationException(String string) {
            super(string);
        }
    }
}

