/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractSplitButtonPeer;
import com.mathworks.hg.peer.CallbackTrigger;
import com.mathworks.hg.peer.ContextMenuPeer;
import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.HG2FigurePeer;
import com.mathworks.hg.peer.PopupMenuHideHelper;
import com.mathworks.hg.peer.event.UiMenuEvent;
import com.mathworks.hg.peer.event.UiMenuListener;
import com.mathworks.hg.peer.types.HGMotifCheckMenuItemUI;
import com.mathworks.hg.peer.types.HGMotifCheckMenuUI;
import com.mathworks.hg.peer.utils.MatlabIconComponent;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MenuPeer
implements CallbackTrigger,
HGPeerQueueUser {
    JMenuItem fMenu = null;
    Container fMenuParent = null;
    FigurePeer fParentFigure = null;
    int fChildCount = 0;
    String fAccelerator = null;
    Color fForegroundColor = Color.black;
    String fLabel = "";
    int fPosition = 0;
    JSeparator fSeparator = null;
    boolean fSeparatorInAdd = false;
    boolean fIsVisible = true;
    boolean fIsInMenuCallback = false;
    boolean fIsChecked = false;
    boolean fIsEnabled = true;
    String fName = "NO_NAME";
    boolean fCustomCheckboxEnabled = false;
    private MainMenuActionListener fMainMenuListener = null;
    private MenuItemActionListener fMenuItemListener = null;
    private transient Vector MenuListeners;
    private static final int MENU = 0;
    private static final int MENU_ITEM = 1;
    private static final int sFirstMethodIndex = 0;
    protected static final int sAddFigureMenuView = 0;
    protected static final int sAddMenuMenuView = 1;
    protected static final int sAddContextMenuMenuView = 2;
    protected static final int sRemoveMenuView = 3;
    protected static final int sSetMenuAccelerator = 4;
    protected static final int sSetMenuChecked = 5;
    protected static final int sSetMenuEnable = 6;
    protected static final int sSetMenuForegroundColor = 7;
    protected static final int sSetMenuLabel = 8;
    protected static final int sSetMenuPosition = 9;
    protected static final int sSetMenuSeparator = 10;
    protected static final int sSetMenuVisible = 11;
    protected static final int sStartFireCallback = 12;
    protected static final int sStopFireCallback = 13;
    protected static final int sShowPopupMenu = 14;
    protected static final int sCreateMenu = 15;
    protected static final int sInitializePeer = 16;
    protected static final int sAddPickerButtonMenuView = 17;
    protected static final int sSetComponentName = 18;
    private static final int sLastMethodIndex = 18;
    private static final String[] sLogMessages = new String[]{"addFigureMenuView", "addMenuMenuView", "addContextmenuMenuView", "removeMenuView", "setmenuAccelerator", "setMenuChecked", "setMenuEnable", "setMenuForegroundColor", "setMenuLabel", "setMenuPosition", "setMenuSeparator", "setMenuVisible", "startFireCallback", "stopFireCallback", "showPopupMenu", "createMenu", "initializePeer", "addPickerButtonMenuView", "setComponentName"};
    protected static final String sAccelPrepend = " Ctrl + ";

    public MenuPeer(int n) {
        this.createMenu(n);
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this.fParentFigure;
    }

    @Override
    public int getUserLastMethodID() {
        return MenuPeer.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 18) {
            string = sLogMessages[n - 0];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return 18;
    }

    private void createMenu(final int n) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 15, 2){

            @Override
            public void run() {
                MenuPeer.this.doCreateMenu(n);
            }
        });
    }

    private void doCreateMenu(int n) {
        if (this.fMenu != null) {
            return;
        }
        switch (n) {
            case 0: {
                this.fMenu = new FigureMJMenu();
                break;
            }
            case 1: {
                this.fMenu = new FigureMJMenuItem();
                break;
            }
            default: {
                throw new Error("Unrecognized menu type in createMenu: " + n);
            }
        }
        this.fMenu.setVisible(false);
    }

    private void addMenuActionListener() {
        if (this.fMenu != null) {
            if (this.fMenu instanceof FigureMJMenu) {
                if (this.fMainMenuListener == null) {
                    this.fMainMenuListener = new MainMenuActionListener();
                }
                ((FigureMJMenu)((Object)this.fMenu)).addMenuListener(this.fMainMenuListener);
            } else if (this.fMenu instanceof FigureMJMenuItem) {
                if (this.fMenuItemListener == null) {
                    this.fMenuItemListener = new MenuItemActionListener();
                }
                this.fMenu.addActionListener(this.fMenuItemListener);
            }
        }
    }

    private void removeMenuActionListener() {
        if (this.fMenu != null) {
            if (this.fMenu instanceof FigureMJMenu && this.fMainMenuListener != null) {
                ((FigureMJMenu)((Object)this.fMenu)).removeMenuListener(this.fMainMenuListener);
            } else if (this.fMenu instanceof FigureMJMenuItem && this.fMenuItemListener != null) {
                this.fMenu.removeActionListener(this.fMenuItemListener);
            }
        }
    }

    private void addMenuContainerListener(MJMenu mJMenu) {
        mJMenu.getPopupMenu().addContainerListener(new MenuContentChangeListener());
    }

    void addChildMenu(JMenuItem jMenuItem) {
        this.reconfigurePeer(true);
        if (null != this.fMenu && null != jMenuItem) {
            this.fMenu.add(jMenuItem);
        }
    }

    protected void reconfigurePeer(boolean bl) {
        if (this.fChildCount == 0) {
            this.changePeer(bl);
        }
    }

    private void changePeer(boolean bl) {
        if (null == this.fMenuParent) {
            return;
        }
        boolean bl2 = false;
        JMenuItem jMenuItem = this.getComponent();
        if (null == jMenuItem) {
            return;
        }
        MatlabIconComponent matlabIconComponent = null;
        if (bl && !(jMenuItem instanceof MJMenu)) {
            matlabIconComponent = new FigureMJMenu();
            this.addMenuContainerListener((MJMenu)matlabIconComponent);
            bl2 = true;
        } else if (!bl && !(jMenuItem instanceof FigureMJMenuItem)) {
            matlabIconComponent = new FigureMJMenuItem();
            bl2 = true;
        }
        if (bl2) {
            this.fMenu = matlabIconComponent;
            this.fMenu.setVisible(false);
            this.addMenuActionListener();
            int n = this.getComponentIndex(this.fMenuParent, jMenuItem);
            this.fMenuParent.add((Component)this.fMenu, n);
            if (null != this.fSeparator) {
                this.fMenuParent.remove(this.fSeparator);
            }
            this.fMenuParent.remove(jMenuItem);
            this.doSetLabel(this.fLabel);
            if (null != this.fAccelerator) {
                this.doSetAccelerator(this.fAccelerator);
            }
            this.doSetChecked(this.fIsChecked);
            this.doSetEnable(this.fIsEnabled);
            this.doSetForegroundColor(this.fForegroundColor);
            if (null != this.fSeparator) {
                this.doSetSeparator(true);
            }
            this.doSetVisible(this.fIsVisible);
            this.doSetName(this.fName);
        }
    }

    public JMenuItem getComponent() {
        return this.fMenu;
    }

    private int getComponentIndex(Container container, JMenuItem jMenuItem) {
        int n = -1;
        if (container instanceof MJMenu) {
            n = ((MJMenu)container).getPopupMenu().getComponentIndex(jMenuItem);
        } else if (container instanceof MJPopupMenu) {
            n = ((MJPopupMenu)container).getComponentIndex((Component)jMenuItem);
        } else if (this.isTopLevelMenu(container)) {
            n = ((JMenuBar)container).getComponentIndex(jMenuItem);
        }
        return n;
    }

    public int getChildCount() {
        return this.fChildCount;
    }

    public boolean isTopLevelMenu(Container container) {
        return container instanceof JMenuBar;
    }

    public void finishMenuAction() {
        if (this.fMenu != null && this.fMenu instanceof FigureMJMenu) {
            ((FigureMJMenu)((Object)this.fMenu)).showDelayedPopupMenu();
        }
    }

    public synchronized void removeMenuListener(UiMenuListener uiMenuListener) {
        if (this.MenuListeners != null && this.MenuListeners.contains(uiMenuListener)) {
            Vector vector = (Vector)this.MenuListeners.clone();
            vector.removeElement(uiMenuListener);
            this.MenuListeners = vector;
        }
    }

    public synchronized void addMenuListener(UiMenuListener uiMenuListener) {
        Vector vector;
        Vector vector2 = vector = this.MenuListeners == null ? new Vector(2) : (Vector)this.MenuListeners.clone();
        if (!vector.contains(uiMenuListener)) {
            vector.addElement(uiMenuListener);
            this.MenuListeners = vector;
        }
    }

    protected void fireMenuAction(UiMenuEvent uiMenuEvent) {
        FigureEditableComponentManager.commitCurrentEditableComponent();
        if (this.MenuListeners != null) {
            Vector vector = this.MenuListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((UiMenuListener)vector.elementAt(i)).MenuAction(uiMenuEvent);
            }
        }
    }

    public final void addMenu(final FigurePeer figurePeer) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 0, 0){

            @Override
            public void run() {
                MenuPeer.this.doAddMenu(figurePeer);
            }
        });
    }

    public final void addMenu(final MenuPeer menuPeer) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 1, 0){

            @Override
            public void run() {
                MenuPeer.this.doAddMenu(menuPeer);
            }
        });
    }

    public final void addMenu(final ContextMenuPeer contextMenuPeer) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 2, 0){

            @Override
            public void run() {
                MenuPeer.this.doAddMenu(contextMenuPeer);
            }
        });
    }

    public final void addMenu(final AbstractSplitButtonPeer abstractSplitButtonPeer) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 2, 0){

            @Override
            public void run() {
                MenuPeer.this.doAddMenu(abstractSplitButtonPeer);
            }
        });
    }

    public final void removeMenu() {
        HGUtils.invokeLater(new HGPeerRunnable(this, 3, 1){

            @Override
            public void run() {
                MenuPeer.this.doRemoveMenu();
            }
        });
    }

    @Override
    public final void startFireCallback() {
        HGUtils.invokeLater(new HGPeerRunnable(this, 12, 8){

            @Override
            public void run() {
                MenuPeer.this.doStartFireCallback();
            }
        });
    }

    @Override
    public final void stopFireCallback() {
        HGUtils.invokeLater(new HGPeerRunnable(this, 13, 8){

            @Override
            public void run() {
                MenuPeer.this.doStopFireCallback();
            }
        });
    }

    public final void initializePeerProperty(final double[] dArray, final String[] stringArray, final int[] nArray, final int n, final int n2) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 16){

            @Override
            public void run() {
                MenuPeer.this.doInitializePeerProperty(dArray, stringArray, nArray, n, n2);
            }
        });
    }

    protected void doInitializePeerProperty(double[] dArray, String[] stringArray, int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n3++;
        if (dArray[n5] > 0.0) {
            this.doSetForegroundColor(new Color((float)dArray[n3++], (float)dArray[n3++], (float)dArray[n3++]));
        }
        int n6 = n3++;
        if (dArray[n6] > 0.0) {
            this.doSetChecked(dArray[n3++] != 0.0);
        }
        int n7 = n3++;
        if (dArray[n7] > 0.0) {
            this.doSetEnable(dArray[n3++] != 0.0);
        }
        int n8 = n3++;
        if (dArray[n8] > 0.0) {
            this.doSetSeparator(dArray[n3++] != 0.0);
        }
        this.doSetLabel(stringArray[n4++]);
        this.doSetAccelerator(stringArray[n4++]);
        this.doSetName(stringArray[n4++]);
        int n9 = n3++;
        if (dArray[n9] > 0.0) {
            this.doSetVisible(dArray[n3++] != 0.0);
        }
    }

    public final void setAccelerator(final String string) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 4){

            @Override
            public void run() {
                MenuPeer.this.doSetAccelerator(string);
            }
        });
    }

    public final void setChecked(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 5){

            @Override
            public void run() {
                MenuPeer.this.doSetChecked(bl);
            }
        });
    }

    public final void setEnable(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 6){

            @Override
            public void run() {
                MenuPeer.this.doSetEnable(bl);
            }
        });
    }

    public final void setForegroundColor(final Color color) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 7){

            @Override
            public void run() {
                MenuPeer.this.doSetForegroundColor(color);
            }
        });
    }

    public final void setLabel(final String string) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 8){

            @Override
            public void run() {
                MenuPeer.this.doSetLabel(string);
            }
        });
    }

    public final void setSeparator(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 10){

            @Override
            public void run() {
                MenuPeer.this.doSetSeparator(bl);
            }
        });
    }

    public final void setVisible(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 11){

            @Override
            public void run() {
                MenuPeer.this.doSetVisible(bl);
            }
        });
    }

    public void setComponentName(final String string) {
        if (this.doPreSetName(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 18){

                @Override
                public void run() {
                    MenuPeer.this.doSetName(string);
                }
            });
        }
    }

    protected boolean doPreSetName(String string) {
        return true;
    }

    protected void doSetName(String string) {
        this.fName = string;
        this.fMenu.setName(string);
    }

    protected void setParentFigure(FigurePeer figurePeer) {
        this.fParentFigure = figurePeer;
    }

    protected FigurePeer getParentFigure() {
        return this.fParentFigure;
    }

    protected void doStartFireCallback() {
        this.addMenuActionListener();
    }

    protected void doStopFireCallback() {
        this.removeMenuActionListener();
    }

    protected void doAddMenu(FigurePeer figurePeer) {
        this.fParentFigure = figurePeer;
        this.fMenuParent = figurePeer.getMenuBar();
        if (this.fMenuParent != null && this.fMenu != null) {
            this.fMenuParent.add(this.fMenu);
        }
    }

    protected void doAddMenu(MenuPeer menuPeer) {
        menuPeer.addChildMenu(this.fMenu);
        this.fParentFigure = menuPeer.getParentFigure();
        this.fMenuParent = menuPeer.getComponent();
        this.doSetSeparator(this.fSeparatorInAdd);
    }

    protected void doAddMenu(ContextMenuPeer contextMenuPeer) {
        contextMenuPeer.addChildMenu(this.fMenu);
        this.fParentFigure = contextMenuPeer.getParentFigure();
        this.fMenuParent = contextMenuPeer.getComponent();
        this.doSetSeparator(this.fSeparatorInAdd);
    }

    protected void doAddMenu(AbstractSplitButtonPeer abstractSplitButtonPeer) {
        abstractSplitButtonPeer.addChildMenu(this.fMenu);
        this.fParentFigure = abstractSplitButtonPeer.getParentFigure();
        this.fMenuParent = abstractSplitButtonPeer.getMenuComponent();
        this.doSetSeparator(this.fSeparatorInAdd);
    }

    protected void doRemoveMenu() {
        if (this.fMenuParent != null) {
            if (null != this.fSeparator) {
                this.fMenuParent.remove(this.fSeparator);
            }
            if (this.fMenu != null) {
                this.fMenuParent.remove(this.fMenu);
            }
            if (this.fMenuParent.isShowing()) {
                this.fMenuParent.repaint();
            }
            this.fMenuParent = null;
            this.fParentFigure = null;
        }
    }

    protected void doSetAccelerator(String string) {
        this.fAccelerator = string;
        if (string != null && !(this.fMenu instanceof MJMenu)) {
            if (!string.isEmpty()) {
                if (!GraphicsEnvironment.isHeadless()) {
                    this.fMenu.setAccelerator(KeyStroke.getKeyStroke((int)string.toUpperCase().charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                }
            } else {
                this.fMenu.setAccelerator(null);
            }
            this.setAccessibleName();
        }
    }

    protected void doSetChecked(boolean bl) {
        if (this.fMenu == null) {
            return;
        }
        this.fIsChecked = bl;
        if (!this.fCustomCheckboxEnabled) {
            if (bl && this.fMenu instanceof MJMenu) {
                return;
            }
            this.fMenu.setSelected(bl);
        }
    }

    public boolean isChecked() {
        return this.fIsChecked;
    }

    protected void doSetEnable(boolean bl) {
        this.fIsEnabled = bl;
        if (this.fMenu != null) {
            this.fMenu.setEnabled(bl);
        }
    }

    protected void doSetForegroundColor(Color color) {
        this.fForegroundColor = color;
        if (this.fMenu != null) {
            this.fMenu.setForeground(color);
        }
    }

    protected void doSetLabel(String string) {
        this.fLabel = string.replaceAll("&&", "0x0x0f");
        this.fLabel = this.fLabel.replaceAll(" 0x0x0f ", " & ");
        this.fLabel = this.fLabel.replaceAll(" 0x0x0f", " & ");
        this.fLabel = this.fLabel.replaceAll("0x0x0f ", " & ");
        this.fLabel = this.fLabel.replaceAll("0x0x0f", " & ");
        if (this.fMenu != null) {
            this.fMenu.setText(this.fLabel);
        }
        this.setAccessibleName();
    }

    protected void doSetSeparator(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        int n = -1;
        if (this.fMenuParent == null) {
            this.fSeparatorInAdd = bl;
            return;
        }
        if (this.isTopLevelMenu(this.fMenuParent)) {
            return;
        }
        n = this.getComponentIndex(this.fMenuParent, this.fMenu);
        if (-1 != n) {
            if (bl) {
                if (null == this.fSeparator) {
                    this.fSeparator = new JSeparator();
                } else {
                    this.fMenuParent.remove(this.fSeparator);
                }
                this.fSeparator.setVisible(this.fMenu.isVisible());
                this.fMenuParent.add((Component)this.fSeparator, this.getComponentIndex(this.fMenuParent, this.fMenu));
            } else if (!bl && null != this.fSeparator && n > 0) {
                this.fMenuParent.remove(this.fSeparator);
                this.fSeparator = null;
            }
        }
    }

    protected void doSetVisible(boolean bl) {
        if (this.fMenu == null) {
            return;
        }
        this.fIsVisible = bl;
        this.fMenu.setVisible(bl);
        if (null != this.fSeparator) {
            if (PlatformInfo.isMacintosh() && System.getProperty("apple.laf.useScreenMenuBar") == "true") {
                if (bl) {
                    int n = this.getComponentIndex(this.fMenuParent, this.fMenu);
                    this.fMenuParent.add((Component)this.fSeparator, n);
                } else {
                    this.fMenuParent.remove(this.fSeparator);
                }
            } else {
                this.fSeparator.setVisible(bl);
            }
        }
    }

    protected void setAccessibleName() {
        if (this.fMenu != null) {
            if (this.fAccelerator != null && this.fAccelerator.length() > 0) {
                this.fMenu.getAccessibleContext().setAccessibleName(this.fMenu.getText() + sAccelPrepend + this.fAccelerator.charAt(0) + " " + MJUtilities.findMnemonic((String)this.fLabel));
            } else {
                this.fMenu.getAccessibleContext().setAccessibleName(this.fMenu.getText() + " " + MJUtilities.findMnemonic((String)this.fLabel));
            }
        }
    }

    private class FigureMJMenu
    extends MJMenu
    implements MatlabIconComponent {
        boolean fLastMenuVisible;
        private boolean fMouseOnTopOfTheComponent;

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (PlatformInfo.isLinux() || PlatformInfo.isSolaris()) {
                if (mouseEvent.getID() == 504) {
                    this.fMouseOnTopOfTheComponent = true;
                } else if (mouseEvent.getID() == 505) {
                    this.fMouseOnTopOfTheComponent = false;
                } else if (mouseEvent.getID() == 502 && !this.fMouseOnTopOfTheComponent) {
                    mouseEvent.consume();
                    return;
                }
                super.processMouseEvent(mouseEvent);
                return;
            }
            super.processMouseEvent(mouseEvent);
        }

        public FigureMJMenu() {
            this.fLastMenuVisible = false;
            this.fMouseOnTopOfTheComponent = false;
            this.initialize();
        }

        public FigureMJMenu(Action action) {
            super(action);
            this.fLastMenuVisible = false;
            this.fMouseOnTopOfTheComponent = false;
            this.initialize();
        }

        public FigureMJMenu(String string) {
            super(string);
            this.fLastMenuVisible = false;
            this.fMouseOnTopOfTheComponent = false;
            this.initialize();
        }

        public FigureMJMenu(String string, boolean bl) {
            super(string, bl);
            this.fLastMenuVisible = false;
            this.fMouseOnTopOfTheComponent = false;
            this.initialize();
        }

        protected void initialize() {
            this.setArmed(false);
            this.getPopupMenu();
        }

        @Override
        public boolean isIconDrawable() {
            return false;
        }

        public void updateUI() {
            String string = UIManager.getLookAndFeel().getClass().getName();
            if (string.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
                this.setUI(new HGMotifCheckMenuUI());
                MenuPeer.this.fCustomCheckboxEnabled = true;
            } else {
                super.updateUI();
            }
        }

        public void setPopupMenuVisible(boolean bl) {
            if (null != MenuPeer.this.fParentFigure) {
                this.fLastMenuVisible = bl;
                if (!MenuPeer.this.fIsInMenuCallback) {
                    if (MenuPeer.this.fParentFigure instanceof HG2FigurePeer || MenuPeer.this.fParentFigure.getOffscreenRendering() && MenuPeer.this.fParentFigure.useLightWeightContainer()) {
                        super.setPopupMenuVisible(bl);
                    } else {
                        PopupMenuHideHelper popupMenuHideHelper = new PopupMenuHideHelper();
                        popupMenuHideHelper.preVisibleChange(MenuPeer.this.fParentFigure.getAxisComponent(), this.getPopupMenu(), bl);
                        super.setPopupMenuVisible(bl);
                        popupMenuHideHelper.postVisibleChange();
                    }
                }
            } else {
                super.setPopupMenuVisible(bl);
            }
        }

        void showDelayedPopupMenu() {
            SwingUtilities.invokeLater(new HGPeerRunnable(MenuPeer.this, 14, 8){

                @Override
                public void run() {
                    MenuPeer.this.fIsInMenuCallback = false;
                    if (!PlatformInfo.isMacintosh() || System.getProperty("apple.laf.useScreenMenuBar") != "true") {
                        FigureMJMenu.this.setPopupMenuVisible(FigureMJMenu.this.fLastMenuVisible);
                    }
                }
            });
        }
    }

    private class FigureMJMenuItem
    extends MJCheckBoxMenuItem
    implements MatlabIconComponent {
        public FigureMJMenuItem() {
            this.initialize();
        }

        protected void initialize() {
            this.setArmed(false);
        }

        @Override
        public boolean isIconDrawable() {
            return MenuPeer.this.isChecked();
        }

        public void updateUI() {
            String string = UIManager.getLookAndFeel().getClass().getName();
            if (string.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
                this.setUI(new HGMotifCheckMenuItemUI());
                MenuPeer.this.fCustomCheckboxEnabled = true;
            } else {
                super.updateUI();
            }
        }

        protected void processComponentEvent(ComponentEvent componentEvent) {
            if (PlatformInfo.isMacintosh() && System.getProperty("apple.laf.useScreenMenuBar") == "true" && (componentEvent.getID() == 103 || componentEvent.getID() == 102)) {
                try {
                    super.processComponentEvent(componentEvent);
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                super.processComponentEvent(componentEvent);
            }
        }
    }

    private class MenuContentChangeListener
    extends ContainerAdapter {
        private MenuContentChangeListener() {
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            --MenuPeer.this.fChildCount;
            if (!MenuPeer.this.isTopLevelMenu(MenuPeer.this.fMenuParent)) {
                MenuPeer.this.reconfigurePeer(false);
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            ++MenuPeer.this.fChildCount;
        }
    }

    private class MainMenuActionListener
    implements MenuListener {
        private MainMenuActionListener() {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            UiMenuEvent uiMenuEvent = new UiMenuEvent(menuEvent.getSource());
            MenuPeer.this.fIsInMenuCallback = true;
            MenuPeer.this.fireMenuAction(uiMenuEvent);
        }
    }

    private class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MenuPeer.this.fCustomCheckboxEnabled) {
                MenuPeer.this.fMenu.setSelected(MenuPeer.this.isChecked());
            }
            UiMenuEvent uiMenuEvent = new UiMenuEvent(actionEvent.getSource());
            MenuPeer.this.fireMenuAction(uiMenuEvent);
        }
    }
}

