/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.mathworks.hg.peer.FigureMouseListener;
import com.mathworks.hg.peer.TabBackgroundColorChangedNotification;
import com.mathworks.hg.peer.TabForegroundColorChangedNotification;
import com.mathworks.hg.peer.TabTitleChangedNotification;
import com.mathworks.hg.peer.TabTooltipChangedNotification;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import com.mathworks.hg.peer.ui.TabGroupChild;
import com.mathworks.hg.peer.ui.UIContainerPeer;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class UITabPeer
extends UIContainerPeer
implements TabGroupChild {
    private static final int sFirstMethodIndex = UIContainerPeer.getLastMethodIndex();
    private static final int sSetTitle = sFirstMethodIndex + 1;
    private static final int sSetTooltipString = sFirstMethodIndex + 2;
    private static final int sPostUpdates = sFirstMethodIndex + 3;
    protected static final int sLastBaseMethodIndex = sFirstMethodIndex + 4;
    private static final String[] sLogMessagesBase = new String[]{"setTitle", "setTooltipString"};
    private String fTitleString = "";
    private String fTooltipString = "";
    private Color fForegroundColor = Color.BLACK;
    private Color fBackgroundColor = Color.LIGHT_GRAY;
    private boolean fEnable = true;
    private boolean fHasParent = false;

    @Override
    public void addComponent(UIComponentParentWithLayout uIComponentParentWithLayout, int n) {
        super.addComponent(uIComponentParentWithLayout, n);
        boolean bl = this.fHasParent = uIComponentParentWithLayout != null;
        assert (uIComponentParentWithLayout == this.getNotificationSuccessor());
    }

    @Override
    public void removeComponent(UIComponentParentWithLayout uIComponentParentWithLayout) {
        super.removeComponent(uIComponentParentWithLayout);
        this.fHasParent = false;
        assert (null == this.getNotificationSuccessor());
    }

    @Override
    protected void createPeerComponentImpl() {
        super.createPeerComponentImpl();
        FigureMouseListener figureMouseListener = new FigureMouseListener(){

            private Component getCanvas() {
                Component[] componentArray;
                Container container;
                Container container2;
                Component component = null;
                if (UITabPeer.this.fCompContainerProxy != null && (container2 = UITabPeer.this.fCompContainerProxy.getContainer()) != null && (container = container2.getParent()) != null && (componentArray = container.getComponents()).length == 2) {
                    component = componentArray[1];
                }
                return component;
            }

            private boolean shouldHandleEvent(MouseEvent mouseEvent) {
                Component component = this.getCanvas();
                if (component != null) {
                    if (mouseEvent.getComponent() == UITabPeer.this.fCompContainerProxy.getContainer()) {
                        component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                        mouseEvent.consume();
                        return false;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (this.shouldHandleEvent(mouseEvent)) {
                    super.mousePressed(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.shouldHandleEvent(mouseEvent)) {
                    super.mouseReleased(mouseEvent);
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.shouldHandleEvent(mouseEvent)) {
                    super.mouseDragged(mouseEvent);
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (this.shouldHandleEvent(mouseEvent)) {
                    super.mouseMoved(mouseEvent);
                }
            }
        };
        figureMouseListener.setNotificationSuccessor(this);
        this.fCompContainerProxy.getContainer().addMouseListener(figureMouseListener);
        this.fCompContainerProxy.getContainer().addMouseMotionListener(figureMouseListener);
    }

    public void setTitle(final String string) {
        HGTabPeerRunnable hGTabPeerRunnable = new HGTabPeerRunnable(this, sSetTitle){

            @Override
            public void run() {
                UITabPeer.this.doSetTitle(string);
            }
        };
        if (this.doPreSetTitle(string)) {
            HGUtils.invokeLater(hGTabPeerRunnable);
        }
    }

    private boolean doPreSetTitle(String string) {
        return true;
    }

    protected void doSetTitle(String string) {
        assert (EventQueue.isDispatchThread());
        this.fTitleString = string;
        this.setTitleThroughParent(this.fTitleString);
    }

    private void setTitleThroughParent(String string) {
        assert (EventQueue.isDispatchThread());
        if (this.fHasParent) {
            TabTitleChangedNotification tabTitleChangedNotification = new TabTitleChangedNotification(this.getTopLevelComponent(), string);
            this.handleNotification(tabTitleChangedNotification);
        }
    }

    public void setTooltipString(final String string) {
        HGTabPeerRunnable hGTabPeerRunnable = new HGTabPeerRunnable(this, sSetTooltipString){

            @Override
            public void run() {
                UITabPeer.this.doSetTooltipString(string);
            }
        };
        if (this.doPreSetTooltipString(string)) {
            HGUtils.invokeLater(hGTabPeerRunnable);
        }
    }

    private boolean doPreSetTooltipString(String string) {
        return true;
    }

    protected void doSetTooltipString(String string) {
        assert (EventQueue.isDispatchThread());
        this.fTooltipString = string;
        this.setTooltipThroughParent(this.fTooltipString);
    }

    private void setTooltipThroughParent(String string) {
        assert (EventQueue.isDispatchThread());
        if (this.fHasParent) {
            TabTooltipChangedNotification tabTooltipChangedNotification = new TabTooltipChangedNotification(this.getTopLevelComponent(), string);
            this.handleNotification(tabTooltipChangedNotification);
        }
    }

    @Override
    protected boolean doPreSetBackgroundColor(Color color) {
        return true;
    }

    @Override
    protected void doSetBackgroundColor(Color color) {
        assert (EventQueue.isDispatchThread());
        this.fBackgroundColor = color;
        this.setBackgroundColorThroughParent(this.fBackgroundColor);
    }

    private void setBackgroundColorThroughParent(Color color) {
        assert (EventQueue.isDispatchThread());
        if (this.fHasParent) {
            TabBackgroundColorChangedNotification tabBackgroundColorChangedNotification = new TabBackgroundColorChangedNotification(this.getTopLevelComponent(), color);
            this.handleNotification(tabBackgroundColorChangedNotification);
            this.fContainerProxy.getContainer().setBackground(this.fBackgroundColor);
        }
    }

    @Override
    public void setForegroundColor(final Color color) {
        HGTabPeerRunnable hGTabPeerRunnable = new HGTabPeerRunnable(this, 3){

            @Override
            public void run() {
                UITabPeer.this.doSetForegroundColor(color);
            }
        };
        if (this.doPreSetForegroundColor(color)) {
            HGUtils.invokeLater(hGTabPeerRunnable);
        }
    }

    @Override
    protected boolean doPreSetForegroundColor(Color color) {
        return true;
    }

    @Override
    protected void doSetForegroundColor(Color color) {
        assert (EventQueue.isDispatchThread());
        this.fForegroundColor = color;
        this.setForegroundColorThroughParent(this.fForegroundColor);
    }

    private void setForegroundColorThroughParent(Color color) {
        if (this.fHasParent) {
            TabForegroundColorChangedNotification tabForegroundColorChangedNotification = new TabForegroundColorChangedNotification(this.getTopLevelComponent(), color);
            this.handleNotification(tabForegroundColorChangedNotification);
        }
    }

    public HGRectangle getContentPosition() {
        return this.doPreGetContentPosition();
    }

    protected HGRectangle doPreGetContentPosition() {
        HGUtils.flushHGPeerQueue();
        SynchronousInvokeUtility.echo();
        HGRectangle hGRectangle = new HGRectangle(0.0, 0.0, 4.0, 4.0);
        Rectangle rectangle = this.getUIComponent().getBounds();
        hGRectangle.setX(rectangle.x);
        hGRectangle.setY(rectangle.y);
        hGRectangle.setWidth(rectangle.width);
        hGRectangle.setHeight(rectangle.height);
        return hGRectangle;
    }

    @Override
    protected HGPeerQueueUser getSourceHGPeer() {
        return (HGPeerQueueUser)((Object)this.getFigureChild());
    }

    @Override
    public Component getTabComponent() {
        return this.getTopLevelComponent();
    }

    private static abstract class HGTabPeerRunnable
    extends HGPeerRunnable {
        private UITabPeer fTabPeer;

        public HGTabPeerRunnable(UITabPeer uITabPeer, int n) {
            super(uITabPeer, n, 7, true);
            this.fTabPeer = uITabPeer;
        }

        @Override
        public HGPeerQueueUser getHGPeer() {
            return this.fTabPeer.getSourceHGPeer();
        }
    }
}

