/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.Graphics2DDecorator;
import com.mathworks.hg.print.OutputProcessingException;
import com.mathworks.hg.print.PaintConvertingGraphics2D;
import com.mathworks.hg.print.PenOffsetGraphics2D;
import com.mathworks.hg.print.TextureLimitingGraphics2D;
import com.mathworks.hg.print.VectorStrategy;
import com.mathworks.hg.util.MPrintJob;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class BatikSVGVectorStrategy
implements VectorStrategy {
    @Override
    public Graphics startJob(MPrintJob mPrintJob, OutputStream outputStream, FigurePanelContainer figurePanelContainer) {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
        sVGGeneratorContext.setEmbeddedFontsOn(true);
        boolean bl = mPrintJob.isOpenGLRenderer() || mPrintJob.getContainsTex();
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(sVGGeneratorContext, bl);
        int n = mPrintJob.getDesired_Width();
        int n2 = mPrintJob.getDesired_Height();
        sVGGraphics2D.setSVGCanvasSize(new Dimension(n, n2));
        Graphics2DDecorator graphics2DDecorator = new PenOffsetGraphics2D((Graphics)sVGGraphics2D);
        graphics2DDecorator = new TextureLimitingGraphics2D(graphics2DDecorator, 0);
        graphics2DDecorator = new PaintConvertingGraphics2D((Graphics)graphics2DDecorator);
        return graphics2DDecorator;
    }

    @Override
    public void startPage(MPrintJob mPrintJob, Graphics graphics, OutputStream outputStream) {
    }

    @Override
    public void endPage(Graphics graphics, OutputStream outputStream) {
    }

    @Override
    public void endJob(Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
        BufferedWriter bufferedWriter;
        Graphics2DDecorator graphics2DDecorator = (Graphics2DDecorator)graphics;
        if (graphics2DDecorator != null) {
            graphics = graphics2DDecorator.getUndecoratedGraphics();
        }
        SVGGraphics2D sVGGraphics2D = (SVGGraphics2D)graphics;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (IOException iOException) {
            throw new OutputProcessingException(iOException);
        }
        try {
            boolean bl = true;
            sVGGraphics2D.stream((Writer)bufferedWriter, bl);
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            throw new OutputProcessingException(sVGGraphics2DIOException);
        }
        try {
            ((Writer)bufferedWriter).flush();
        }
        catch (IOException iOException) {
            throw new OutputProcessingException(iOException);
        }
    }
}

