/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.Graphics2DDecorator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;

public class BoundingBoxCaptureGraphics
extends Graphics2DDecorator {
    private Bounds fBounds;
    private Dimension fPageSize;
    private BackgroundData fBackgroundData = null;
    private int fImageWidth;
    private int fImageHeight;

    public BoundingBoxCaptureGraphics(Graphics graphics, Dimension dimension, boolean bl, int n, int n2) {
        super(graphics);
        this.fPageSize = dimension;
        this.fBounds = new Bounds();
        this.fBackgroundData = new BackgroundData(bl);
        this.fImageWidth = n;
        this.fImageHeight = n2;
    }

    public BoundingBoxCaptureGraphics(Graphics graphics) {
        super(graphics);
    }

    @Override
    protected Graphics doCreateNew(Graphics graphics) {
        BoundingBoxCaptureGraphics boundingBoxCaptureGraphics = new BoundingBoxCaptureGraphics(graphics);
        boundingBoxCaptureGraphics.fBounds = this.fBounds;
        boundingBoxCaptureGraphics.fPageSize = this.fPageSize;
        boundingBoxCaptureGraphics.fBackgroundData = this.fBackgroundData;
        boundingBoxCaptureGraphics.fImageWidth = this.fImageWidth;
        boundingBoxCaptureGraphics.fImageHeight = this.fImageHeight;
        return boundingBoxCaptureGraphics;
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        Line2D.Double double_ = new Line2D.Double(n, n2, n3, n4);
        this.saveBoundsForLine(double_, 1);
        super.drawLine(n, n2, n3, n4);
    }

    @Override
    public void draw(Shape shape) {
        this.applyStrokeTransformAndSaveBounds(shape.getBounds2D());
        super.draw(shape);
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.applyStrokeTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.draw3DRect(n, n2, n3, n4, bl);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.applyStrokeTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.drawRect(n, n2, n3, n4);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.applyStrokeTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.applyStrokeTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.drawOval(n, n2, n3, n4);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.applyStrokeTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.drawArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.applyStrokeTransformAndSaveBounds(polygon.getBounds2D());
        super.drawPolygon(nArray, nArray2, n);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.applyStrokeTransformAndSaveBounds(polygon.getBounds2D());
        super.drawPolygon(polygon);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.applyStrokeTransformAndSaveBounds(polygon.getBounds2D());
        super.drawPolyline(nArray, nArray2, n);
    }

    @Override
    public void fill(Shape shape) {
        this.applyTransformAndSaveBounds(shape.getBounds2D());
        super.fill(shape);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        if (this.fBackgroundData.clearTheBackground() && n3 == this.fImageWidth && n4 == this.fImageHeight) {
            if (this.fBackgroundData.saveBoundsForFillRect()) {
                this.applyTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
            }
        } else {
            this.applyTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        }
        super.fillRect(n, n2, n3, n4);
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.applyTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.fill3DRect(n, n2, n3, n4, bl);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.applyTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.applyTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.fillOval(n, n2, n3, n4);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.applyTransformAndSaveBounds(new Rectangle(n, n2, n3, n4));
        super.fillArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.applyTransformAndSaveBounds(polygon.getBounds());
        super.fillPolygon(nArray, nArray2, n);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.applyTransformAndSaveBounds(polygon.getBounds());
        super.fillPolygon(polygon);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.applyTransformAndSaveBoundsForString(string, f, f2);
        super.drawString(string, f, f2);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.applyTransformAndSaveBoundsForString(string, n, n2);
        super.drawString(string, n, n2);
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.applyTransformAndSaveBoundsForString(new String(cArray), n3, n4);
        super.drawChars(cArray, n, n2, n3, n4);
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.applyTransformAndSaveBoundsForString(new String(byArray), n3, n4);
        super.drawBytes(byArray, n, n2, n3, n4);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Rectangle2D rectangle2D = BoundingBoxCaptureGraphics.translateRect(textLayout.getBounds(), n, n2);
        this.applyTransformAndSaveBounds(rectangle2D);
        super.drawString(attributedCharacterIterator, n, n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Rectangle2D rectangle2D = BoundingBoxCaptureGraphics.translateRect(textLayout.getBounds(), f, f2);
        this.applyTransformAndSaveBounds(rectangle2D);
        super.drawString(attributedCharacterIterator, f, f2);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        Rectangle2D rectangle2D = BoundingBoxCaptureGraphics.translateRect(shape.getBounds2D(), f, f2);
        this.applyTransformAndSaveBounds(rectangle2D);
        super.drawGlyphVector(glyphVector, f, f2);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(n, n2, image.getWidth(null), image.getHeight(null));
        this.applyTransformAndSaveBounds(rectangle);
        return super.drawImage(image, n, n2, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
        this.applyTransformAndSaveBounds(rectangle);
        return super.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
        this.applyTransformAndSaveBounds(rectangle);
        return super.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.applyTransformAndSaveBounds(rectangle);
        return super.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.applyTransformAndSaveBounds(rectangle);
        return super.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(n, n2, image.getWidth(null), image.getHeight(null));
        this.applyTransformAndSaveBounds(rectangle);
        return super.drawImage(image, n, n2, color, imageObserver);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        this.applyTransformAndSaveBounds(rectangle);
        super.drawRenderedImage(renderedImage, affineTransform);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        this.applyTransformAndSaveBounds(double_);
        super.drawRenderableImage(renderableImage, affineTransform);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        Rectangle rectangle = new Rectangle(n, n2, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.applyTransformAndSaveBounds(rectangle);
        super.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    private void saveBoundsForLine(Line2D line2D, int n) {
        Rectangle2D rectangle2D = line2D.getBounds2D();
        BasicStroke basicStroke = (BasicStroke)this.getStroke();
        double d = basicStroke.getLineWidth();
        if (d > 1.0) {
            rectangle2D = BoundingBoxCaptureGraphics.adjustBoundsForLineWidth(d, rectangle2D);
        }
        AffineTransform affineTransform = this.getTransform();
        Rectangle2D rectangle2D2 = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
        if (n != 0) {
            rectangle2D2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() + (double)n, rectangle2D2.getHeight() + (double)n);
        }
        if (rectangle2D2 != null) {
            this.saveXYBoundingCoordinates(rectangle2D2);
        }
    }

    private static Rectangle2D adjustBoundsForLineWidth(double d, Rectangle2D rectangle2D) {
        double d2 = d / 2.0;
        return new Rectangle2D.Double(rectangle2D.getX() - d2, rectangle2D.getY() - d2, rectangle2D.getWidth() + d, rectangle2D.getHeight() + d);
    }

    private void applyStrokeTransformAndSaveBounds(Rectangle2D rectangle2D) {
        Stroke stroke = this.getStroke();
        Shape shape = stroke.createStrokedShape(rectangle2D);
        this.applyTransformAndSaveBounds(shape.getBounds2D());
    }

    private void applyTransformAndSaveBounds(Rectangle2D rectangle2D) {
        AffineTransform affineTransform = this.getTransform();
        Rectangle2D rectangle2D2 = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
        this.saveXYBoundingCoordinates(rectangle2D2);
    }

    private void applyTransformAndSaveBoundsForString(String string, double d, double d2) {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this);
        rectangle2D = BoundingBoxCaptureGraphics.translateRect(rectangle2D, d, d2);
        this.applyTransformAndSaveBounds(rectangle2D);
    }

    private void saveXYBoundingCoordinates(Rectangle2D rectangle2D) {
        this.fBounds.intersectWith(rectangle2D);
    }

    public Integer[] getBBoxArray() {
        if (this.fBounds.hasBounds()) {
            double d = Math.max(this.fPageSize.getHeight() - this.fBounds.getLowerY(), 0.0);
            double d2 = Math.max(this.fPageSize.getHeight() - this.fBounds.getUpperY(), 0.0);
            return new Integer[]{(int)this.fBounds.getLowerX(), (int)d2, (int)this.fBounds.getUpperX(), (int)d};
        }
        return new Integer[]{0, 0, 0, 0};
    }

    private static Rectangle2D translateRect(Rectangle2D rectangle2D, int n, int n2) {
        return BoundingBoxCaptureGraphics.translateRect(rectangle2D, (double)n, (double)n2);
    }

    private static Rectangle2D translateRect(Rectangle2D rectangle2D, float f, float f2) {
        return BoundingBoxCaptureGraphics.translateRect(rectangle2D, (double)f, (double)f2);
    }

    private static Rectangle2D translateRect(Rectangle2D rectangle2D, double d, double d2) {
        if (d != 0.0 && d2 != 0.0) {
            return new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    private static class BackgroundData {
        private boolean fClearTheBackground = false;
        private int fIgnoreFillCount = 0;
        private static final int EXPECTED_NUM_OF_FILLS_FOR_CLEAR = 2;

        BackgroundData(boolean bl) {
            this.fClearTheBackground = bl;
        }

        boolean clearTheBackground() {
            return this.fClearTheBackground;
        }

        public boolean saveBoundsForFillRect() {
            return ++this.fIgnoreFillCount > 2;
        }
    }

    private static class Bounds {
        private boolean fAnySaved = false;
        private double fLowerX = Double.POSITIVE_INFINITY;
        private double fUpperX = Double.NEGATIVE_INFINITY;
        private double fLowerY = Double.POSITIVE_INFINITY;
        private double fUpperY = Double.NEGATIVE_INFINITY;

        private Bounds() {
        }

        public void intersectWith(Rectangle2D rectangle2D) {
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            double d3 = rectangle2D.getMinY();
            double d4 = rectangle2D.getMaxY();
            if (d < this.fLowerX) {
                this.fLowerX = d;
            }
            if (d2 > this.fUpperX) {
                this.fUpperX = d2;
            }
            if (d3 < this.fLowerY) {
                this.fLowerY = d3;
            }
            if (d4 > this.fUpperY) {
                this.fUpperY = d4;
            }
            this.fAnySaved = true;
        }

        public double getLowerX() {
            return this.fLowerX;
        }

        public double getUpperX() {
            return this.fUpperX;
        }

        public double getLowerY() {
            return this.fLowerY;
        }

        public double getUpperY() {
            return this.fUpperY;
        }

        public boolean hasBounds() {
            return this.fAnySaved;
        }
    }
}

