/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.Graphics2DDecorator;
import com.mathworks.hg.print.TextureInfo;
import com.mathworks.hg.uij.SolidPaint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class PaintConvertingGraphics2D
extends Graphics2DDecorator {
    public PaintConvertingGraphics2D(Graphics graphics) {
        super(graphics);
    }

    @Override
    protected Graphics doCreateNew(Graphics graphics) {
        return new PaintConvertingGraphics2D(graphics);
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Paint paint = this.convertCurrentPaint(new Rectangle(n, n2, n3, n4));
        this.get2DContained().draw3DRect(n, n2, n3, n4, bl);
        this.setPaint(paint);
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Paint paint = this.convertCurrentPaint(new Rectangle(n, n2, n3, n4));
        this.get2DContained().fill3DRect(n, n2, n3, n4, bl);
        this.setPaint(paint);
    }

    @Override
    public void draw(Shape shape) {
        Paint paint = this.convertCurrentPaint(shape.getBounds2D());
        this.get2DContained().draw(shape);
        this.setPaint(paint);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        Paint paint = this.convertCurrentPaint(new Rectangle(Math.min(n, n3), Math.min(n2, n4), Math.abs(n3 - n), Math.abs(n4 - n2)));
        this.get2DContained().drawLine(n, n2, n3, n4);
        this.setPaint(paint);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        Paint paint = this.convertCurrentPaint(new Rectangle(n, n2, n3, n4));
        this.get2DContained().fillRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        Paint paint = this.convertCurrentPaint(new Rectangle(n, n2, n3, n4));
        this.get2DContained().drawRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Paint paint = this.convertCurrentPaint(new Rectangle(n, n2, n3, n4));
        this.get2DContained().drawRoundRect(n, n2, n3, n4, n5, n6);
        this.setPaint(paint);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6);
        Paint paint = this.convertCurrentPaint(double_);
        this.get2DContained().fillRoundRect(n, n2, n3, n4, n5, n6);
        this.setPaint(paint);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        Paint paint = this.convertCurrentPaint(new Rectangle(n, n2, n3, n4));
        this.get2DContained().drawOval(n, n2, n3, n4);
        this.setPaint(paint);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(n, n2, n3, n4);
        Paint paint = this.convertCurrentPaint(double_);
        this.get2DContained().fillOval(n, n2, n3, n4);
        this.setPaint(paint);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Paint paint = this.convertCurrentPaint(new Rectangle(n, n2, n3, n4));
        this.get2DContained().drawArc(n, n2, n3, n4, n5, n6);
        this.setPaint(paint);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Double double_ = new Arc2D.Double(n, n2, n3, n4, n5, n6, 2);
        Paint paint = this.convertCurrentPaint(double_);
        this.get2DContained().fillArc(n, n2, n3, n4, n5, n6);
        this.setPaint(paint);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        Paint paint = this.convertCurrentPaint(polygon.getBounds2D());
        this.get2DContained().drawPolyline(nArray, nArray2, n);
        this.setPaint(paint);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        Paint paint = this.convertCurrentPaint(polygon.getBounds2D());
        this.get2DContained().drawPolygon(polygon);
        this.setPaint(paint);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fillPolygon(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        Paint paint = this.convertCurrentPaint(polygon);
        this.get2DContained().fillPolygon(polygon);
        this.setPaint(paint);
    }

    @Override
    public void fill(Shape shape) {
        Paint paint = this.convertCurrentPaint(shape);
        this.get2DContained().fill(shape);
        this.setPaint(paint);
    }

    private Paint convertCurrentPaint(Shape shape) {
        return this.convertCurrentPaint(shape.getBounds2D());
    }

    private Paint convertCurrentPaint(Rectangle2D rectangle2D) {
        Paint paint = this.getPaint();
        if (paint instanceof GradientPaint && ((GradientPaint)paint).getColor1().equals(((GradientPaint)paint).getColor2())) {
            this.setPaint(((GradientPaint)paint).getColor1());
        } else if (paint instanceof SolidPaint) {
            Color color = ((SolidPaint)paint).getColor();
            this.setPaint(color);
        } else if (!(paint instanceof Color) && !(paint instanceof TexturePaint)) {
            TexturePaint texturePaint = this.convertPaintToTexturePaint(paint, rectangle2D);
            this.setPaint(texturePaint);
        }
        return paint;
    }

    private TexturePaint convertPaintToTexturePaint(Paint paint, Rectangle2D rectangle2D) {
        BufferedImage bufferedImage = this.convertPaintToImage(paint, rectangle2D);
        return new TexturePaint(bufferedImage, rectangle2D);
    }

    private BufferedImage convertPaintToImage(Paint paint, Rectangle2D rectangle2D) {
        Dimension dimension = this.getBestTextureSize(paint, rectangle2D);
        int n = Math.max(1, dimension.width);
        int n2 = Math.max(1, dimension.height);
        double d = (double)n / rectangle2D.getWidth();
        double d2 = (double)n2 / rectangle2D.getHeight();
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d2);
        affineTransform.translate(-(rectangle2D.getX() + 1.0), -(rectangle2D.getY() + 1.0));
        PaintContext paintContext = paint.createContext(null, rectangle, rectangle2D, affineTransform, null);
        Raster raster = paintContext.getRaster(0, 0, n, n2);
        ColorModel colorModel = paintContext.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, raster.createCompatibleWritableRaster(), colorModel.isAlphaPremultiplied(), null);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    private Dimension getBestTextureSize(Paint paint, Rectangle2D rectangle2D) {
        int n = -1;
        int n2 = -1;
        if (paint instanceof TextureInfo) {
            Dimension dimension = ((TextureInfo)((Object)paint)).getBestTextureSize();
            n = dimension.width;
            n2 = dimension.height;
        }
        if (n < 0 || n2 < 0) {
            int n3;
            int n4;
            if (paint instanceof TexturePaint) {
                BufferedImage bufferedImage = ((TexturePaint)paint).getImage();
                n4 = bufferedImage.getWidth();
                n3 = bufferedImage.getHeight();
            } else if (paint instanceof Color) {
                n4 = 1;
                n3 = 1;
            } else {
                n4 = (int)Math.ceil(2.0 * rectangle2D.getWidth());
                n3 = (int)Math.ceil(2.0 * rectangle2D.getHeight());
            }
            if (n < 0) {
                n = n4;
            }
            if (n2 < 0) {
                n2 = n3;
            }
        }
        return new Dimension(n, n2);
    }
}

