/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print.metafile;

import com.mathworks.hg.print.metafile.SunFontProxy;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public abstract class LogicalFontResolver {
    public static List<FontStringPair> resolveFonts(Font font, String string) {
        ArrayList<FontStringPair> arrayList = new ArrayList<FontStringPair>(3);
        if (string.isEmpty()) {
            return arrayList;
        }
        SunFontProxy sunFontProxy = SunFontProxy.getInstance();
        if (!sunFontProxy.isValid()) {
            arrayList.add(new FontStringPair(font, string));
            return arrayList;
        }
        Object object = sunFontProxy.getFont2D(font);
        if (object == null || !sunFontProxy.isCompositeFont(object)) {
            arrayList.add(new FontStringPair(font, string));
        } else {
            int[] nArray = new int[string.length()];
            sunFontProxy.charsToGlyphs(object, string.length(), string.toCharArray(), nArray);
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            for (int i = 0; i < string.length(); ++i) {
                int n4 = sunFontProxy.getSlot(nArray[i]);
                if (n4 != n3 && n3 >= 0) {
                    Font font2 = LogicalFontResolver.createPhysicalFont(sunFontProxy, object, n3, font);
                    arrayList.add(new FontStringPair(font2, string.substring(n, n2)));
                    n = n2;
                }
                ++n2;
                n3 = n4;
            }
            Font font3 = LogicalFontResolver.createPhysicalFont(sunFontProxy, object, n3, font);
            arrayList.add(new FontStringPair(font3, string.substring(n, n2)));
        }
        return arrayList;
    }

    private static Font createPhysicalFont(SunFontProxy sunFontProxy, Object object, int n, Font font) {
        Object object2 = sunFontProxy.getSlotFont(object, n);
        Font font2 = new Font(sunFontProxy.getFamilyName(object2), sunFontProxy.getStyle(object2), 1);
        font2 = font2.deriveFont(font.getSize2D());
        return font2;
    }

    public static class FontStringPair {
        private Font fFont;
        private String fString;

        public FontStringPair(Font font, String string) {
            this.fFont = font;
            this.fString = string;
        }

        public Font getFont() {
            return this.fFont;
        }

        public String getString() {
            return this.fString;
        }
    }
}

