/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.hg.types.table.TablePropertyModel;
import com.mathworks.hg.types.table.panel.AbstractEditorPanel;
import com.mathworks.hg.types.table.panel.PanelFactory;
import com.mathworks.hg.types.table.panel.PropertyPanelEnum;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.widgets.WindowPositionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class TableEditor
extends MJPanel
implements WindowListener {
    public static final ResourceBundle EDITOR_RESOURCES = ResourceBundle.getBundle("com.mathworks.hg.types.table.resources.RES_TableEditor");
    public static final ResourceBundle NOTRANS_EDITOR_RESOURCES = ResourceBundle.getBundle("com.mathworks.hg.types.table.resources.RES_TableEditor_notranslation");
    private static final int LIST_DEF_WIDTH = 90;
    private Object control;
    private Map uddPropertyMap;
    private RegistryHandler registryListener;
    private TablePropertyModel tablePropertyModel;
    private MJSplitPane splitPane;
    private MJList panelsList;
    private Map<PropertyPanelEnum, AbstractEditorPanel> panelMap;

    public static void showTableEditorDialog(Frame frame, Object object, boolean bl) {
        TableEditor.showTableEditorDialog(frame, object, "ColumnName", bl);
    }

    public static void showTableEditorDialog(Frame frame, Object object, String string, boolean bl) {
        MJDialog mJDialog = new MJDialog(frame, bl);
        TableEditor tableEditor = new TableEditor(object);
        tableEditor.setBorder(Borders.DIALOG_BORDER);
        mJDialog.setContentPane((Container)((Object)tableEditor));
        mJDialog.setTitle(EDITOR_RESOURCES.getString("window.title"));
        mJDialog.setName(NOTRANS_EDITOR_RESOURCES.getString("window.name"));
        mJDialog.getAccessibleContext().setAccessibleDescription(mJDialog.getTitle());
        mJDialog.addWindowListener((WindowListener)tableEditor);
        mJDialog.setDefaultCloseOperation(2);
        mJDialog.setResizable(true);
        mJDialog.setCloseOnEscapeEnabled(true);
        mJDialog.setSize(new Dimension(800, 600));
        mJDialog.setLocationRelativeTo((Component)frame);
        WindowPositionUtils.positionWindow((Window)mJDialog, (String)"Guide.TableEditor", (Component)frame, (Rectangle)mJDialog.getBounds());
        tableEditor.editProperty(string);
        mJDialog.show();
    }

    public TableEditor(Object object) {
        this.control = object;
        this.initializeProperties();
        this.initializePanels();
        this.buildPanel();
    }

    private void addListener() {
        if (this.control != null && ObjectRegistry.getLayoutRegistry().getOwner(this.control) != null) {
            this.registryListener = new RegistryHandler();
            ObjectRegistry.getLayoutRegistry().addItemListener((ItemListener)this.registryListener);
            ObjectRegistry.getLayoutRegistry().addObjectRegistryListener((ObjectRegistryListener)this.registryListener);
        }
    }

    private void removeListener() {
        if (this.registryListener != null) {
            ObjectRegistry.getLayoutRegistry().removeItemListener((ItemListener)this.registryListener);
            ObjectRegistry.getLayoutRegistry().removeObjectRegistryListener((ObjectRegistryListener)this.registryListener);
        }
    }

    private void initializeProperties() {
        this.tablePropertyModel = new TablePropertyModel();
        TableEditorPopulateWorker tableEditorPopulateWorker = new TableEditorPopulateWorker();
        tableEditorPopulateWorker.start();
    }

    private void initializePanels() {
        this.panelMap = new HashMap<PropertyPanelEnum, AbstractEditorPanel>();
    }

    private void buildPanel() {
        this.panelsList = this.buildPanelsList();
        this.buildSplitPane((Component)this.wrapPanelsListInScrollPane(this.panelsList));
        FormLayout formLayout = new FormLayout("fill:p:g(1.0)", "fill:p:g(1.0), 4dlu, p, 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.splitPane, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildSamplePanel(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.buildButtonBar(), cellConstraints.xy(1, 5));
        panelBuilder.setBorder(Borders.DIALOG_BORDER);
        this.editProperty("ColumnName");
    }

    private MJList buildPanelsList() {
        ArrayList<PropertyPanelEnum> arrayList = new ArrayList<PropertyPanelEnum>();
        for (PropertyPanelEnum propertyPanelEnum : PropertyPanelEnum.values()) {
            if (propertyPanelEnum == PropertyPanelEnum.TABLE) continue;
            arrayList.add(propertyPanelEnum);
        }
        MJList mJList = new MJList(arrayList.toArray());
        mJList.getAccessibleContext().setAccessibleName(EDITOR_RESOURCES.getString("acc.main.categories"));
        mJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TableEditor.this.changePanel();
                }
            }
        });
        Dimension dimension = mJList.getPreferredSize();
        int n = dimension.width > 90 ? dimension.width : 90;
        mJList.setPreferredSize(new Dimension(n, dimension.height));
        mJList.setMinimumSize(mJList.getPreferredSize());
        mJList.setBorder(Borders.createEmptyBorder((String)"1dlu, 2dlu, 1dlu, 2dlu"));
        return mJList;
    }

    private MJScrollPane wrapPanelsListInScrollPane(MJList mJList) {
        MJScrollPane mJScrollPane = new MJScrollPane((Component)mJList);
        mJScrollPane.setPreferredSize(mJList.getPreferredSize());
        mJScrollPane.setMinimumSize(mJList.getMinimumSize());
        mJScrollPane.setHorizontalScrollBarPolicy(31);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        mJScrollPane.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        return mJScrollPane;
    }

    private void buildSplitPane(Component component) {
        this.splitPane = new MJSplitPane(1, true, component, (Component)new MJPanel());
        this.splitPane.setDividerSize(0);
        BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)this.splitPane.getUI();
        basicSplitPaneUI.getDivider().setBorder(Borders.EMPTY_BORDER);
        this.splitPane.setEnabled(false);
        this.splitPane.setBorder(Borders.EMPTY_BORDER);
        this.splitPane.setResizeWeight(0.0);
        this.splitPane.setPreferredSize(new Dimension(100, 100));
    }

    private JPanel buildSamplePanel() {
        return new MJPanel((LayoutManager)new BorderLayout());
    }

    private JPanel buildButtonBar() {
        MJButton mJButton = new MJButton(EDITOR_RESOURCES.getString("buttons.ok"));
        mJButton.setName(NOTRANS_EDITOR_RESOURCES.getString("buttons.ok"));
        mJButton.setToolTipText(EDITOR_RESOURCES.getString("buttons.tip_ok"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TableEditor.this.doApply(true)) {
                    TableEditor.this.doCancel();
                }
            }
        });
        MJButton mJButton2 = new MJButton(EDITOR_RESOURCES.getString("buttons.cancel"));
        mJButton2.setName(NOTRANS_EDITOR_RESOURCES.getString("buttons.cancel"));
        mJButton2.setToolTipText(EDITOR_RESOURCES.getString("buttons.tip_cancel"));
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.doCancel();
            }
        });
        MJButton mJButton3 = new MJButton(EDITOR_RESOURCES.getString("buttons.apply"));
        mJButton3.setName(NOTRANS_EDITOR_RESOURCES.getString("buttons.apply"));
        mJButton3.setToolTipText(EDITOR_RESOURCES.getString("buttons.tip_apply"));
        mJButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.doApply(false);
            }
        });
        MJButton mJButton4 = new MJButton(EDITOR_RESOURCES.getString("buttons.help"));
        mJButton4.setName(NOTRANS_EDITOR_RESOURCES.getString("buttons.help"));
        mJButton4.setToolTipText(EDITOR_RESOURCES.getString("buttons.tip_help"));
        mJButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MLHelpServices.getDocRoot() + "/techdoc/creating_guis/creating_guis.map";
                MLHelpServices.cshDisplayTopic((Object)((JComponent)actionEvent.getSource()).getTopLevelAncestor(), (String)string, (String)"defining_tables");
            }
        });
        MJButton mJButton5 = new MJButton(EDITOR_RESOURCES.getString("buttons.more"));
        mJButton5.setName(NOTRANS_EDITOR_RESOURCES.getString("buttons.more"));
        mJButton5.setToolTipText(EDITOR_RESOURCES.getString("buttons.tip_more"));
        mJButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLInspectorServices.activateInspector();
            }
        });
        JPanel jPanel = ButtonBarFactory.buildOKCancelApplyHelpBar((JButton)mJButton, (JButton)mJButton2, (JButton)mJButton3, (JButton)mJButton4);
        mJButton5.setVisible(false);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addFixedNarrow((JComponent)mJButton5);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)jPanel);
        return buttonBarBuilder.getPanel();
    }

    private AbstractEditorPanel getEditorPanel(PropertyPanelEnum propertyPanelEnum) {
        AbstractEditorPanel abstractEditorPanel;
        if (this.panelMap.containsKey((Object)propertyPanelEnum) && (abstractEditorPanel = this.panelMap.get((Object)propertyPanelEnum)) != null) {
            return abstractEditorPanel;
        }
        abstractEditorPanel = PanelFactory.createPanel(propertyPanelEnum, this.tablePropertyModel);
        this.panelMap.put(propertyPanelEnum, abstractEditorPanel);
        return abstractEditorPanel;
    }

    private AbstractEditorPanel getActivePanel() {
        return (AbstractEditorPanel)((Object)this.splitPane.getRightComponent());
    }

    private void changePanel() {
        AbstractEditorPanel abstractEditorPanel = this.getActivePanel();
        final PropertyPanelEnum propertyPanelEnum = abstractEditorPanel.getEditorPanelType();
        PropertyPanelEnum propertyPanelEnum2 = (PropertyPanelEnum)((Object)this.panelsList.getSelectedValue());
        if (propertyPanelEnum2 == propertyPanelEnum) {
            return;
        }
        boolean bl = abstractEditorPanel.validatePanel();
        if (bl) {
            this.splitPane.setRightComponent((Component)((Object)this.getEditorPanel(propertyPanelEnum2)));
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableEditor.this.panelsList.setSelectedValue((Object)propertyPanelEnum, true);
                }
            });
        }
    }

    private void doCancel() {
        this.removeListener();
        for (PropertyPanelEnum propertyPanelEnum : this.panelMap.keySet()) {
            AbstractEditorPanel abstractEditorPanel = this.panelMap.get((Object)propertyPanelEnum);
            if (abstractEditorPanel == null) continue;
            abstractEditorPanel.cleanup();
        }
        Window window = (Window)this.getTopLevelAncestor();
        if (window != null) {
            window.dispose();
        }
    }

    private boolean doApply(boolean bl) {
        AbstractEditorPanel abstractEditorPanel = this.getActivePanel();
        boolean bl2 = abstractEditorPanel.validatePanel();
        if (!bl2) {
            return false;
        }
        this.applyTableModel();
        TableEditorApplyWorker tableEditorApplyWorker = new TableEditorApplyWorker();
        tableEditorApplyWorker.start();
        if (!bl) {
            TableEditorPopulateWorker tableEditorPopulateWorker = new TableEditorPopulateWorker();
            tableEditorPopulateWorker.start();
        }
        return true;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.doApply(true);
        this.doCancel();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private Object getObjectValue(String string) {
        return this.uddPropertyMap.get(string);
    }

    private void setObjectValue(String string, Object object) {
        if (this.uddPropertyMap.containsKey(string)) {
            this.uddPropertyMap.put(string, object);
        }
    }

    private void populateTableModel() {
        PropertyPanelEnum[] propertyPanelEnumArray = PropertyPanelEnum.values();
        for (PropertyPanelEnum propertyPanelEnum : propertyPanelEnumArray) {
            String[] stringArray;
            for (String string : stringArray = propertyPanelEnum.getNamesOfCoveredProperties()) {
                this.tablePropertyModel.putProperty(string, this.getObjectValue(string));
            }
        }
        for (PropertyPanelEnum propertyPanelEnum : this.panelMap.keySet()) {
            AbstractEditorPanel abstractEditorPanel = this.panelMap.get((Object)propertyPanelEnum);
            if (abstractEditorPanel == null) continue;
            abstractEditorPanel.update();
        }
    }

    private void applyTableModel() {
        PropertyPanelEnum[] propertyPanelEnumArray = this.panelMap.keySet().iterator();
        while (propertyPanelEnumArray.hasNext()) {
            PropertyPanelEnum[] propertyPanelEnumArray2 = propertyPanelEnumArray.next();
            AbstractEditorPanel abstractEditorPanel = this.panelMap.get(propertyPanelEnumArray2);
            if (abstractEditorPanel == null) continue;
            abstractEditorPanel.commit();
        }
        for (PropertyPanelEnum propertyPanelEnum : propertyPanelEnumArray = PropertyPanelEnum.values()) {
            String[] stringArray;
            for (String string : stringArray = propertyPanelEnum.getNamesOfCoveredProperties()) {
                this.setObjectValue(string, this.tablePropertyModel.getProperty(string));
            }
        }
    }

    private void editProperty(String string) {
        PropertyPanelEnum propertyPanelEnum = PropertyPanelEnum.parsePropertyName(string);
        if (propertyPanelEnum != null) {
            this.splitPane.setRightComponent((Component)((Object)this.getEditorPanel(propertyPanelEnum)));
            this.panelsList.setSelectedValue((Object)propertyPanelEnum, true);
        }
    }

    class RegistryHandler
    implements ObjectRegistryListener,
    ItemListener {
        RegistryHandler() {
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
            if (this.isControlInvolved(objectRegistryEvent.getObjects())) {
                TableEditor.this.control = null;
            }
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            if (this.isControlInvolved(objectRegistryEvent.getObjects())) {
                TableEditor.this.populateTableModel();
            }
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
        }

        private boolean isControlInvolved(Object[] objectArray) {
            boolean bl = false;
            if (TableEditor.this.control != null && objectArray != null) {
                for (Object object : objectArray) {
                    if (!TableEditor.this.control.equals(object)) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }
    }

    public class TableEditorApplyWorker
    extends MatlabWorker {
        public Object runOnMatlabThread() throws Exception {
            Object[] objectArray = TableEditor.this.uddPropertyMap.keySet().toArray();
            Object[] objectArray2 = TableEditor.this.uddPropertyMap.values().toArray();
            Object[] objectArray3 = new Object[]{"setProperties", new Object[]{TableEditor.this.control}, objectArray, objectArray2};
            TableEditorApplyWorker.feval((String)"guidefunc", (Object[])objectArray3, (int)0);
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (TableEditor.this.control != null && ObjectRegistry.getLayoutRegistry().getOwner(TableEditor.this.control) != null) {
                ObjectRegistry.getLayoutRegistry().change(new Object[]{TableEditor.this.control});
            }
        }
    }

    public class TableEditorPopulateWorker
    extends MatlabWorker {
        public Object runOnMatlabThread() throws Exception {
            Object[] objectArray = new Object[]{"getProperties", new Object[]{TableEditor.this.control}, 1};
            int n = 2;
            Object object = TableEditorPopulateWorker.feval((String)"guidefunc", (Object[])objectArray, (int)n);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String[] stringArray = (String[])((Object[])object)[0];
            Object[] objectArray2 = (Object[])((Object[])object)[1];
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], objectArray2[i]);
            }
            return hashMap;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            TableEditor.this.uddPropertyMap = (Map)object;
            TableEditor.this.populateTableModel();
        }
    }
}

