/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.uij.TextRasterizer;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class CharacterSizeCalcProxy {
    protected Rectangle2D fCharSize;

    public Rectangle2D getLogicalBounds(final String string, final int n, final int n2, final int n3) throws Throwable {
        AWTUtilities.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                CharacterSizeCalcProxy.this.doCalculateCharSize(string, n, n2, n3);
            }
        });
        return this.fCharSize;
    }

    protected void doCalculateCharSize(String string, int n, int n2, int n3) {
        assert (EventQueue.isDispatchThread()) : "Must call TextRasterizer from event dispatch thread";
        TextRasterizer textRasterizer = new TextRasterizer();
        Font font = TextRasterizer.createFont(string, n, n2, n3);
        textRasterizer.setMode(1);
        textRasterizer.setupForLogicalBounds();
        textRasterizer.setFont(font);
        Rectangle2D rectangle2D = textRasterizer.getLogicalBounds("x");
        double d = rectangle2D.getHeight();
        double d2 = rectangle2D.getWidth();
        int n4 = textRasterizer.getDescent();
        int n5 = textRasterizer.getHeight();
        if (PlatformInfo.isWindows()) {
            d2 = Math.ceil(rectangle2D.getWidth());
            d = Math.ceil(rectangle2D.getHeight());
        } else if (PlatformInfo.isLinux()) {
            d = Math.ceil(rectangle2D.getHeight());
        } else if (PlatformInfo.isMacintosh()) {
            d2 = Math.ceil(rectangle2D.getWidth()) + 1.0;
            d = n5 + n4;
        }
        this.fCharSize = new Rectangle2D.Double(0.0, 0.0, d2, d);
    }
}

