/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.util.FontConverter;
import com.mathworks.hg.util.HGGetFrame;
import com.mathworks.hg.util.UnicodeTextTranslator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class GraphicsContext {
    private static final int COLORSTATE_FOREGROUND = 1;
    private static final int COLORSTATE_BACKGROUND = 2;
    private static final int NORMAL_erase = 0;
    private static final int BACKGROUND_erase = 1;
    private static final int XOR_erase = 2;
    private static final int NONE_erase = 3;
    public static final int SOLID_LINE = 0;
    public static final int DASHED_LINE = 1;
    public static final int DOTTED_LINE = 2;
    public static final int DASHDOT_LINE = 3;
    public static final int MiterLineJoin = 0;
    public static final int RoundLineJoin = 1;
    public static final int BevelLineJoin = 2;
    public static final int ButtLineCap = 0;
    public static final int RoundLineCap = 1;
    public static final int ProjectLineCap = 2;
    public static final int TEXT_LEFT = 0;
    public static final int TEXT_CENTER = 1;
    public static final int TEXT_RIGHT = 2;
    public static final int TEXT_TOP = 0;
    public static final int TEXT_CAP = 1;
    public static final int TEXT_MIDDLE = 2;
    public static final int TEXT_BASELINE = 3;
    public static final int TEXT_BOTTOM = 4;
    static final double DEG_TO_RAD = Math.PI / 180;
    private Component fCanvas = null;
    private Graphics2D fCanvasGraphics2d = null;
    private BufferedImage fBackBuffer = null;
    private Graphics2D fBackBufferGraphics2d = null;
    private Graphics2D fGraphics2d = null;
    Font fOrigLastFont = null;
    Font fLastFont = null;
    boolean fFontSmoothing = false;
    private int fDrawAreaWidth = 0;
    private int fDrawAreaHeight = 0;
    private boolean fOffscreenRenderingMode = false;
    private Color fForegroundColor = new Color(0, 0, 0);
    private Color fBackgroundColor = new Color(0, 0, 0);
    private Color fDrawModeColor = null;
    private Color fCurrentColor = null;
    private int fDrawMode = 0;
    private int fCurrentLineType = 0;
    private float fCurrentLineWidth = 0.5f;
    private int fCurrentLineJoin = 0;
    private int fCurrentLineCap = 2;
    private BasicStroke fStroke = null;
    private int fCurrentTextHorizontalAlignment = 0;
    private int fCurrentTextVerticalAlignment = 3;
    private int fCurrentTextRotation = 0;
    BufferedImage fTextQueryImage = new BufferedImage(1, 1, 2);
    Graphics2D fTextQueryG2D = this.fTextQueryImage.createGraphics();
    private CachedImage fCache = null;

    public GraphicsContext(boolean bl) {
        this.fOffscreenRenderingMode = bl;
        this.setGraphicsHints(this.fTextQueryG2D);
    }

    public void setGraphics(Graphics2D graphics2D, FigurePeer figurePeer) {
        this.fCanvas = figurePeer.getAxisComponent();
        if (!this.fOffscreenRenderingMode) {
            this.fCanvasGraphics2d = graphics2D;
            this.fGraphics2d = graphics2D;
        }
        this.setGraphicsHints(graphics2D);
    }

    private boolean isCanvasSizeValid() {
        if (this.fCanvas == null) {
            return false;
        }
        int n = this.fCanvas.getWidth();
        int n2 = this.fCanvas.getHeight();
        return n > 0 && n2 > 0;
    }

    private BufferedImage makeCompatibleImage(int n, int n2, Graphics2D graphics2D) {
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        return bufferedImage;
    }

    private boolean createOffscreenBuffer() {
        if (this.fCanvas == null) {
            return true;
        }
        int n = this.fCanvas.getWidth();
        int n2 = this.fCanvas.getHeight();
        if (n <= 0 || n2 <= 0) {
            return true;
        }
        this.fDrawAreaWidth = n;
        this.fDrawAreaHeight = n2;
        if (this.fBackBuffer == null || n != this.fBackBuffer.getWidth() || n2 != this.fBackBuffer.getHeight()) {
            BufferedImage bufferedImage = null;
            bufferedImage = this.fCanvasGraphics2d == null ? new BufferedImage(n, n2, 2) : this.makeCompatibleImage(n, n2, this.fCanvasGraphics2d);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.setGraphicsHints(graphics2D);
            this.fBackBuffer = bufferedImage;
            this.fDrawAreaWidth = this.fBackBuffer.getWidth();
            this.fDrawAreaHeight = this.fBackBuffer.getHeight();
            if (this.fBackBufferGraphics2d != null) {
                if (this.fBackBufferGraphics2d == graphics2D) {
                    System.err.println("disposing a gc we're using!!!");
                }
                this.fBackBufferGraphics2d.dispose();
            }
            this.fBackBufferGraphics2d = graphics2D;
            if (this.fOffscreenRenderingMode) {
                this.fGraphics2d = this.fBackBufferGraphics2d;
            }
            return true;
        }
        return false;
    }

    private void destroyOffscreenBuffer() {
        this.fBackBuffer = null;
        if (this.fBackBufferGraphics2d != null) {
            this.fBackBufferGraphics2d.dispose();
        }
        this.fBackBufferGraphics2d = null;
    }

    public void setOffscreenDrawing(boolean bl) {
        if (!this.fOffscreenRenderingMode) {
            if (bl) {
                if (this.fBackBufferGraphics2d == null) {
                    System.err.println("Set Offscreen Buffer: Backbuffer is bad!");
                    this.fGraphics2d = this.fCanvasGraphics2d;
                    return;
                }
                this.fGraphics2d = this.fBackBufferGraphics2d;
            } else {
                this.fGraphics2d = this.fCanvasGraphics2d;
            }
        } else {
            this.fGraphics2d = this.fBackBufferGraphics2d;
        }
    }

    public void blitOffscreenBuffer() {
        if (!this.fOffscreenRenderingMode && this.fBackBuffer != null) {
            this.fCanvasGraphics2d.drawImage((Image)this.fBackBuffer, 0, 0, null);
        }
    }

    public Image getOffscreenBuffer() {
        return this.fBackBuffer;
    }

    public Image copyOffscreenBuffer() {
        if (this.fBackBuffer == null) {
            return null;
        }
        int n = this.fBackBuffer.getWidth();
        int n2 = this.fBackBuffer.getHeight();
        BufferedImage bufferedImage = this.makeCompatibleImage(n, n2, this.fBackBufferGraphics2d);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.fBackBuffer, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void LineTo(int n, int n2, int n3, int n4) {
        this.setStroke();
        this.setColorState(1);
        this.fGraphics2d.drawLine(n, n2, n3, n4);
    }

    private void setColorState(int n) {
        if (n == 2) {
            if (this.fCurrentColor != this.fBackgroundColor) {
                this.fGraphics2d.setColor(this.fBackgroundColor);
                this.fCurrentColor = this.fBackgroundColor;
            }
            this.fGraphics2d.setPaintMode();
        } else if (n == 1) {
            if (this.fCurrentColor != this.fForegroundColor) {
                this.fGraphics2d.setColor(this.fForegroundColor);
                this.fCurrentColor = this.fForegroundColor;
            }
            if (this.fDrawMode == 2) {
                if (this.fDrawModeColor == null) {
                    this.fGraphics2d.setXORMode(this.fBackgroundColor);
                } else {
                    this.fGraphics2d.setXORMode(this.fDrawModeColor);
                }
            } else {
                this.fGraphics2d.setPaintMode();
            }
        }
    }

    public void SetFGColor(int n) {
        if (this.fForegroundColor.getRGB() != n) {
            this.fForegroundColor = new Color(n);
        }
    }

    public void SetBGColor(int n) {
        if (this.fBackgroundColor.getRGB() != n) {
            this.fBackgroundColor = new Color(n);
        }
    }

    public void SetFGColorPtr(float f, float f2, float f3) {
        this.fForegroundColor = new Color(f, f2, f3);
    }

    public void SetDrawModeColor(float f, float f2, float f3) {
        this.fDrawModeColor = new Color(f, f2, f3);
    }

    public void ClearDrawModeColor() {
        this.fDrawModeColor = null;
    }

    public void SetFGColormapIndex(int n) {
    }

    public void SetBGColorPtr(float f, float f2, float f3) {
        this.fBackgroundColor = new Color(f, f2, f3);
    }

    public void SetDrawMode(int n) {
        this.fDrawMode = n;
    }

    public void FrameRect(int n, int n2, int n3, int n4) {
        this.setColorState(1);
        this.setStroke();
        this.fGraphics2d.drawRect(n, n2, n3, n4);
    }

    public void FrameRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setColorState(1);
        this.setStroke();
        this.fGraphics2d.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void PaintRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setColorState(1);
        this.fGraphics2d.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void PaintArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setColorState(1);
        this.fGraphics2d.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void FrameArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setColorState(1);
        this.setStroke();
        this.fGraphics2d.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void PaintRect(int n, int n2, int n3, int n4) {
        this.setColorState(1);
        this.fGraphics2d.fillRect(n, n2, n3, n4);
    }

    public void EraseRect(int n, int n2, int n3, int n4) {
        this.setColorState(2);
        this.fGraphics2d.fillRect(n, n2, n3, n4);
    }

    public void FrameOval(int n, int n2, int n3, int n4) {
        this.FrameArc(n, n2, n3, n4, 0, 360);
    }

    public void PaintOval(int n, int n2, int n3, int n4) {
        this.PaintArc(n, n2, n3, n4, 0, 360);
    }

    public void PaintPoly(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.setColorState(1);
        this.fGraphics2d.fillPolygon(nArray, nArray2, nArray.length);
    }

    public void DrawPoly(int[] nArray, int[] nArray2) {
        this.setColorState(1);
        this.setStroke();
        this.fGraphics2d.drawPolygon(nArray, nArray2, nArray.length);
    }

    private int clamp(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public void PolyLine(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (nArray.length != nArray2.length) {
            // empty if block
        }
        this.setColorState(1);
        this.setStroke();
        if (this.fCurrentLineType != 0) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.fDrawAreaWidth;
            int n5 = this.fDrawAreaHeight;
            Shape shape = this.fGraphics2d.getClip();
            if (shape != null) {
                n2 = (int)shape.getBounds2D().getMinX();
                n3 = (int)shape.getBounds2D().getMinY();
                n4 = (int)shape.getBounds2D().getMaxX();
                n5 = (int)shape.getBounds2D().getMaxY();
            }
            for (int i = 1; i < n; ++i) {
                if (nArray[i - 1] == nArray[i] || nArray2[i - 1] == nArray2[i]) {
                    if (this.fGraphics2d.getClip() != null) {
                        this.fGraphics2d.setClip(null);
                    }
                    int n6 = this.clamp(nArray[i - 1], n2, n4);
                    int n7 = this.clamp(nArray2[i - 1], n3, n5);
                    int n8 = this.clamp(nArray[i], n2, n4);
                    int n9 = this.clamp(nArray2[i], n3, n5);
                    this.fGraphics2d.drawLine(n6, n7, n8, n9);
                    continue;
                }
                if (this.fGraphics2d.getClip() == null) {
                    this.fGraphics2d.setClip(shape);
                }
                this.fGraphics2d.drawLine(nArray[i - 1], nArray2[i - 1], nArray[i], nArray2[i]);
            }
            if (this.fGraphics2d.getClip() != shape) {
                this.fGraphics2d.setClip(shape);
            }
        } else {
            this.fGraphics2d.drawPolyline(nArray, nArray2, n);
        }
    }

    public int[] GetImageTrueColor(Rectangle rectangle) {
        return HGGetFrame.GetFrame(rectangle);
    }

    public int[] GetPixelsFromBufferedImage(BufferedImage bufferedImage) {
        return HGGetFrame.GetPixelsFromBufferedImage(bufferedImage);
    }

    private Image makeImage(int[] nArray, Rectangle rectangle, boolean bl) {
        DirectColorModel directColorModel;
        int[] nArray2;
        Object object;
        if (bl) {
            object = new int[]{0xFF0000, 65280, 255, -16777216};
            nArray2 = object;
            directColorModel = new DirectColorModel(32, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
        } else {
            object = new int[]{0xFF0000, 65280, 255};
            nArray2 = object;
            directColorModel = new DirectColorModel(32, nArray2[0], nArray2[1], nArray2[2]);
        }
        object = new DataBufferInt(nArray, rectangle.width * rectangle.height);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(((DataBuffer)object).getDataType(), rectangle.width, rectangle.height, nArray2);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, (DataBuffer)object, new Point(0, 0));
        return new BufferedImage(directColorModel, writableRaster, true, null);
    }

    public void BlitTrue32WithAlpha(int[] nArray, Rectangle rectangle) {
        Image image = this.makeImage(nArray, rectangle, true);
        this.setColorState(1);
        this.fGraphics2d.drawImage(image, rectangle.x, rectangle.y, null);
    }

    public void BlitTrue32(int[] nArray, Rectangle rectangle) {
        Image image = this.makeImage(nArray, rectangle, false);
        this.setColorState(1);
        this.fGraphics2d.drawImage(image, rectangle.x, rectangle.y, null);
    }

    public Image CreateWinSysBitData32(Rectangle rectangle, int[] nArray) {
        Image image = this.makeImage(nArray, rectangle, false);
        return image;
    }

    public void WinSysBitBlit(Image image, int n, int n2) {
        this.setColorState(1);
        this.fGraphics2d.drawImage(image, n, n2, null);
    }

    private void setStroke() {
        if (this.fStroke == null) {
            float[] fArray = null;
            float f = this.fCurrentLineWidth;
            if (f < 1.0f) {
                f = 1.0f;
            }
            float f2 = 5.0f * f;
            float f3 = 3.0f * f;
            float f4 = 1.0f * f;
            switch (this.fCurrentLineType) {
                case 0: {
                    fArray = null;
                    break;
                }
                case 1: {
                    fArray = new float[]{f2, f3};
                    break;
                }
                case 2: {
                    fArray = new float[]{f4, f3};
                    break;
                }
                case 3: {
                    fArray = new float[]{f2, f3, f4, f3};
                }
            }
            int n = 0;
            switch (this.fCurrentLineJoin) {
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                }
            }
            int n2 = 0;
            switch (this.fCurrentLineCap) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                }
            }
            this.fStroke = new BasicStroke(this.fCurrentLineWidth, n2, n, 10.0f, fArray, 0.0f);
            this.fGraphics2d.setStroke(this.fStroke);
        }
    }

    public void SetLineType(int n) {
        if (this.fCurrentLineType != n) {
            this.fCurrentLineType = n;
            this.fStroke = null;
        }
    }

    public void SetLineWidth(float f) {
        if (this.fCurrentLineWidth != f) {
            this.fCurrentLineWidth = f;
            this.fStroke = null;
        }
    }

    public void SetLineJoin(int n) {
        if (this.fCurrentLineJoin != n) {
            this.fCurrentLineJoin = n;
            this.fStroke = null;
        }
    }

    public void SetLineCap(int n) {
        if (this.fCurrentLineCap != n) {
            this.fCurrentLineCap = n;
            this.fStroke = null;
        }
    }

    public int GetBGColor() {
        return 0;
    }

    public void SetTextAlignment(int n, int n2) {
        this.fCurrentTextHorizontalAlignment = n;
        this.fCurrentTextVerticalAlignment = n2;
    }

    public void SetTextRotation(int n) {
        this.fCurrentTextRotation = n;
    }

    private Point get_text_offsets(String string) {
        FontRenderContext fontRenderContext = this.fTextQueryG2D.getFontRenderContext();
        Rectangle2D rectangle2D = this.fLastFont.getStringBounds(string, fontRenderContext);
        return this.get_text_offsets(string, (int)Math.ceil(rectangle2D.getWidth()) + 1);
    }

    private Point get_text_offsets(String string, int n) {
        int n2 = this.StringHeight();
        int n3 = this.StringDescent();
        int n4 = n2 + n3;
        int n5 = 0;
        int n6 = 0;
        switch (this.fCurrentTextHorizontalAlignment) {
            case 0: {
                n6 = 0;
                break;
            }
            case 1: {
                n6 = (int)(-((double)(n + 1) / 2.0));
                break;
            }
            case 2: {
                n6 = -n;
            }
        }
        switch (this.fCurrentTextVerticalAlignment) {
            case 1: {
                n5 = n2;
                break;
            }
            case 0: {
                n5 = n2;
                break;
            }
            case 2: {
                n5 = (int)(-((double)n3 + (double)(n2 + n3)) / 2.0);
                break;
            }
            case 3: {
                n5 = 0;
                break;
            }
            case 4: {
                n5 = -n3;
            }
        }
        double d = Math.PI / 180 * (double)this.fCurrentTextRotation;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = -d2 * (double)n6 + d3 * (double)n5;
        double d5 = d3 * (double)n6 + d2 * (double)n5;
        Point point = new Point((int)d4, (int)d5);
        return point;
    }

    public Rectangle GetTextExtent(String string) {
        this.setTextHints(this.fTextQueryG2D, this.fFontSmoothing);
        FontRenderContext fontRenderContext = this.fTextQueryG2D.getFontRenderContext();
        Rectangle2D rectangle2D = this.fLastFont.getStringBounds(string, fontRenderContext);
        int n = (int)Math.ceil(rectangle2D.getWidth()) + 1;
        Point point = this.get_text_offsets(string, n);
        Rectangle rectangle = new Rectangle(-point.x, 0, n, (int)Math.ceil(rectangle2D.getHeight()) + 1);
        if (this.fFontSmoothing) {
            this.setTextHints(this.fTextQueryG2D, false);
        }
        return rectangle;
    }

    public int StringHeight() {
        FontRenderContext fontRenderContext = this.fTextQueryG2D.getFontRenderContext();
        LineMetrics lineMetrics = this.fLastFont.getLineMetrics("X", fontRenderContext);
        return (int)lineMetrics.getHeight();
    }

    public int StringDescent() {
        FontRenderContext fontRenderContext = this.fTextQueryG2D.getFontRenderContext();
        LineMetrics lineMetrics = this.fLastFont.getLineMetrics("X", fontRenderContext);
        return (int)lineMetrics.getDescent();
    }

    public int LineSpacing() {
        return this.StringDescent() + this.StringHeight();
    }

    public boolean DrawString(int n, int n2, String string) {
        Point point = this.get_text_offsets(string);
        AffineTransform affineTransform = this.fGraphics2d.getTransform();
        if (this.fCurrentTextRotation != 0) {
            this.fGraphics2d.rotate((double)(-this.fCurrentTextRotation) * (Math.PI / 180), n, n2);
            this.setTextHints(this.fGraphics2d, true);
        } else {
            this.setTextHints(this.fGraphics2d, this.fFontSmoothing);
        }
        this.setColorState(1);
        String[] stringArray = new String[]{string};
        String[] stringArray2 = UnicodeTextTranslator.deriveUnicodeFromFont(stringArray, this.fOrigLastFont);
        this.fGraphics2d.drawString(stringArray2[0], n + point.x, n2 + point.y);
        if (this.fFontSmoothing || this.fCurrentTextRotation != 0) {
            this.setTextHints(this.fGraphics2d, false);
        }
        this.fGraphics2d.setTransform(affineTransform);
        return true;
    }

    private CachedImage getSingleCachedImage(int n, int n2) {
        if (this.fCache == null) {
            this.fCache = new CachedImage(n, n2);
        }
        if (!this.fCache.isEqualSize(n, n2)) {
            this.fCache.Resize(n, n2);
        }
        this.fCache.ResetTransform();
        return this.fCache;
    }

    private CachedImage getGrowableCachedImage(int n, int n2) {
        if (this.fCache == null) {
            this.fCache = new CachedImage(n, n2);
        }
        if (this.fCache.isLessThanSize(n, n2)) {
            this.fCache.Resize(n, n2);
        }
        this.fCache.ResetTransform();
        return this.fCache;
    }

    private BufferedImage drawStringIntoBufferedImage(String string, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        CachedImage cachedImage = this.getGrowableCachedImage(n2, n3);
        BufferedImage bufferedImage = cachedImage.fImage;
        Graphics2D graphics2D = cachedImage.fGraphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        if (this.fCurrentTextRotation != 0 && n != 90 && n != 270) {
            this.setTextHints(graphics2D, true);
        } else {
            this.setTextHints(graphics2D, this.fFontSmoothing);
        }
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(color);
        graphics2D.setFont(this.fLastFont);
        if (this.fCurrentTextRotation != 0 && n != 90 && n != 270) {
            graphics2D.rotate((double)(-this.fCurrentTextRotation) * (Math.PI / 180), n4, n3 - n5 - 1);
        }
        String[] stringArray = new String[]{string};
        String[] stringArray2 = UnicodeTextTranslator.deriveUnicodeFromFont(stringArray, this.fOrigLastFont);
        graphics2D.drawString(stringArray2[0], n4, n3 - n5 - 1);
        if (this.fFontSmoothing || this.fCurrentTextRotation != 0 || n != 90 || n != 270) {
            this.setTextHints(graphics2D, false);
        }
        if (n == 90 || n == 270) {
            return this.RotateImage_90_270(bufferedImage, n, n2, n3);
        }
        return bufferedImage;
    }

    private BufferedImage RotateImage_90_270(BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, n4, n5);
        int n6 = bufferedImage.getWidth();
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        DataBufferByte dataBufferByte2 = (DataBufferByte)dataBuffer2;
        byte[] byArray = dataBufferByte.getData();
        byte[] byArray2 = dataBufferByte2.getData();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (n == 90) {
                    byArray2[(n5 - 1 - j) * n4 + i] = byArray[i * n6 + j];
                    continue;
                }
                byArray2[j * n4 + (n4 - 1 - i)] = byArray[i * n6 + j];
            }
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public byte[] DrawStringIntoBitmap(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        BufferedImage bufferedImage;
        int n10 = n4;
        int n11 = n5;
        int n12 = n8;
        int n13 = n9;
        if (n == 90 || n == 270) {
            n10 = n2;
            n11 = n3;
            n12 = n6;
            n13 = n7;
        }
        if ((bufferedImage = this.drawStringIntoBufferedImage(string, n, n10, n11, n12, n13, Color.WHITE, Color.BLACK)) == null) {
            return null;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (!(dataBuffer instanceof DataBufferByte)) {
            return null;
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        if (n == 90 || n == 270) {
            return dataBufferByte.getData();
        }
        byte[] byArray = dataBufferByte.getData();
        byte[] byArray2 = new byte[n4 * n5];
        int n14 = 0;
        int n15 = bufferedImage.getWidth();
        int n16 = 0;
        while (n16 < n5) {
            for (int i = 0; i < n4; ++i) {
                byArray2[n16 * n4 + i] = byArray[n14 + i];
            }
            ++n16;
            n14 += n15;
        }
        return byArray2;
    }

    public boolean SetWindowFont(String string, int n, int n2, int n3, int n4, boolean bl) {
        try {
            Font font;
            Font font2 = FontConverter.convertToJavaFont(string, n, n2, n3, n4);
            if (font2 != null && (font = UnicodeTextTranslator.deriveFont(font2)) != null) {
                this.fOrigLastFont = font2;
                this.fLastFont = font;
                this.fFontSmoothing = bl;
                if (this.fGraphics2d != null) {
                    this.fGraphics2d.setFont(this.fLastFont);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void SetClipRegion(Area area, boolean bl) {
        if (this.fGraphics2d == null) {
            return;
        }
        if (area == null) {
            this.fGraphics2d.setClip(null);
        } else if (bl) {
            this.fGraphics2d.setClip(area.getBounds());
        } else if (!this.fOffscreenRenderingMode || this.fGraphics2d == this.fBackBufferGraphics2d) {
            this.fGraphics2d.setClip(new Area(area));
        }
    }

    public void setOffscreenRendering(boolean bl) {
        this.fOffscreenRenderingMode = bl;
    }

    private void setGraphicsHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        this.setTextHints(graphics2D, false);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    private void setTextHints(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    class CachedImage {
        private BufferedImage fImage = null;
        private Graphics2D fGraphics = null;
        private AffineTransform fTransform = null;

        public CachedImage(int n, int n2) {
            this.Create(n, n2);
        }

        public boolean isEqualSize(int n, int n2) {
            return this.fImage.getWidth() == n && this.fImage.getHeight() == n2;
        }

        public boolean isLessThanSize(int n, int n2) {
            return this.fImage.getWidth() < n || this.fImage.getHeight() < n2;
        }

        public void Resize(int n, int n2) {
            this.fGraphics.dispose();
            this.fGraphics = null;
            this.Create(n, n2);
        }

        private void ResetTransform() {
            this.fGraphics.setTransform(this.fTransform);
        }

        private void Create(int n, int n2) {
            this.fImage = new BufferedImage(n, n2, 10);
            this.fGraphics = this.fImage.createGraphics();
            this.fTransform = this.fGraphics.getTransform();
        }
    }
}

