/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.uij.CopyablePathIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class IteratorShape
implements Shape {
    private CopyablePathIterator fPoints;

    public IteratorShape(CopyablePathIterator copyablePathIterator) {
        this.fPoints = copyablePathIterator;
    }

    private Path2D toPath2D() {
        Path2D.Double double_ = new Path2D.Double();
        ((Path2D)double_).append(this.fPoints.createIterator(), false);
        return double_;
    }

    @Override
    public Rectangle getBounds() {
        Path2D path2D = this.toPath2D();
        return path2D.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        Path2D path2D = this.toPath2D();
        return path2D.getBounds2D();
    }

    @Override
    public boolean contains(double d, double d2) {
        Path2D path2D = this.toPath2D();
        return path2D.contains(d, d2);
    }

    @Override
    public boolean contains(Point2D point2D) {
        Path2D path2D = this.toPath2D();
        return path2D.contains(point2D);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        Path2D path2D = this.toPath2D();
        return path2D.contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        Path2D path2D = this.toPath2D();
        return path2D.contains(rectangle2D);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        Path2D path2D = this.toPath2D();
        return path2D.intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        Path2D path2D = this.toPath2D();
        return path2D.intersects(rectangle2D);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (affineTransform == null || affineTransform.isIdentity()) {
            return this.fPoints.createIterator();
        }
        return new TransformedIterator(this.fPoints.createIterator(), affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    private class TransformedIterator
    implements PathIterator {
        private PathIterator fSource;
        private AffineTransform fTransform;

        public TransformedIterator(PathIterator pathIterator, AffineTransform affineTransform) {
            this.fSource = pathIterator;
            this.fTransform = affineTransform;
        }

        @Override
        public int getWindingRule() {
            return this.fSource.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.fSource.isDone();
        }

        @Override
        public void next() {
            this.fSource.next();
        }

        @Override
        public int currentSegment(float[] fArray) {
            int n = this.fSource.currentSegment(fArray);
            this.fTransform.transform(fArray, 0, fArray, 0, 1);
            return n;
        }

        @Override
        public int currentSegment(double[] dArray) {
            int n = this.fSource.currentSegment(dArray);
            this.fTransform.transform(dArray, 0, dArray, 0, 1);
            return n;
        }
    }
}

