/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.GraphicsOpenGL;
import com.mathworks.jmi.Support;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;

public class OpenGLUtils {
    private static boolean sRequestThrow = false;
    private static boolean sSetShowJOGLExceptions = false;
    private MyListener fListener = null;
    private boolean fResultReady = false;
    private Data fData = null;
    private boolean fGLValid = false;
    private boolean fGetDataObject = false;
    private boolean fNeverMind = false;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.hg.uij.resources.RES_OpenGLUtils");

    public static OpenGLUtils requestGLData() {
        return new OpenGLUtils(true);
    }

    public static OpenGLUtils requestGLValid() {
        return new OpenGLUtils(false);
    }

    public boolean isResultReady() {
        return this.fResultReady;
    }

    public Data getGLData() {
        return this.fData;
    }

    public boolean getGLValid() {
        return this.fGLValid;
    }

    protected boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public void cleanup() {
        this.fNeverMind = true;
        if (!this.isHeadless()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (OpenGLUtils.this.fListener != null) {
                        OpenGLUtils.this.fListener.remove();
                    }
                }
            };
            EventQueue.invokeLater(runnable);
        }
    }

    private void setup() {
        if (!this.isHeadless()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!OpenGLUtils.this.fNeverMind) {
                        OpenGLUtils.this.fListener = new MyListener();
                    }
                }
            };
            EventQueue.invokeLater(runnable);
        } else {
            this.fResultReady = true;
        }
    }

    protected OpenGLUtils(boolean bl) {
        this.fGetDataObject = bl;
        this.setup();
    }

    public static void requestThrow() {
        sRequestThrow = true;
    }

    public static void throwIfRequested() {
        if (sRequestThrow) {
            sRequestThrow = false;
            throw new GLException("Something bad happened!");
        }
    }

    public static boolean getShowJOGLExceptions() {
        return sSetShowJOGLExceptions;
    }

    public static void setShowJOGLExceptions(boolean bl) {
        sSetShowJOGLExceptions = bl;
    }

    private static native String getLogFilePath();

    private static native void enterCriticalSection();

    private static native void exitCriticalSection();

    public static synchronized void reportJOGLException(GLException gLException) {
        String string = Support.useDesktop() ? sRes.getString("JavaGLExceptionWithLink") : sRes.getString("JavaGLException");
        System.err.println(string);
        if (sSetShowJOGLExceptions) {
            throw gLException;
        }
        try {
            String string2 = OpenGLUtils.getLogFilePath();
            try (PrintWriter printWriter = new PrintWriter(new FileWriter(string2, true));){
                boolean bl = false;
                for (Throwable throwable = gLException; throwable != null; throwable = throwable.getCause()) {
                    if (bl) {
                        printWriter.println("Caused by:");
                    }
                    throwable.printStackTrace(printWriter);
                    bl = true;
                }
                String string3 = Support.useDesktop() ? sRes.getString("JavaGLExceptionFileFormatWithLink") : sRes.getString("JavaGLExceptionFileFormat");
                String string4 = MessageFormat.format(string3, string2);
                System.err.println(string4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw gLException;
            }
        }
        catch (IOException iOException) {
            throw gLException;
        }
    }

    private class MyListener
    implements GLEventListener {
        private GLOffscreenAutoDrawable fGLAD;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MyListener() {
            try {
                OpenGLUtils.enterCriticalSection();
                GLCapabilities gLCapabilities = new GLCapabilities(null);
                if (GraphicsOpenGL.useSoftware()) {
                    gLCapabilities.setHardwareAccelerated(false);
                    gLCapabilities.setFBO(false);
                    gLCapabilities.setPBuffer(false);
                    gLCapabilities.setBitmap(true);
                } else {
                    gLCapabilities.setSampleBuffers(true);
                    gLCapabilities.setNumSamples(8);
                }
                try {
                    GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
                    this.fGLAD = gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 2, 2);
                    this.fGLAD.addGLEventListener((GLEventListener)this);
                    this.fGLAD.display();
                }
                catch (GLException gLException) {
                    OpenGLUtils.reportJOGLException(gLException);
                }
            }
            finally {
                OpenGLUtils.exitCriticalSection();
            }
        }

        public void remove() {
            this.fGLAD.removeGLEventListener((GLEventListener)this);
            this.fGLAD.destroy();
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            if (gL == null) {
                OpenGLUtils.this.fGLValid = false;
                OpenGLUtils.this.fResultReady = true;
                return;
            }
            String string = gL.glGetString(7938);
            OpenGLUtils.this.fGLValid = string != null;
            if (OpenGLUtils.this.fGetDataObject) {
                String string2;
                String string3;
                Data data = new Data();
                data.version = string;
                data.vendor = gL.glGetString(7936);
                data.renderer = gL.glGetString(7937);
                int[] nArray = new int[1];
                gL.glGetIntegerv(3379, nArray, 0);
                data.textureSize = nArray[0];
                GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getChosenGLCapabilities();
                Integer n = gLCapabilitiesImmutable.getVisualID(VisualIDHolder.VIDType.NATIVE);
                if (n == 0) {
                    n = gLCapabilitiesImmutable.getVisualID(VisualIDHolder.VIDType.INTRINSIC);
                }
                String string4 = n == 0 ? sRes.getString("VisualFmt.Undefined") : String.format("0x%02x", n);
                int n2 = gLCapabilitiesImmutable.getRedBits();
                int n3 = gLCapabilitiesImmutable.getGreenBits();
                int n4 = gLCapabilitiesImmutable.getBlueBits();
                int n5 = gLCapabilitiesImmutable.getAlphaBits();
                int n6 = n2 + n3 + n4 + n5;
                int n7 = gLCapabilitiesImmutable.getDepthBits();
                int n8 = gLCapabilitiesImmutable.getNumSamples();
                data.graphicsSmoothing = n8 > 0;
                boolean bl = gLCapabilitiesImmutable.getDoubleBuffered();
                String string5 = bl ? sRes.getString("Buffering.Double") : sRes.getString("Buffering.Single");
                boolean bl2 = gLCapabilitiesImmutable.isBackgroundOpaque();
                String string6 = string3 = gLCapabilitiesImmutable.getHardwareAccelerated() ? sRes.getString("Acceleration.Hardware") : sRes.getString("Acceleration.Software");
                if (n5 == 0) {
                    string2 = sRes.getString("VisualFmt.RGB");
                    data.visual = MessageFormat.format(string2, string4, n6, n2, n3, n4, n7, string3, string5, n8);
                } else {
                    string2 = sRes.getString("VisualFmt.RGBA");
                    data.visual = MessageFormat.format(string2, string4, n6, n2, n3, n4, n5, n7, string3, string5, n8);
                }
                boolean bl3 = data.renderer.contains("Mesa");
                data.software = bl3 || !gLCapabilitiesImmutable.getHardwareAccelerated() ? sRes.getString("true") : sRes.getString("false");
                String string7 = gL.glGetString(7939);
                data.extensions = string7.split(" ");
                OpenGLUtils.this.fData = data;
                if (gL.getContext().hasBasicFBOSupport()) {
                    int[] nArray2 = new int[1];
                    gL.glGetIntegerv(34024, nArray2, 0);
                    data.frameBufferSize = nArray2[0];
                } else {
                    data.frameBufferSize = 0.0;
                }
            }
            OpenGLUtils.this.fResultReady = true;
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
        }
    }

    public static class Data {
        public String version;
        public String vendor;
        public String renderer;
        public double textureSize;
        public String visual;
        public String software;
        public boolean graphicsSmoothing;
        public String[] extensions;
        public double frameBufferSize;
    }
}

