/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.AbstractSystemScreenInfoProvider;
import com.mathworks.hg.util.HGDisplayChangedEvent;
import com.mathworks.hg.util.JavaSystemScreenInfoProvider;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class DisplayChangeManager {
    private boolean fEnableDisplayChangeTracking;
    protected AbstractSystemScreenInfoProvider fScreenInfoProvider;
    private EventListenerList fDisplayChangedListeners = new EventListenerList();
    protected EventListener fSystemDisplayChangeListener;
    protected boolean fSystemDisplayChangeListenerAdded = false;

    public DisplayChangeManager(boolean bl) {
        this.fEnableDisplayChangeTracking = bl;
        this.fScreenInfoProvider = new JavaSystemScreenInfoProvider();
    }

    protected void dispose() {
        this.removeGlobalDisplayChangeListener();
        this.fScreenInfoProvider = null;
    }

    protected AbstractSystemScreenInfoProvider getSystemScreenInfoProvider() {
        return this.fScreenInfoProvider;
    }

    protected boolean isDisplayChangeObservable() {
        return this.fEnableDisplayChangeTracking && this.isDisplayChangeSupportedByEnvironment();
    }

    protected boolean isDisplayChangeSupportedByEnvironment() {
        return this.getSystemScreenInfoProvider().isDisplayChangeSupported();
    }

    public synchronized void addHGDisplayChangeListener(HGDisplayChangeListener hGDisplayChangeListener) {
        this.fDisplayChangedListeners.add(HGDisplayChangeListener.class, hGDisplayChangeListener);
        this.addGlobalDisplayChangeListener();
    }

    public synchronized void removeHGDisplayChangeListener(HGDisplayChangeListener hGDisplayChangeListener) {
        this.fDisplayChangedListeners.remove(HGDisplayChangeListener.class, hGDisplayChangeListener);
    }

    public void fireDisplayChanged(HGDisplayChangedEvent hGDisplayChangedEvent) {
        HGDisplayChangeListener[] hGDisplayChangeListenerArray;
        if (!this.isDisplayChangeObservable()) {
            return;
        }
        for (HGDisplayChangeListener hGDisplayChangeListener : hGDisplayChangeListenerArray = (HGDisplayChangeListener[])this.fDisplayChangedListeners.getListeners(HGDisplayChangeListener.class)) {
            hGDisplayChangeListener.displayChanged(hGDisplayChangedEvent);
        }
    }

    private void addGlobalDisplayChangeListener() {
        if (!this.isDisplayChangeObservable()) {
            return;
        }
        if (!this.fSystemDisplayChangeListenerAdded) {
            this.fSystemDisplayChangeListener = this.getSystemScreenInfoProvider().addSystemDisplayChangeListener(new Runnable(){

                @Override
                public void run() {
                    HGDisplayChangedEvent hGDisplayChangedEvent = new HGDisplayChangedEvent(this);
                    hGDisplayChangedEvent.fDPI = DisplayChangeManager.this.getSystemScreenInfoProvider().getSystemDPI();
                    hGDisplayChangedEvent.fNumScreens = DisplayChangeManager.this.getSystemScreenInfoProvider().getNumberOfScreens();
                    hGDisplayChangedEvent.fPrimary = DisplayChangeManager.this.getSystemScreenInfoProvider().getPrimaryScreenDeviceRectangle();
                    hGDisplayChangedEvent.fScreenDepth = DisplayChangeManager.this.getSystemScreenInfoProvider().getScreenDepth();
                    DisplayChangeManager.this.fireDisplayChanged(hGDisplayChangedEvent);
                }
            });
            this.fSystemDisplayChangeListenerAdded = true;
        }
    }

    private void removeGlobalDisplayChangeListener() {
        if (!this.isDisplayChangeObservable()) {
            return;
        }
        if (this.fSystemDisplayChangeListenerAdded) {
            this.fScreenInfoProvider.removeSystemDisplayChangeListener(this.fSystemDisplayChangeListener);
            this.fSystemDisplayChangeListenerAdded = false;
            this.fSystemDisplayChangeListener = null;
        }
    }

    public static interface HGDisplayChangeListener
    extends EventListener {
        public void displayChanged(HGDisplayChangedEvent var1);
    }
}

