/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.ScreenDevicesManager;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;

public class GraphicsDeviceUtilities {
    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration;
        block4: {
            graphicsConfiguration = null;
            try {
                if (!GraphicsEnvironment.isHeadless()) {
                    graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                }
            }
            catch (HeadlessException headlessException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        assert (graphicsConfiguration != null);
        return graphicsConfiguration;
    }

    public static int getDefaultScreenWidth() {
        ScreenDevicesManager screenDevicesManager = new ScreenDevicesManager();
        return (int)screenDevicesManager.getPrimaryScreenRect().getWidth();
    }

    public static int getDefaultScreenHeight() {
        ScreenDevicesManager screenDevicesManager = new ScreenDevicesManager();
        return (int)screenDevicesManager.getPrimaryScreenRect().getHeight();
    }

    public static int getDefaultScreenResolution() {
        ScreenDevicesManager screenDevicesManager = new ScreenDevicesManager();
        return screenDevicesManager.getDPI();
    }

    public static Rectangle getSizeOfAllScreens() {
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
            for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                rectangle = rectangle.union(graphicsConfiguration.getBounds());
            }
        }
        return rectangle;
    }
}

