/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.HGOutputFlags;
import com.mathworks.hg.print.PaintConvertingGraphics2D;
import com.mathworks.hg.print.PrintUtilities;
import com.mathworks.hg.print.TextureLimitingGraphics2D;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.hg.util.PrintDialog;
import com.mathworks.hg.util.PrinterUtils;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.util.PlatformInfo;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;

public class HGPrintOutputHelper
extends OutputHelper {
    private Exception fException;
    protected PrintServiceHelper fPrintServiceHelper;
    protected PrinterException fPrintException = null;

    public HGPrintOutputHelper(MPrintJob mPrintJob) {
        super(mPrintJob);
        this.fPrintJob = mPrintJob;
    }

    @Override
    public void open(FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        this.fPrintServiceHelper = new PrintServiceHelper();
    }

    @Override
    public void generateOutput(FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        this.validateContainerState(figurePanelContainer.getTargetContainer());
        this.fPrintServiceHelper.setContainer(figurePanelContainer);
        PrintRequestAttributeSet printRequestAttributeSet = this.setupPrintRequestAttributeSet();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.fPrintServiceHelper);
        PrintService printService = null;
        PrintService[] printServiceArray = null;
        String string = this.fPrintJob.getPrinterName();
        if (string != null && string.length() > 0 && ((printServiceArray = PrinterUtils.getRequestedPrinter(string)) == null || printServiceArray.length == 0)) {
            HGPrintOutputHelper.throwRequestedPrinterNotFound(string);
        }
        if (printServiceArray == null || printServiceArray.length == 0) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService == null && (printServiceArray = PrintServiceLookup.lookupPrintServices(null, null)).length > 0) {
                printService = printServiceArray[0];
            }
        } else if (printServiceArray.length > 0) {
            printService = printServiceArray[0];
        }
        this.printTheContainer(printService, printerJob, printRequestAttributeSet);
    }

    protected static void throwRequestedPrinterNotFound(String string) throws OutputHelperProcessingException {
        String string2 = string.replaceAll("\\\\", "\\\\\\\\");
        throw new OutputHelperProcessingException("MATLAB:HG:Java:UnknownPrinter\nThe specified printer '" + string2 + "' was not found");
    }

    protected void printTheContainer(PrintService printService, PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) throws OutputHelperProcessingException {
        Object object;
        Object object2;
        MediaPrintableArea[] mediaPrintableAreaArray;
        if (printService == null) {
            throw new OutputHelperProcessingException("MATLAB:HG:Java:PrintSetup\nNo printers are setup");
        }
        if (!this.fPrintJob.isShowDialog() && printService != null && (mediaPrintableAreaArray = (MediaPrintableArea[])printService.getSupportedAttributeValues(MediaPrintableArea.class, null, printRequestAttributeSet)) != null && mediaPrintableAreaArray.length > 0) {
            printRequestAttributeSet.add(mediaPrintableAreaArray[0]);
        }
        try {
            printerJob.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            throw new OutputHelperProcessingException("MATLAB:HG:Java:PrintAccess\nProblem using printer " + printerException);
        }
        boolean bl = true;
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
        if (this.fPrintJob.isShowDialog()) {
            try {
                bl = PrintDialog.show(printerJob, printRequestAttributeSet);
                if (!bl) {
                    return;
                }
                Media media2 = (Media)printRequestAttributeSet.get(Media.class);
                object2 = MediaSize.getMediaSizeForName((MediaSizeName)media2);
                object = printerJob.getPageFormat(printRequestAttributeSet);
                double d = ((PageFormat)object).getHeight() / 72.0;
                double d2 = ((PageFormat)object).getWidth() / 72.0;
                float[] fArray = ((Size2DSyntax)object2).getSize(25400);
                if (!mediaSize.equals(object2) && ((double)fArray[0] != d2 || (double)fArray[1] != d) && media instanceof CustomMediaSizeName) {
                    CustomMediaSizeName customMediaSizeName = (CustomMediaSizeName)media;
                    if (fArray[0] != this.fPrintJob.getPaperSize_Width() || fArray[1] != this.fPrintJob.getPaperSize_Height()) {
                        customMediaSizeName = new CustomMediaSizeName();
                    }
                    printRequestAttributeSet.remove(media2);
                    printRequestAttributeSet.add(customMediaSizeName);
                    this.fPrintJob.setPaperSize_Height((float)d);
                    this.fPrintJob.setPaperSize_Width((float)d2);
                }
            }
            catch (Throwable throwable) {
                throw new OutputHelperProcessingException(throwable);
            }
        }
        boolean bl2 = false;
        if (bl) {
            try {
                if (PlatformInfo.isWindows() && printRequestAttributeSet.containsKey(Chromaticity.class) && printRequestAttributeSet.get(Chromaticity.class).equals(Chromaticity.MONOCHROME)) {
                    object2 = new ContrastColorsWorker("save");
                    object2.start();
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                throw new OutputHelperProcessingException(exception);
            }
            object2 = printRequestAttributeSet;
            object = printerJob;
            final Container container = this.fPrintServiceHelper.getContainer().getTargetContainer();
            this.fException = null;
            Throwable throwable = null;
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable((PrinterJob)object, (PrintRequestAttributeSet)object2){
                    final /* synthetic */ PrinterJob val$printerJob;
                    final /* synthetic */ PrintRequestAttributeSet val$printAttributes;
                    {
                        this.val$printerJob = printerJob;
                        this.val$printAttributes = printRequestAttributeSet;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HGPrintOutputHelper.this.validateContainerSize(container);
                        assert (GraphicsEnvironment.isHeadless() || container.isDisplayable()) : "Expected the container to be displayable before generating output.";
                        try {
                            HGPrintOutputHelper.this.prePrint(container);
                            this.val$printerJob.print(this.val$printAttributes);
                        }
                        catch (PrinterException printerException) {
                            HGPrintOutputHelper.this.fPrintException = printerException;
                        }
                        finally {
                            HGPrintOutputHelper.this.postPrint();
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (bl2) {
                try {
                    ContrastColorsWorker contrastColorsWorker = new ContrastColorsWorker("restore");
                    contrastColorsWorker.start();
                }
                catch (Exception exception) {
                    throw new OutputHelperProcessingException(exception);
                }
            }
            if (this.fPrintException != null) {
                throw new OutputHelperProcessingException("MATLAB:HG:Java:PrintAccess\nProblem using printer " + this.fPrintException);
            }
            if (this.fException != null) {
                throw new OutputHelperProcessingException(this.fException);
            }
            if (throwable != null) {
                throw new OutputHelperProcessingException(throwable);
            }
        }
    }

    protected PrintRequestAttributeSet setupPrintRequestAttributeSet() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(new JobName("MATLAB", null));
        hashPrintRequestAttributeSet.add(new PageRanges(1, 1));
        String string = this.fPrintJob.getOutputOrientation().toLowerCase();
        if (string.equals("portrait")) {
            hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        } else if (string.equals("landscape")) {
            hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        } else if (string.equals("rotated")) {
            hashPrintRequestAttributeSet.add(OrientationRequested.REVERSE_LANDSCAPE);
        } else {
            hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        }
        String string2 = this.fPrintJob.getPaperType().toLowerCase();
        if (string2.equals("usletter")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.NA_LETTER);
        } else if (string2.equals("uslegal")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.NA_LEGAL);
        } else if (string2.equals("a0")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A0);
        } else if (string2.equals("a1")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A1);
        } else if (string2.equals("a2")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A2);
        } else if (string2.equals("a3")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A3);
        } else if (string2.equals("a4")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A4);
        } else if (string2.equals("a5")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A5);
        } else if (string2.equals("b0")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B0);
        } else if (string2.equals("b1")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B1);
        } else if (string2.equals("b2")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B2);
        } else if (string2.equals("b3")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B3);
        } else if (string2.equals("b4")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B4);
        } else if (string2.equals("b5")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B5);
        } else if (string2.equals("a")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.A);
        } else if (string2.equals("b")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.B);
        } else if (string2.equals("c")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.C);
        } else if (string2.equals("d")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.D);
        } else if (string2.equals("e")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.E);
        } else if (string2.equals("tabloid")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.TABLOID);
        } else if (string2.equals("arch-a")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.NA_9X12_ENVELOPE);
        } else {
            MediaSizeName mediaSizeName = MediaSize.findMedia(this.fPrintJob.getPaperSize_Width(), this.fPrintJob.getPaperSize_Height(), 25400);
            if (mediaSizeName != null) {
                MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                float[] fArray = mediaSize.getSize(25400);
                if (fArray != null && (fArray[0] != this.fPrintJob.getPaperSize_Width() || fArray[1] != this.fPrintJob.getPaperSize_Height())) {
                    float f = Math.min(this.fPrintJob.getPaperSize_Width(), this.fPrintJob.getPaperSize_Height());
                    float f2 = Math.max(this.fPrintJob.getPaperSize_Width(), this.fPrintJob.getPaperSize_Height());
                    MediaSize mediaSize2 = new MediaSize(f, f2, 25400, (MediaSizeName)new CustomMediaSizeName());
                    hashPrintRequestAttributeSet.add(mediaSize2.getMediaSizeName());
                } else {
                    hashPrintRequestAttributeSet.add(mediaSizeName);
                }
            }
        }
        if (this.fPrintServiceHelper != null && (this.fPrintServiceHelper.hasPrintHeaders() || !this.fPrintJob.isShowDialog())) {
            hashPrintRequestAttributeSet.add(this.createPrintableArea(this.fPrintJob, false));
        } else {
            hashPrintRequestAttributeSet.add(this.createPrintableArea(this.fPrintJob, true));
        }
        return hashPrintRequestAttributeSet;
    }

    private MediaPrintableArea createPrintableArea(MPrintJob mPrintJob, boolean bl) {
        float f;
        float f2;
        Rectangle2D rectangle2D = mPrintJob.getPaperPosition();
        if (mPrintJob.getOutputOrientation().equals("portrait")) {
            f2 = mPrintJob.getPaperSize_Width();
            f = mPrintJob.getPaperSize_Height();
        } else {
            f2 = mPrintJob.getPaperSize_Height();
            f = mPrintJob.getPaperSize_Width();
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = f2;
        float f6 = f;
        if (bl) {
            float f7 = (float)rectangle2D.getWidth();
            float f8 = (float)rectangle2D.getHeight();
            if (mPrintJob.getOutputOrientation().equals("portrait")) {
                f3 = (float)rectangle2D.getX();
                f4 = f - (float)rectangle2D.getY() - f8;
                f5 = f7;
                f6 = f8;
            } else if (mPrintJob.getOutputOrientation().equals("landscape")) {
                f3 = f5 - (float)rectangle2D.getY() - f8;
                f4 = f6 - (float)rectangle2D.getX() - f7;
                f5 = f8;
                f6 = f7;
            } else {
                f3 = (float)rectangle2D.getY();
                f4 = (float)rectangle2D.getX();
                f5 = f8;
                f6 = f7;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            if (f3 + f5 > f2) {
                f5 = f2 - f3;
            }
            if (f4 + f6 > f) {
                f6 = f - f4;
            }
        }
        return new MediaPrintableArea(f3, f4, f5, f6, 25400);
    }

    @Override
    public void close() throws OutputHelperProcessingException {
    }

    @Override
    public boolean supportsMultiplePages() {
        return false;
    }

    @Override
    public boolean supportsGettingDataForClipboard() {
        return false;
    }

    @Override
    public void release() throws OutputHelperProcessingException {
    }

    class ContrastColorsWorker
    extends MatlabWorker {
        private String fState;

        public ContrastColorsWorker(String string) {
            this.fState = string;
        }

        public Object runOnMatlabThread() throws Exception {
            Object[] objectArray = new Object[]{this.fState, null};
            int n = 0;
            Object object = ContrastColorsWorker.feval((String)"contrastcolors", (Object[])objectArray, (int)n);
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
        }
    }

    private static class CustomMediaSizeName
    extends MediaSizeName {
        private static int sCurrentMediaSizeName = -2;

        private CustomMediaSizeName() {
            super(sCurrentMediaSizeName--);
        }
    }

    protected class PrintServiceHelper
    implements Printable {
        private boolean fPrintDebugInfo = false;
        private FigurePanelContainer fContainer = null;

        protected PrintServiceHelper() {
            this.fPrintDebugInfo = HGPrintOutputHelper.this.fPrintJob.isDebugMode();
        }

        public FigurePanelContainer getContainer() {
            return this.fContainer;
        }

        public void setContainer(FigurePanelContainer figurePanelContainer) {
            this.fContainer = figurePanelContainer;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n == 0) {
                Object object;
                if (this.fPrintDebugInfo) {
                    switch (pageFormat.getOrientation()) {
                        case 0: {
                            object = "landscape";
                            break;
                        }
                        case 2: {
                            object = "reverse landscape";
                            break;
                        }
                        case 1: {
                            object = "portrait";
                            break;
                        }
                        default: {
                            object = "unknown";
                        }
                    }
                    DebugUtilities.logMessage(8192, "new print()\nImageable X: " + pageFormat.getImageableX() + " Y: " + pageFormat.getImageableY() + " W: " + pageFormat.getImageableWidth() + " H: " + pageFormat.getImageableHeight() + "\nPW: " + pageFormat.getWidth() + " PH: " + pageFormat.getHeight() + " Orientation: " + (String)object + "\n  ", this);
                }
                object = null;
                if (this.hasPrintHeaders()) {
                    object = (Graphics2D)graphics.create();
                }
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                if (PlatformInfo.isMacintosh()) {
                    graphics2D = new TextureLimitingGraphics2D(graphics2D, 0);
                    graphics2D = new PaintConvertingGraphics2D((Graphics)graphics2D);
                }
                Rectangle2D rectangle2D = PrintUtilities.pagePositionToJavaPosition(HGPrintOutputHelper.this.fPrintJob.getPaperSizeInPoints(), HGPrintOutputHelper.this.fPrintJob.getPaperPositionInPoints());
                PrintUtilities.setGraphicsPosition(graphics2D, HGPrintOutputHelper.this.fPrintJob.getSourceSize(), rectangle2D);
                Rectangle rectangle = new Rectangle(0, 0, HGPrintOutputHelper.this.fPrintJob.getDesired_Width(), HGPrintOutputHelper.this.fPrintJob.getDesired_Height());
                graphics2D.clip(rectangle);
                HGOutputFlags hGOutputFlags = HGPrintOutputHelper.this.setFlagsFromPrintjob(HGPrintOutputHelper.this.fPrintJob);
                HGPrintOutputHelper.this.fException = this.fContainer.printFigurePanel(graphics2D, hGOutputFlags);
                if (this.hasPrintHeaders()) {
                    this.printHeaders(pageFormat, (Graphics2D)object);
                    ((Graphics)object).dispose();
                }
                graphics2D.dispose();
                this.fPrintDebugInfo = false;
                return 0;
            }
            return 1;
        }

        protected boolean hasPrintHeaders() {
            return HGPrintOutputHelper.this.fPrintJob.getHeader_String().length() > 0 || HGPrintOutputHelper.this.fPrintJob.getHeader_DateString().length() > 0;
        }

        protected void printHeaders(PageFormat pageFormat, Graphics2D graphics2D) {
            if (!this.hasPrintHeaders()) {
                return;
            }
            String string = HGPrintOutputHelper.this.fPrintJob.getHeader_String();
            String string2 = HGPrintOutputHelper.this.fPrintJob.getHeader_DateString();
            int n = (!HGPrintOutputHelper.this.fPrintJob.getHeader_Font_Weight().equalsIgnoreCase("normal") ? 1 : 0) | (!HGPrintOutputHelper.this.fPrintJob.getHeader_Font_Angle().equalsIgnoreCase("normal") ? 2 : 0);
            Font font = new Font(HGPrintOutputHelper.this.fPrintJob.getHeader_Font_Name(), n, HGPrintOutputHelper.this.fPrintJob.getHeader_Font_Size());
            Font font2 = graphics2D.getFont();
            graphics2D.setFont(font);
            Rectangle2D rectangle2D = font.getStringBounds(string, graphics2D.getFontRenderContext());
            double d = rectangle2D.getHeight() + pageFormat.getImageableY();
            int n2 = string2.length();
            Rectangle2D rectangle2D2 = font.getStringBounds(string2, graphics2D.getFontRenderContext());
            double d2 = pageFormat.getImageableX() + pageFormat.getImageableWidth() - rectangle2D2.getWidth();
            graphics2D.drawString(string, (int)pageFormat.getImageableX() + HGPrintOutputHelper.this.fPrintJob.getHeader_Margin(), (int)d);
            graphics2D.drawString(string2, (int)d2 - HGPrintOutputHelper.this.fPrintJob.getHeader_Margin(), (int)d);
            graphics2D.setFont(font2);
        }
    }
}

