/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.hg.GraphicsVersion;
import com.mathworks.jmi.Matlab;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingPath;
import java.awt.Color;
import java.io.File;

public class UISettings {
    private static File sGraphics2SettingsPath = UISettings.getSettingFilePath("graphics2.settings");
    private static boolean sUseGraphicsVersion1Settings = false;
    private static Color sFactoryUIControlBackgroundColor = null;

    public static void setUseGraphicsVersion1Settings(boolean bl) {
        sUseGraphicsVersion1Settings = bl;
    }

    public static boolean isGraphicsVersion1ColorSettingsEnvironment() {
        return GraphicsVersion.isGraphicsVersion1() || sUseGraphicsVersion1Settings;
    }

    public static boolean isColorSameAsUIControlFactoryValue(Color color) {
        if (sFactoryUIControlBackgroundColor == null) {
            sFactoryUIControlBackgroundColor = UISettings.getGraphics2ColorSetting("factory", "uicontrol", "BackgroundColor");
        }
        return color.equals(sFactoryUIControlBackgroundColor);
    }

    public static Color getGraphics2ColorSetting(String string, String string2, String string3) {
        Color color = Color.BLACK;
        try {
            SettingPath settingPath = new SettingPath(sGraphics2SettingsPath);
            SettingPath settingPath2 = new SettingPath(settingPath, new String[]{string});
            SettingPath settingPath3 = new SettingPath(settingPath2, new String[]{string2});
            Setting setting = new Setting(settingPath3, string3);
            Double[] doubleArray = (Double[])setting.get();
            color = new Color((int)Math.round(255.0 * doubleArray[0]), (int)Math.round(255.0 * doubleArray[1]), (int)Math.round(255.0 * doubleArray[2]));
        }
        catch (Exception exception) {
            System.out.println(XMLMessageSystem.getBundle((String)"MATLAB:hg").getString("UnableToLoadGraphicsSettings"));
        }
        return color;
    }

    private static File getSettingFilePath(String string) {
        File file = Matlab.isMatlabAvailable() ? new File(Matlab.matlabRoot()) : new File(System.getenv("MWE_INSTALL"));
        File file2 = new File(file, "toolbox");
        File file3 = new File(file2, "matlab");
        File file4 = new File(file3, "uitools");
        File file5 = new File(file4, "+matlab");
        File file6 = new File(file5, "+ui");
        File file7 = new File(file6, "+internal");
        File file8 = new File(file7, string);
        return file8;
    }
}

