/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.kerberos;

import com.sun.jini.discovery.internal.EndpointBasedClient;
import com.sun.jini.discovery.kerberos.EndpointInternalsAccess;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.net.SocketFactory;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.kerberos.KerberosEndpoint;

public class Client
extends EndpointBasedClient {
    public Client() {
        super("net.jini.discovery.kerberos", EndpointInternalsAccess.get());
    }

    protected Endpoint getEndpoint(SocketFactory socketFactory, InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        return KerberosEndpoint.getInstance("ignored", 1, Client.getKerberosPrincipal(invocationConstraints), socketFactory);
    }

    private static KerberosPrincipal getKerberosPrincipal(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        Object object;
        Set set;
        InvocationConstraint invocationConstraint;
        KerberosPrincipal kerberosPrincipal = null;
        Iterator iterator = invocationConstraints.requirements().iterator();
        while (iterator.hasNext()) {
            invocationConstraint = (InvocationConstraint)iterator.next();
            if (!(invocationConstraint instanceof ServerMinPrincipal)) continue;
            set = ((ServerMinPrincipal)invocationConstraint).elements();
            if (set.size() > 1) {
                throw new UnsupportedConstraintException("multiple server principals");
            }
            object = (Principal)set.iterator().next();
            if (!(object instanceof KerberosPrincipal)) {
                throw new UnsupportedConstraintException("non-kerberos server principal");
            }
            if (kerberosPrincipal == null) {
                kerberosPrincipal = (KerberosPrincipal)object;
                continue;
            }
            if (kerberosPrincipal.equals(object)) continue;
            throw new UnsupportedConstraintException("multiple server principals");
        }
        if (kerberosPrincipal != null) {
            return kerberosPrincipal;
        }
        iterator = invocationConstraints.preferences().iterator();
        while (iterator.hasNext()) {
            invocationConstraint = (InvocationConstraint)iterator.next();
            if (!(invocationConstraint instanceof ServerMinPrincipal)) continue;
            set = ((ServerMinPrincipal)invocationConstraint).elements();
            object = set.iterator();
            while (object.hasNext()) {
                Principal principal = (Principal)object.next();
                if (!(principal instanceof KerberosPrincipal)) continue;
                return (KerberosPrincipal)principal;
            }
        }
        throw new UnsupportedConstraintException("no kerberos principal");
    }
}

