/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.loader.pref.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public final class PreferredResources {
    public static final int NAME_NO_PREFERENCE = 0;
    public static final int NAME_NOT_PREFERRED = 1;
    public static final int NAME_PREFERRED = 2;
    public static final int NAME_PREFERRED_RESOURCE_EXISTS = 3;
    private static final String HEADER_TITLE = "PreferredResources-Version: ";
    private static final String HEADER_MAJOR_VERSION = "1";
    private static final String HEADER_MINOR_VERSION = "0";
    private static final String PREF_PREFIX = "Preferred:";
    private static final String NAME_PREFIX = "Name:";
    private Map namespacePrefs;
    private Map packagePrefs;
    private Map completeNamePrefs;
    private boolean isEmpty = true;
    private Boolean defaultPreference = Boolean.FALSE;

    public PreferredResources(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    private void read(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        String string = null;
        String string2 = null;
        Boolean bl = null;
        this.isEmpty = true;
        this.completeNamePrefs = new HashMap(53);
        this.packagePrefs = new HashMap(23);
        this.namespacePrefs = new HashMap(11);
        string = this.readLineTrimComments(bufferedReader);
        if (string != null) {
            if (!string.startsWith(HEADER_TITLE)) {
                throw new IOException("unsupported preferred list header: " + string);
            }
            String string3 = string.substring(HEADER_TITLE.length(), string.length()).trim();
            if (!string3.startsWith("1.")) {
                throw new IOException("preferred list major version not supported");
            }
            string = this.readLineTrimComments(bufferedReader);
            while (string != null) {
                if (string.length() != 0) {
                    if (string.startsWith(NAME_PREFIX)) {
                        if (string2 != null) {
                            throw new IOException("Preferred name without preference value");
                        }
                        string2 = string.substring(NAME_PREFIX.length()).trim();
                    } else {
                        if (string.startsWith(PREF_PREFIX)) {
                            string3 = string.substring(PREF_PREFIX.length()).trim();
                            if (string3.equals("")) {
                                throw new IOException("Empty preference value not permitted");
                            }
                        } else {
                            throw new IOException("unrecognized preference entry: " + string);
                        }
                        bl = Boolean.valueOf(string3);
                        if (string2 == null) {
                            if (bl != null) {
                                if (!this.isEmpty) {
                                    throw new IOException("default preference must be the first expression and can not be redefined");
                                }
                                this.defaultPreference = bl;
                                bl = null;
                                this.isEmpty = false;
                            }
                        } else if (bl != null) {
                            if (string2.startsWith("/") || string2.startsWith("*") || string2.startsWith("-") || string2.startsWith(".")) {
                                throw new IOException("Invalid character at name beginning: " + string2);
                            }
                            if (string2.endsWith("/*")) {
                                this.mapPut(this.packagePrefs, string2.substring(0, string2.length() - 2), bl);
                            } else if (string2.endsWith("/-")) {
                                this.mapPut(this.namespacePrefs, string2.substring(0, string2.length() - 2), bl);
                            } else if (string2.endsWith("/")) {
                                this.mapPut(this.packagePrefs, string2.substring(0, string2.length() - 1), bl);
                            } else {
                                int n = bl != false ? 2 : 1;
                                this.mapPut(this.completeNamePrefs, string2, new Integer(n));
                            }
                            bl = null;
                            string2 = null;
                        }
                    }
                }
                string = this.readLineTrimComments(bufferedReader);
            }
            if (string2 != null) {
                throw new IOException("Preferred name without preference value");
            }
        }
        if (this.isEmpty) {
            throw new IOException("Empty preferences list is invalid");
        }
    }

    private String readLineTrimComments(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string != null && (string = string.trim()).indexOf(35) == 0) {
            string = "";
        }
        return string;
    }

    private void mapPut(Map map, String string, Object object) throws IOException {
        this.isEmpty = false;
        if (string.length() == 0 || string == null) {
            throw new IOException("no name specified in preference expression");
        }
        if (map.put(string, object) != null) {
            throw new IOException("duplicate map entry: " + string);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
        bufferedWriter.write("PreferredResources-Version: 1.0\n");
        bufferedWriter.write("Preferred: " + this.defaultPreference + "\n\n");
        this.writeMap(this.completeNamePrefs, bufferedWriter, "");
        this.writeMap(this.packagePrefs, bufferedWriter, "/*");
        this.writeMap(this.namespacePrefs, bufferedWriter, "/-");
        bufferedWriter.flush();
    }

    private void writeMap(Map map, Writer writer, String string) throws IOException {
        Iterator iterator = new TreeSet(map.keySet()).iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            writer.write("Name: " + k + string + "\n");
            Object v = map.get(k);
            if (v instanceof Boolean) {
                writer.write("Preferred: " + v + "\n\n");
                continue;
            }
            if (!(v instanceof Integer)) continue;
            int n = (Integer)v;
            if (n == 2 || n == 3) {
                writer.write("Preferred: true\n\n");
                continue;
            }
            writer.write("Preferred: false\n\n");
        }
    }

    public Boolean getDefaultPreference() {
        return this.defaultPreference;
    }

    public void setNameState(String string, int n) throws IOException {
        this.isEmpty = false;
        if (string.length() == 0) {
            throw new IOException("no name specified in preference expression");
        }
        this.completeNamePrefs.put(string, new Integer(n));
    }

    public int getNameState(String string, boolean bl) throws IOException {
        Integer n = null;
        n = bl ? this.getClassNameState(string) : (Integer)this.completeNamePrefs.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    private Integer getClassNameState(String string) throws IOException {
        if (!string.endsWith(".class")) {
            throw new IOException("requested name state on a non-class resource: " + string);
        }
        Integer n = null;
        String string2 = string;
        int n2 = -1;
        do {
            if ((n = (Integer)this.completeNamePrefs.get(string2)) != null || (n2 = string2.lastIndexOf("$")) < 0) continue;
            string2 = string2.substring(0, n2) + ".class";
        } while (n2 >= 0 && n == null);
        return n;
    }

    public Boolean getWildcardPreference(String string) {
        String string2;
        Boolean bl = null;
        int n = string.lastIndexOf("/");
        if (n >= 0 && !(string2 = string.substring(0, n)).equals("")) {
            if (!this.packagePrefs.isEmpty()) {
                bl = (Boolean)this.packagePrefs.get(string2);
            }
            if (bl == null) {
                bl = this.getNamespacePreference(string2);
            }
        }
        return bl;
    }

    private Boolean getNamespacePreference(String string) {
        Boolean bl = null;
        if (!this.namespacePrefs.isEmpty()) {
            int n;
            do {
                bl = (Boolean)this.namespacePrefs.get(string);
                n = string.lastIndexOf("/");
                if (n < 0) continue;
                string = string.substring(0, n);
            } while (n >= 0 && !string.equals("") && bl == null);
        }
        return bl;
    }
}

