/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetPropertyAction;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;

class FilterX509TrustManager
extends Utilities
implements X509TrustManager {
    private static X509TrustManager trustManager;
    private static final Object lock;
    private static final String trustManagerFactoryAlgorithm;
    private Set principals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FilterX509TrustManager(Set set) throws NoSuchAlgorithmException {
        Object object = lock;
        synchronized (object) {
            if (trustManager == null) {
                trustManager = FilterX509TrustManager.getTrustManager();
            }
        }
        this.setPermittedRemotePrincipals(set);
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        trustManager.checkClientTrusted(x509CertificateArray, string);
        this.check(x509CertificateArray);
        if (serverLogger.isLoggable(Level.FINE)) {
            serverLogger.log(Level.FINE, "check client trusted succeeds for auth type {0}\nchain {1}", new Object[]{string, FilterX509TrustManager.toString(x509CertificateArray)});
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        trustManager.checkServerTrusted(x509CertificateArray, string);
        this.check(x509CertificateArray);
        if (clientLogger.isLoggable(Level.FINE)) {
            clientLogger.log(Level.FINE, "check server trusted succeeds for auth type {0}\nchain {1}", new Object[]{string, FilterX509TrustManager.toString(x509CertificateArray)});
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return trustManager.getAcceptedIssuers();
    }

    void setPermittedRemotePrincipals(Set set) {
        this.principals = set == null ? null : new HashSet(set);
    }

    private void check(X509Certificate[] x509CertificateArray) throws CertificateException {
        if (this.principals != null && !this.principals.contains(x509CertificateArray[0].getSubjectX500Principal())) {
            throw new CertificateException("Remote principal is not trusted");
        }
    }

    private static X509TrustManager getTrustManager() throws NoSuchAlgorithmException {
        final TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
        Security.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    trustManagerFactory.init((KeyStore)null);
                }
                catch (KeyStoreException keyStoreException) {
                    Utilities.initLogger.log(Level.WARNING, "Problem initializing JSSE trust manager keystore", keyStoreException);
                }
                return null;
            }
        });
        return (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
    }

    static {
        lock = new Object();
        trustManagerFactoryAlgorithm = (String)Security.doPrivileged(new GetPropertyAction("com.sun.jini.jeri.ssl.trustManagerFactoryAlgorithm", TrustManagerFactory.getDefaultAlgorithm()));
    }
}

