/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.FileDataWidget;
import com.mathworks.project.api.ProjectComponentWithSelection;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.filesetui.FileSetCellRenderer;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.filesetui.FileSetTree;
import com.mathworks.project.impl.filesetui.FileSetTreeModel;
import com.mathworks.project.impl.filesetui.SelectionModelAdapter;
import com.mathworks.project.impl.filesetui.TableAdapter;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.util.Converter;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.grouptable.RightClickSelectionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class CustomFileSetTree
implements FileSetTree {
    private final FileSetEditor fEditor;
    private final FileSetEditorGroup fGroup;
    private final HierarchicalTable fTable;
    private final FileSetTreeModel fTreeModel;
    private final SelectionModelAdapter fSelectionModelAdapter;
    private final RightClickSelectionHandler fRightClickSelectionHandler;
    private final Map<File, CustomDataWrapper> fCustomDataWrappers;
    private final FileSetCellRenderer fRenderer;
    public static final String TABLE_CLIENT_PROPERTY = "CustomFileSetTree.Table";

    public CustomFileSetTree(final FileSetEditorGroup fileSetEditorGroup, FileSetEditor fileSetEditor) {
        this.fEditor = fileSetEditor;
        this.fGroup = fileSetEditorGroup;
        this.fTreeModel = new FileSetTreeModel(fileSetEditor);
        this.fCustomDataWrappers = new HashMap<File, CustomDataWrapper>();
        this.fTable = new HierarchicalTable(new TableAdapter(this.fTreeModel)){

            public void setRowHeight(int n) {
                FontMetrics fontMetrics;
                Font font = this.getFont();
                if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
                    super.setRowHeight(Math.max(n, fontMetrics.getHeight() + 6));
                    return;
                }
                super.setRowHeight(n);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int[] nArray = CustomFileSetTree.this.getSelectionModel().getSelectionRows();
                super.processMouseEvent(mouseEvent);
                int[] nArray2 = CustomFileSetTree.this.getSelectionModel().getSelectionRows();
                if ((nArray == null ^ nArray2 == null || nArray != null && !Arrays.equals(nArray, nArray2) || SwingUtilities.isLeftMouseButton(mouseEvent)) && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    fileSetEditorGroup.toggleSelectionInto(CustomFileSetTree.this.fEditor);
                }
            }
        };
        this.fTable.setInputMap(0, this.fTable.getInputMap(1));
        this.fTable.setInputMap(1, null);
        this.fTable.setOpaque(false);
        this.fTable.setBackground(SectionPanel.INNER_BACKGROUND);
        this.fTable.setName(this.fEditor.getFileSet().getDefinition().getKey() + ".tree");
        this.fTable.putClientProperty((Object)TABLE_CLIENT_PROPERTY, (Object)this.fTable);
        this.fTable.setPaintMarginBackground(false);
        this.fTable.setRowHeight(0);
        this.fRenderer = new FileSetCellRenderer(fileSetEditorGroup, fileSetEditor.getFileSet(), (JComponent)this.fTable, false);
        this.fTable.setDefaultCellRenderer(this.fRenderer.getTableAdapter());
        this.fTable.setSelectionMode(2);
        this.fTable.setHierarchicalColumn(0);
        this.fTable.setSingleExpansion(true);
        this.fTable.setComponentFactory(new HierarchicalTableComponentFactory(){

            public Component createChildComponent(HierarchicalTable hierarchicalTable, Object object, int n) {
                File file = (File)CustomFileSetTree.this.getPathForRow(n).getLastPathComponent();
                if (!file.exists()) {
                    return null;
                }
                CustomDataWrapper customDataWrapper = new CustomDataWrapper(file);
                CustomFileSetTree.this.fCustomDataWrappers.put(file, customDataWrapper);
                return customDataWrapper;
            }

            public void destroyChildComponent(HierarchicalTable hierarchicalTable, Component component, int n) {
                if (component == null) {
                    return;
                }
                CustomFileSetTree.this.fCustomDataWrappers.remove(((CustomDataWrapper)((Object)component)).getFile());
                ((CustomDataWrapper)((Object)component)).dispose();
            }
        });
        this.fSelectionModelAdapter = new SelectionModelAdapter(this.fTable.getSelectionModel(), new Converter<TreePath, Integer>(){

            public Integer convert(TreePath treePath) {
                return CustomFileSetTree.this.getRowForPath(treePath);
            }
        }, new Converter<Integer, TreePath>(){

            public TreePath convert(Integer n) {
                return CustomFileSetTree.this.getPathForRow(n);
            }
        });
        this.fGroup.getDataTransferSupport().installDragSupport(this.fEditor, this);
        this.fGroup.getDataTransferSupport().installDropSupport(this.fEditor);
        this.fGroup.getDataTransferSupport().installDropSupport(this.fEditor, (Component)this.fTable);
        for (File file : fileSetEditor.getFileSet().getFiles()) {
            int n;
            if (!fileSetEditor.getFileSet().isCustomDataExpanded(file) || (n = this.getRowForPath(new TreePath(new Object[]{file}))) <= -1) continue;
            this.fTable.expandRow(n);
        }
        this.fTable.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                this.toggle(treeExpansionEvent, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                this.toggle(treeExpansionEvent, false);
            }

            private void toggle(TreeExpansionEvent treeExpansionEvent, boolean bl) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath.getLastPathComponent() instanceof Integer) {
                    int n = (Integer)treeExpansionEvent.getPath().getLastPathComponent();
                    treePath = CustomFileSetTree.this.getPathForRow(n);
                }
                if (treePath.getLastPathComponent() instanceof File) {
                    CustomFileSetTree.this.fEditor.getFileSet().setCustomDataExpanded((File)treePath.getLastPathComponent(), bl);
                }
            }
        });
        this.fRightClickSelectionHandler = new RightClickSelectionHandler((Component)this.fTable);
    }

    @Override
    public void dispose() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CustomFileSetTree.this.fRightClickSelectionHandler.destroy();
                CustomFileSetTree.this.fGroup.getDataTransferSupport().uninstall(CustomFileSetTree.this.fEditor.getComponent());
                for (CustomDataWrapper customDataWrapper : CustomFileSetTree.this.fCustomDataWrappers.values()) {
                    customDataWrapper.dispose();
                }
                CustomFileSetTree.this.fCustomDataWrappers.clear();
                CustomFileSetTree.this.fGroup.getDataTransferSupport().uninstall((Component)CustomFileSetTree.this.fTable);
                CustomFileSetTree.this.fGroup.getDataTransferSupport().uninstall(CustomFileSetTree.this.fEditor.getComponent());
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.fTable;
    }

    @Override
    public void addModelChangeListener(final ChangeListener changeListener) {
        this.fTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(CustomFileSetTree.this));
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(CustomFileSetTree.this));
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(CustomFileSetTree.this));
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(CustomFileSetTree.this));
            }
        });
    }

    @Override
    public Object getRoot() {
        return this.fTreeModel.getRoot();
    }

    @Override
    public TreePath getPathForLocation(int n, int n2) {
        Point point = new Point(n, n2);
        int n3 = this.fTable.rowAtPoint(point);
        int n4 = this.fTable.columnAtPoint(point);
        if (n3 == -1 || n4 == -1) {
            return null;
        }
        Object object = this.fTable.getValueAt(n3, n4);
        return new TreePath(new Object[]{this.getRoot(), object});
    }

    @Override
    public int getRowForPath(TreePath treePath) {
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            if (!this.fTable.getValueAt(i, 0).equals(treePath.getLastPathComponent())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreePath getPathForRow(int n) {
        if (n == -1 || n >= this.getRowCount()) {
            return null;
        }
        return new TreePath(new Object[]{this.getRoot(), this.fTable.getValueAt(n, 0)});
    }

    @Override
    public Rectangle getRowBounds(int n) {
        return n < 0 ? null : this.fTable.getCellRect(n, 0, true);
    }

    @Override
    public Rectangle getPathBounds(TreePath treePath) {
        int n = this.getRowForPath(treePath);
        return this.getRowBounds(n);
    }

    @Override
    public void startEditingAtPath(TreePath treePath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collapseAll() {
        this.fTable.collapseAllRows();
    }

    @Override
    public void expandPath(TreePath treePath) {
        int n;
        if (treePath.getLastPathComponent() instanceof File && (n = this.getRowForPath(treePath)) > -1) {
            this.fTable.expandRow(n);
        }
    }

    @Override
    public TreeSelectionModel getSelectionModel() {
        return this.fSelectionModelAdapter;
    }

    @Override
    public int getChildCount(Object object) {
        return this.fTreeModel.getChildCount(object);
    }

    @Override
    public int getRowCount() {
        return this.fTable.getRowCount();
    }

    @Override
    public void setVisibleRowCount(int n) {
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.fTreeModel.getChild(object, n);
    }

    @Override
    public void fileChanged(final File file) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CustomFileSetTree.this.fRenderer.flushExistenceCache();
                CustomFileSetTree.this.fTable.revalidate();
                CustomFileSetTree.this.fTable.repaint();
                CustomDataWrapper customDataWrapper = (CustomDataWrapper)((Object)CustomFileSetTree.this.fCustomDataWrappers.get(file));
                if (!file.exists()) {
                    CustomFileSetTree.this.collapseAll();
                    if (customDataWrapper != null) {
                        CustomFileSetTree.this.fCustomDataWrappers.remove(file);
                        customDataWrapper.dispose();
                    }
                } else if (customDataWrapper != null) {
                    customDataWrapper.fileChanged();
                }
            }
        });
    }

    private class CustomDataWrapper
    extends MJPanel {
        private final File iFile;
        private FileDataWidget iWidget;
        private ChangeListener iListener;
        private PropertyChangeListener iExternalChangeListener;
        private boolean iSetting;

        CustomDataWrapper(final File file) {
            this.iFile = file;
            String string = CustomFileSetTree.this.fEditor.getFileSet().getDefinition().getCustomDataWidgetClassName();
            try {
                XmlReader xmlReader;
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(File.class);
                this.iWidget = (FileDataWidget)constructor.newInstance(file);
                if (this.iWidget instanceof ProjectComponentWithSelection) {
                    CustomFileSetTree.this.fGroup.addChild(CustomFileSetTree.this.fEditor, (ProjectComponentWithSelection)this.iWidget);
                }
                this.iListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        CustomDataWrapper.this.iSetting = true;
                        CustomFileSetTree.this.fEditor.getFileSet().setCustomData(file, ((XmlReader)CustomDataWrapper.this.iWidget.getData()).getXML());
                        CustomDataWrapper.this.iSetting = false;
                    }
                };
                this.iWidget.addChangeListener(this.iListener);
                this.iExternalChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!CustomDataWrapper.this.iSetting && FileSetInstance.isCustomDataChange(propertyChangeEvent)) {
                                    int n;
                                    CustomDataWrapper.this.iWidget.setData((Object)CustomFileSetTree.this.fEditor.getFileSet().getCustomData(file));
                                    if (CustomFileSetTree.this.fEditor.getFileSet().isCustomDataExpanded(file) && (n = CustomFileSetTree.this.getRowForPath(new TreePath(new Object[]{file}))) > -1) {
                                        CustomFileSetTree.this.fTable.expandRow(n);
                                    }
                                }
                            }
                        });
                    }
                };
                this.iWidget.getComponent().setBackground(CustomFileSetTree.this.fTable.getBackground());
                JTable jTable = (JTable)TreeUtils.findComponent((Component)this.iWidget.getComponent(), JTable.class);
                if (jTable != null) {
                    jTable.setBackground(CustomFileSetTree.this.fTable.getBackground());
                }
                if ((xmlReader = CustomFileSetTree.this.fEditor.getFileSet().getCustomData(file)) != null) {
                    this.iWidget.setData((Object)xmlReader);
                }
                this.setLayout(new BorderLayout(0, 0));
                this.add(this.iWidget.getComponent());
                CustomFileSetTree.this.fEditor.getFileSet().addPropertyChangeListener(this.iExternalChangeListener);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not instantiate custom data widget class: '" + string + "'. Please" + "ensure that it is a public class implementing FileDataWidget and has a " + "public constructor that takes a File parameter.", exception);
            }
        }

        File getFile() {
            return this.iFile;
        }

        void fileChanged() {
            this.iWidget.fileChanged();
        }

        public void dispose() {
            if (this.iWidget instanceof ProjectComponentWithSelection) {
                CustomFileSetTree.this.fGroup.removeChild(CustomFileSetTree.this.fEditor, (ProjectComponentWithSelection)this.iWidget);
            }
            CustomFileSetTree.this.fEditor.getFileSet().removePropertyChangeListener(this.iExternalChangeListener);
            this.iWidget.removeChangeListener(this.iListener);
            this.iWidget.dispose();
        }
    }
}

