/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.ValidatableTextField;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.filesetui.AppsFileSetCellRenderer;
import com.mathworks.project.impl.filesetui.DefaultEntityValidatable;
import com.mathworks.project.impl.filesetui.EntityControls;
import com.mathworks.project.impl.filesetui.FileSetCellRenderer;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.filesetui.FileSetTree;
import com.mathworks.project.impl.filesetui.FileSetTreeModel;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.widgets.grouptable.RightClickSelectionHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DefaultFileSetTree
implements FileSetTree {
    private final FileSetEditor fEditor;
    private final FileSetTreeModel fModel;
    private final FileSetEditorGroup fGroup;
    private final MJTree fTree;
    private final RightClickSelectionHandler fRightClickSelectionHandler;
    private final FileSetCellRenderer fRenderer;
    private boolean fBinaryWarning = false;

    public DefaultFileSetTree(FileSetEditorGroup fileSetEditorGroup, FileSetEditor fileSetEditor, boolean bl) {
        this(fileSetEditorGroup, fileSetEditor, bl, "");
    }

    public DefaultFileSetTree(FileSetEditorGroup fileSetEditorGroup, FileSetEditor fileSetEditor, boolean bl, String string) {
        this.fEditor = fileSetEditor;
        this.fGroup = fileSetEditorGroup;
        this.fModel = new FileSetTreeModel(fileSetEditor);
        this.fBinaryWarning = bl;
        this.fTree = new MJTree(this.fModel){

            public Dimension getMinimumSize() {
                return new Dimension(0, this.getPreferredSize().height);
            }

            public void setRowHeight(int n) {
                FontMetrics fontMetrics;
                Font font = this.getFont();
                if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
                    super.setRowHeight(Math.max(n, fontMetrics.getHeight() + 6));
                    return;
                }
                super.setRowHeight(n);
            }

            public boolean isPathEditable(TreePath treePath) {
                return treePath.getLastPathComponent() instanceof EntityInstance;
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int[] nArray = DefaultFileSetTree.this.fTree.getSelectionModel().getSelectionRows();
                super.processMouseEvent(mouseEvent);
                int[] nArray2 = DefaultFileSetTree.this.fTree.getSelectionModel().getSelectionRows();
                if ((nArray == null ^ nArray2 == null || nArray != null && !Arrays.equals(nArray, nArray2) || SwingUtilities.isLeftMouseButton(mouseEvent)) && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    DefaultFileSetTree.this.fGroup.toggleSelectionInto(DefaultFileSetTree.this.fEditor);
                }
            }

            protected void processKeyEvent(KeyEvent keyEvent) {
                int[] nArray = DefaultFileSetTree.this.fTree.getSelectionModel().getSelectionRows();
                super.processKeyEvent(keyEvent);
                int[] nArray2 = DefaultFileSetTree.this.fTree.getSelectionModel().getSelectionRows();
                if (!(!(nArray == null ^ nArray2 == null) && Arrays.equals(nArray, nArray2) || keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown())) {
                    DefaultFileSetTree.this.fGroup.toggleSelectionInto(DefaultFileSetTree.this.fEditor);
                }
            }
        };
        this.fRenderer = string.equals("fileset.main") ? new AppsFileSetCellRenderer(fileSetEditorGroup, this.fEditor.getFileSet(), (JComponent)this.fTree) : new FileSetCellRenderer(fileSetEditorGroup, this.fEditor.getFileSet(), (JComponent)this.fTree, this.fBinaryWarning);
        this.fTree.setUI((TreeUI)new BasicTreeUI(){

            @Override
            protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
            }

            @Override
            protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
            }
        });
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.fTree);
        this.fTree.setName(this.fEditor.getFileSet().getDefinition().getKey() + ".tree");
        this.fTree.setRowHeight((int)((double)this.fTree.getRowHeight() * 1.3));
        this.fTree.setBorder(null);
        this.fTree.setRootVisible(false);
        this.fTree.setCellRenderer(this.fRenderer.getTreeAdapter());
        this.fTree.setCellEditor((TreeCellEditor)new FileSetCellEditor());
        this.fTree.setEditable(true);
        this.fTree.setInvokesStopCellEditing(true);
        this.fTree.setOpaque(false);
        this.fTree.setBackground(SectionPanel.INNER_BACKGROUND);
        this.fRightClickSelectionHandler = new RightClickSelectionHandler((Component)this.fTree);
        if (!this.fEditor.getFileSet().getDefinition().getKey().equals("fileset.depfun")) {
            this.fGroup.getDataTransferSupport().installDragSupport(this.fEditor, this);
            this.fGroup.getDataTransferSupport().installDropSupport(this.fEditor);
        }
        this.fTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                DefaultFileSetTree.this.fTree.setVisibleRowCount(DefaultFileSetTree.this.fTree.getRowCount());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                DefaultFileSetTree.this.fTree.setVisibleRowCount(DefaultFileSetTree.this.fTree.getRowCount());
            }
        });
        this.fTree.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                TreePath treePath = DefaultFileSetTree.this.fTree.getPathForLocation((int)point.getX(), (int)point.getY());
                if (treePath != null && treePath.getLastPathComponent() instanceof EntityControls) {
                    EntityControls entityControls = (EntityControls)treePath.getLastPathComponent();
                    Rectangle rectangle = DefaultFileSetTree.this.fTree.getRowBounds(DefaultFileSetTree.this.fTree.getRowForPath(treePath));
                    if (point.getX() < rectangle.getX() + entityControls.getComponent().getPreferredSize().getWidth()) {
                        DefaultFileSetTree.this.fTree.setCursor(Cursor.getPredefinedCursor(12));
                    }
                } else {
                    DefaultFileSetTree.this.fTree.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.fModel.dispose();
        this.fRightClickSelectionHandler.destroy();
        this.fGroup.getDataTransferSupport().uninstall((Component)this.fTree);
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)this.fTree);
    }

    @Override
    public JComponent getComponent() {
        return this.fTree;
    }

    @Override
    public void addModelChangeListener(final ChangeListener changeListener) {
        this.fModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(this));
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(this));
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(this));
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        });
    }

    @Override
    public Object getRoot() {
        return this.fModel.getRoot();
    }

    @Override
    public TreePath getPathForLocation(int n, int n2) {
        return this.fTree.getPathForLocation(n, n2);
    }

    @Override
    public int getRowForPath(TreePath treePath) {
        return this.fTree.getRowForPath(treePath);
    }

    @Override
    public TreePath getPathForRow(int n) {
        return this.fTree.getPathForRow(n);
    }

    @Override
    public Rectangle getRowBounds(int n) {
        return this.fTree.getRowBounds(n);
    }

    @Override
    public Rectangle getPathBounds(TreePath treePath) {
        return this.fTree.getPathBounds(treePath);
    }

    @Override
    public void startEditingAtPath(TreePath treePath) {
        this.fTree.startEditingAtPath(treePath);
    }

    @Override
    public void collapseAll() {
        for (int i = 0; i < this.fTree.getRowCount(); ++i) {
            if (!this.fTree.isExpanded(i)) continue;
            this.fTree.collapseRow(i);
            i = -1;
        }
    }

    @Override
    public void expandPath(TreePath treePath) {
        this.fTree.expandPath(treePath);
    }

    @Override
    public TreeSelectionModel getSelectionModel() {
        return this.fTree.getSelectionModel();
    }

    @Override
    public int getChildCount(Object object) {
        return this.fModel.getChildCount(object);
    }

    @Override
    public int getRowCount() {
        return this.fTree.getRowCount();
    }

    @Override
    public void setVisibleRowCount(int n) {
        this.fTree.setVisibleRowCount(n);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.fModel.getChild(object, n);
    }

    @Override
    public void fileChanged(File file) {
        this.fRenderer.flushExistenceCache();
        this.fTree.revalidate();
        this.fTree.repaint();
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.fTree.addTreeSelectionListener(treeSelectionListener);
    }

    private class FileSetCellEditor
    extends DefaultTreeCellEditor {
        private DefaultEntityValidatable fValidatable;
        private ValidatableTextField fTextField;

        FileSetCellEditor() {
            super((JTree)DefaultFileSetTree.this.fTree, (DefaultTreeCellRenderer)DefaultFileSetTree.this.fTree.getCellRenderer());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            EntityInstance entityInstance = (EntityInstance)DefaultFileSetTree.this.fTree.getPathForRow(n).getLastPathComponent();
            this.fValidatable.setEntityBeingEdited(entityInstance);
            Component component = super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            this.editingIcon = entityInstance.getDefinition().getIcon();
            return component;
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            Border border = UIManager.getBorder("Tree.editorBorder");
            this.fValidatable = new DefaultEntityValidatable(DefaultFileSetTree.this.fEditor.getFileSet());
            this.fTextField = new ValidatableTextField((Validatable)this.fValidatable);
            this.fTextField.setIconPaintingEnabled(false);
            this.fTextField.setBorder(border);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JTextField)this.fTextField){
                {
                    FileSetCellEditor.this.fTextField.removeActionListener((ActionListener)this.delegate);
                    FileSetCellEditor.this.fTextField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (FileSetCellEditor.this.fTextField.getValidity() != Validity.INVALID) {
                                this.stopCellEditing();
                            }
                        }
                    });
                }
            };
            defaultCellEditor.setClickCountToStart(1);
            return defaultCellEditor;
        }

        @Override
        public boolean stopCellEditing() {
            return this.fTextField != null && this.fTextField.getValidity() != Validity.INVALID && super.stopCellEditing();
        }
    }
}

