/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.logui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.HyperlinkMJLabel;
import com.mathworks.project.impl.ProjectPrefs;
import com.mathworks.project.impl.logui.BuildProgressTextArea;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class BuildProgressDialog
extends MJDialog {
    private boolean fDockTransition;
    private final Content fContent;
    private final DeploymentProcess fProcess;
    private static final Color ERROR_PROGRESS_COLOR = new Color(150, 0, 0);

    public BuildProgressDialog(Component component, DeploymentProcess deploymentProcess) {
        this(component, deploymentProcess, null);
    }

    private BuildProgressDialog(Component component, DeploymentProcess deploymentProcess, Content content) {
        super((Frame)SwingUtilities.windowForComponent(component), BuiltInResources.getString(deploymentProcess.getInitialSubProcessType() == SubProcessType.USER_REQUESTED_PACKAGE ? "progress.package.title" : "progress.build.title"), false);
        this.setName("progress.dialog");
        this.fProcess = deploymentProcess;
        if (content == null) {
            this.fContent = new Content(this, deploymentProcess);
            this.add((Component)((Object)this.fContent));
            this.fContent.finishInitializing();
        } else {
            this.fContent = content;
            this.add((Component)((Object)this.fContent));
            this.fContent.setDialog(this);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!BuildProgressDialog.this.fContent.isFinished() && !BuildProgressDialog.this.fDockTransition) {
                    BuildProgressDialog.this.fProcess.cancel();
                }
                BuildProgressDialog.this.fContent.dispose();
            }
        });
        WindowUtils.centerWindowOnParent((Window)((Object)this));
    }

    public void notifyDockTransition() {
        this.fDockTransition = true;
    }

    public BuildProgressDialog reparent(Component component) {
        this.fContent.getParent().remove((Component)((Object)this.fContent));
        BuildProgressDialog buildProgressDialog = new BuildProgressDialog(component, this.fProcess, this.fContent);
        buildProgressDialog.setSize(this.getSize());
        this.dispose();
        return buildProgressDialog;
    }

    private static class Content
    extends MJPanel {
        private final DeploymentProcess fProcess;
        private final Configuration fConfiguration;
        private final BuildProgressTextArea fDetails;
        private final MJButton fDetailsButton;
        private final MJScrollPane fScroller;
        private final MJProgressBar fProgressBar;
        private final MJLabel fLabel;
        private final MJButton fCancelButton;
        private final MJPanel fLinks;
        private MJDialog fDialog;
        private boolean fFinished;
        private boolean fDetailsShowing;
        private Dimension fSizeWithDetails;
        private Dimension fSizeWithoutDetails;

        Content(MJDialog mJDialog, DeploymentProcess deploymentProcess) {
            this.fProcess = deploymentProcess;
            this.fDialog = mJDialog;
            this.fConfiguration = (Configuration)this.fProcess.getConfiguration();
            this.fLinks = new MJPanel((LayoutManager)new BorderLayout());
            String string = BuiltInResources.getString("progress.save.link");
            HyperlinkMJLabel hyperlinkMJLabel = new HyperlinkMJLabel(string, new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Content.this.showSaveDialog();
                }
            }, "link.save.progress", string);
            hyperlinkMJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            hyperlinkMJLabel.setName("link.save.progress");
            this.fLinks.add((Component)((Object)hyperlinkMJLabel), (Object)"East");
            this.fDetails = new BuildProgressTextArea();
            this.fDetails.setProcess(this.fProcess);
            this.fScroller = new MJScrollPane(this.fDetails.getComponent()){

                public Dimension getPreferredSize() {
                    return new Dimension((int)super.getPreferredSize().getWidth(), 150);
                }
            };
            MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("4dlu, fill:p, 8dlu, fill:d:grow, 8dlu", "4dlu, p, 10dlu, p, 10dlu"));
            MJLabel mJLabel = new MJLabel((Icon)DialogIcon.INFO_32x32.getIcon());
            mJLabel.setName("progress.icon");
            mJLabel.setOpaque(false);
            this.fLabel = new MJLabel(this.getLabelForSubProcess(this.fProcess.getCurrentSubProcessType()));
            this.fLabel.setName("progress.label");
            this.fLabel.setFont(this.fLabel.getFont().deriveFont(1, 12.0f));
            this.fLabel.setOpaque(false);
            this.fProgressBar = new MJProgressBar();
            this.fProgressBar.setName("progress.bar");
            this.fProgressBar.setIndeterminate(true);
            this.fProgressBar.setPreferredSize(new Dimension(310, (int)this.fProgressBar.getPreferredSize().getHeight()));
            CellConstraints cellConstraints = new CellConstraints();
            mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(2, 2));
            mJPanel.add((Component)this.fLabel, (Object)cellConstraints.xy(4, 2));
            mJPanel.add((Component)this.fProgressBar, (Object)cellConstraints.xy(4, 4));
            mJPanel.setBackground(Color.WHITE);
            MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
            this.fDetailsButton = new MJButton(BuiltInResources.getString("progress.details.show"), (Icon)DocumentIcon.DETAIL_EXPANDER.getIcon());
            this.fDetailsButton.setIcon((Icon)DocumentIcon.DETAIL_EXPANDER.getIcon());
            this.fDetailsButton.setName("progress.details.button");
            this.fDetailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Content.this.fScroller.isVisible()) {
                        Content.this.hideDetails();
                    } else {
                        Content.this.showDetails();
                    }
                }
            });
            this.fCancelButton = new MJButton(BuiltInResources.getString("button.cancel"));
            this.fCancelButton.setName("progress.button.close");
            this.fCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Content.this.fProcess.cancel();
                    if (!Content.this.fFinished) {
                        Content.this.fCancelButton.setEnabled(false);
                    } else {
                        Content.this.dispose();
                        Content.this.fDialog.dispose();
                    }
                }
            });
            this.fProcess.addMonitor(new DeploymentProcessMonitor(){

                public void subProcessStarted(SubProcessType subProcessType) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Content.this.fLabel.setText(Content.this.getLabelForSubProcess(Content.this.fProcess.getCurrentSubProcessType()));
                        }
                    });
                }

                public void commandStarted(String string) {
                }

                public void commandOutput(String string) {
                }

                public void commandError(String string) {
                }

                public void finished() {
                    Content.this.finished(false, false);
                }

                public void failed() {
                    Content.this.finished(true, false);
                }

                public void canceled() {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Content.this.dispose();
                            Content.this.fDialog.dispose();
                            Content.this.finished(true, true);
                        }
                    });
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (Content.this.fDetailsShowing) {
                        Content.this.fSizeWithDetails = Content.this.fDialog.getSize();
                        ProjectPrefs.PROGRESS_WIDTH.set((int)Content.this.fSizeWithDetails.getWidth());
                        ProjectPrefs.PROGRESS_HEIGHT.set((int)Content.this.fSizeWithDetails.getHeight());
                    }
                }
            });
            MJPanel mJPanel3 = new MJPanel((LayoutManager)new FlowLayout(2));
            mJPanel3.add((Component)this.fCancelButton);
            MJToolBar mJToolBar = new MJToolBar();
            mJToolBar.setFloatable(false);
            mJToolBar.add((Component)this.fDetailsButton);
            mJPanel2.add((Component)mJToolBar, (Object)"West");
            mJPanel2.add((Component)mJPanel3, (Object)"East");
            this.setLayout((LayoutManager)new FormLayout("fill:d:grow", "fill:d, fill:d, fill:d:grow, 2dlu, fill:p, 2dlu"));
            this.add((Component)mJPanel, cellConstraints.xy(1, 1));
            this.add((Component)mJPanel2, cellConstraints.xy(1, 2));
            this.add((Component)this.fScroller, cellConstraints.xy(1, 3));
            this.add((Component)this.fLinks, cellConstraints.xy(1, 5));
            this.fScroller.setVisible(false);
            this.fLinks.setVisible(false);
        }

        void dispose() {
            this.fDetails.dispose();
        }

        void finishInitializing() {
            this.packWithLongestLabel();
            if (ProjectPrefs.SHOW_PROGRESS_DETAILS.get().booleanValue()) {
                this.showDetails();
                if (PlatformInfo.isLinux()) {
                    Timer timer = new Timer(100, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Content.this.fDetails.getComponent().requestFocus();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
            if (ProjectPrefs.PROGRESS_WIDTH.isSet() && ProjectPrefs.PROGRESS_HEIGHT.isSet()) {
                this.fSizeWithDetails = new Dimension(ProjectPrefs.PROGRESS_WIDTH.get(), ProjectPrefs.PROGRESS_HEIGHT.get());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Content.this.fCancelButton.requestFocus();
                }
            });
        }

        void setDialog(MJDialog mJDialog) {
            this.fDialog = mJDialog;
        }

        boolean isFinished() {
            return this.fFinished;
        }

        private void showSaveDialog() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
                        File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
                        if (fileArray != null && fileArray.length == 1) {
                            Content.this.saveLogFile(fileArray[0], Content.this.fDetails.getPlainText());
                        }
                        return;
                    }
                    MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                    mJFileChooserPerPlatform.setDialogTitle(BuiltInResources.getString("dialog.title.savelog"));
                    File file = new File(MatlabPath.getCWD());
                    mJFileChooserPerPlatform.setCurrentDirectory(file);
                    String string = Content.this.fProcess.getInitialSubProcessType() == SubProcessType.USER_REQUESTED_PACKAGE ? "package.log" : "build.log";
                    mJFileChooserPerPlatform.setSelectedFile(new File(file, string));
                    mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                        public String getDescription() {
                            return BuiltInResources.getString("filter.logfile");
                        }

                        public String[] getPatterns() {
                            return new String[]{"*.log"};
                        }
                    });
                    mJFileChooserPerPlatform.showSaveDialog((Component)((Object)Content.this));
                    if (mJFileChooserPerPlatform.getState() == 0) {
                        File file2 = mJFileChooserPerPlatform.getSelectedFile();
                        Content.this.saveLogFile(file2, Content.this.fDetails.getPlainText());
                    }
                }
            });
        }

        private void saveLogFile(final File file, final String string) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (PrintWriter printWriter = null;){
                        printWriter = new PrintWriter(new FileWriter(file));
                        printWriter.print(string);
                        printWriter.close();
                    }
                }
            }.start();
        }

        public void showDetails() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Content.this.getWidth() > 0 && Content.this.getHeight() > 0) {
                        Content.this.fSizeWithoutDetails = Content.this.fDialog.getSize();
                    }
                    Content.this.fScroller.setVisible(true);
                    Content.this.fLinks.setVisible(true);
                    Content.this.fDetailsButton.setText(BuiltInResources.getString("progress.details.hide"));
                    Content.this.fDetailsButton.setIcon((Icon)DocumentIcon.DETAIL_COLLAPSER.getIcon());
                    Content.this.fDialog.setResizable(true);
                    if (Content.this.fSizeWithDetails != null) {
                        Content.this.fDialog.setSize(Content.this.fSizeWithDetails);
                    } else {
                        Content.this.fDialog.setSize(Content.this.getWidth() + 10, Content.this.getHeight() + 220);
                    }
                    ProjectPrefs.SHOW_PROGRESS_DETAILS.set(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Content.this.fDetailsShowing = true;
                        }
                    });
                }
            });
        }

        public void hideDetails() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Content.this.fDetailsShowing = false;
                    Content.this.fScroller.setVisible(false);
                    Content.this.fLinks.setVisible(false);
                    Content.this.fDetailsButton.setText(BuiltInResources.getString("progress.details.show"));
                    Content.this.fDetailsButton.setIcon((Icon)DocumentIcon.DETAIL_EXPANDER.getIcon());
                    if (Content.this.getWidth() > 0 && Content.this.getHeight() > 0) {
                        Content.this.fSizeWithDetails = Content.this.fDialog.getSize();
                    }
                    Content.this.fDialog.setResizable(false);
                    if (Content.this.fSizeWithoutDetails != null) {
                        Content.this.fDialog.setSize(Content.this.fSizeWithoutDetails);
                    } else {
                        Content.this.packWithLongestLabel();
                    }
                    ProjectPrefs.SHOW_PROGRESS_DETAILS.set(false);
                }
            });
        }

        private String getLabelForSubProcess(SubProcessType subProcessType) {
            switch (subProcessType) {
                case USER_REQUESTED_BUILD: {
                    return MessageFormat.format(BuiltInResources.getString("build.message"), this.fConfiguration.getName());
                }
                case USER_REQUESTED_PACKAGE: {
                    return MessageFormat.format(BuiltInResources.getString("package.message"), this.fConfiguration.getName());
                }
                case BUILD_OUTDATED: {
                    return MessageFormat.format(BuiltInResources.getString("build.outdated.message"), this.fConfiguration.getName());
                }
                case BUILD_MISSING: {
                    return MessageFormat.format(BuiltInResources.getString("build.missing.message"), this.fConfiguration.getName());
                }
                case WORKFLOW_STEP: {
                    return "";
                }
            }
            throw new IllegalStateException("Unrecognized subprocess type: " + subProcessType);
        }

        private void packWithLongestLabel() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    String string = Content.this.fLabel.getText();
                    Content.this.fLabel.setText(Content.this.getLongestPossibleLabel());
                    Content.this.fDialog.pack();
                    Content.this.fLabel.setText(string);
                }
            });
        }

        private String getLongestPossibleLabel() {
            String string = "";
            for (SubProcessType subProcessType : SubProcessType.values()) {
                String string2 = this.getLabelForSubProcess(subProcessType);
                if (string2.length() <= string.length()) continue;
                string = string2;
            }
            return string;
        }

        private void finished(final boolean bl, final boolean bl2) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Content.this.fFinished) {
                        return;
                    }
                    if (bl) {
                        Content.this.fProgressBar.setForeground(ERROR_PROGRESS_COLOR);
                        Content.this.fProgressBar.setString("");
                        Content.this.fProgressBar.setStringPainted(true);
                    }
                    Content.this.fProgressBar.setIndeterminate(false);
                    Content.this.fProgressBar.setValue(bl2 ? 0 : Content.this.fProgressBar.getMaximum());
                    if (bl2) {
                        Content.this.fLabel.setText(Content.this.fProcess.getInitialSubProcessType() == SubProcessType.USER_REQUESTED_PACKAGE ? BuiltInResources.getString("progress.package.canceled") : BuiltInResources.getString("progress.build.canceled"));
                    } else if (bl) {
                        Content.this.fLabel.setText(Content.this.fProcess.getInitialSubProcessType() == SubProcessType.USER_REQUESTED_PACKAGE ? BuiltInResources.getString("progress.package.failed") : BuiltInResources.getString("progress.build.failed"));
                    } else {
                        Content.this.fLabel.setText(Content.this.fProcess.getInitialSubProcessType() == SubProcessType.USER_REQUESTED_PACKAGE ? BuiltInResources.getString("progress.package.finished") : BuiltInResources.getString("progress.build.finished"));
                    }
                    Content.this.fCancelButton.setText(BuiltInResources.getString("button.close"));
                    Content.this.fFinished = true;
                }
            });
        }
    }
}

