/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.VariableGraph;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class DefaultVariableGraph
implements VariableGraph {
    private final Map<String, VariableGraph.Generator> fDefaultGenerators;
    private final Map<String, VariableGraph.XmlSerializer> fSerializers = new HashMap<String, VariableGraph.XmlSerializer>();
    private final Map<String, Object> fDefaultValues;
    private final Map<String, Object> fExplicitValues;
    private final Map<String, String> fXml;
    private final Map<String, Set<String>> fDependencies;
    private final Map<String, Integer> fSetCounts;
    private final Map<String, String> fSignatures;
    private final Map<String, VariableGraph> fViews;
    private final Set<String> fVariablesWithPendingAsyncLoads;
    private final Set<String> fAsyncLoadedVariables;
    private final Set<String> fLocked;
    private final PropertyChangeSupport fPropertySupport;

    public DefaultVariableGraph() {
        this.fDefaultGenerators = new HashMap<String, VariableGraph.Generator>();
        this.fDefaultValues = new HashMap<String, Object>();
        this.fExplicitValues = new HashMap<String, Object>();
        this.fDependencies = new HashMap<String, Set<String>>();
        this.fXml = new HashMap<String, String>();
        this.fSetCounts = new HashMap<String, Integer>();
        this.fSignatures = new HashMap<String, String>();
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fViews = new HashMap<String, VariableGraph>();
        this.fVariablesWithPendingAsyncLoads = new HashSet<String>();
        this.fAsyncLoadedVariables = new HashSet<String>();
        this.fLocked = new HashSet<String>();
    }

    private DefaultVariableGraph(DefaultVariableGraph defaultVariableGraph, String string) {
        this();
        for (String string2 : defaultVariableGraph.getDependenciesOf(string)) {
            if (defaultVariableGraph.fXml.containsKey(string2)) {
                this.fXml.put(string2, defaultVariableGraph.fXml.get(string2));
            }
            if (defaultVariableGraph.fDefaultValues.containsKey(string2)) {
                this.fDefaultValues.put(string2, defaultVariableGraph.fDefaultValues.get(string2));
            }
            if (!defaultVariableGraph.isExplicitlySet(string2)) continue;
            this.fExplicitValues.put(string2, defaultVariableGraph.fExplicitValues.get(string2));
        }
    }

    private synchronized VariableGraph getView(String string) {
        String string2 = this.getSignature(string);
        VariableGraph variableGraph = this.fViews.get(string2);
        if (variableGraph == null) {
            variableGraph = new DefaultVariableGraph(this, string);
            this.fViews.put(string2, variableGraph);
        }
        return variableGraph;
    }

    private synchronized String generateSignature(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.getDependenciesOf(string)) {
            stringBuilder.append(string2);
            stringBuilder.append(':');
            stringBuilder.append(this.fSetCounts.containsKey(string) ? Integer.toString(this.fSetCounts.get(string)) : "0");
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    private synchronized String getSignature(String string) {
        String string2 = this.fSignatures.get(string);
        if (string2 == null) {
            string2 = this.generateSignature(string);
            this.fSignatures.put(string, string2);
        }
        return string2;
    }

    private synchronized void updateState(String string) {
        this.fSetCounts.put(string, this.fSetCounts.containsKey(string) ? this.fSetCounts.get(string) + 1 : 1);
        this.fSignatures.put(string, this.generateSignature(string));
        for (String string2 : this.getAllAffectedVariables(string)) {
            String string3 = this.fSignatures.get(string2);
            if (string3 != null) {
                this.fViews.remove(string3);
            }
            this.fSignatures.remove(string2);
        }
    }

    @Override
    public synchronized boolean hasVariable(String string) {
        return this.fExplicitValues.containsKey(string) || this.fDefaultValues.containsKey(string) || this.fDefaultGenerators.containsKey(string) || this.fSerializers.containsKey(string);
    }

    @Override
    public synchronized Set<String> getKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.fExplicitValues.keySet());
        hashSet.addAll(this.fDefaultValues.keySet());
        hashSet.addAll(this.fDefaultGenerators.keySet());
        hashSet.addAll(this.fSerializers.keySet());
        return hashSet;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void setDefaultGenerator(String string, VariableGraph.Generator generator) {
        assert (this.fDefaultValues.isEmpty());
        this.fDefaultGenerators.put(string, generator);
    }

    @Override
    public synchronized void setSerializer(String string, VariableGraph.XmlSerializer xmlSerializer) {
        assert (this.fDefaultValues.isEmpty());
        this.fSerializers.put(string, xmlSerializer);
    }

    @Override
    public synchronized void addDependency(String string, String string2) {
        assert (this.fDefaultValues.isEmpty());
        Set<String> set = this.fDependencies.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.fDependencies.put(string, set);
        }
        set.add(string2);
    }

    @Override
    public synchronized boolean hasDependency(String string, String string2) {
        Set<String> set = this.fDependencies.get(string);
        return set != null && set.contains(string2);
    }

    @Override
    public synchronized Set<String> getDependenciesOf(String string) {
        Set<String> set = this.fDependencies.get(string);
        return set == null ? new TreeSet<String>() : new TreeSet<String>(set);
    }

    @Override
    public synchronized Set<String> getAllAffectedVariables(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        this.getAllAffectedVariables(hashSet, string);
        return hashSet;
    }

    private synchronized void getAllAffectedVariables(Set<String> set, String string) {
        for (Map.Entry<String, Set<String>> entry : this.fDependencies.entrySet()) {
            if (!entry.getValue().contains(string)) continue;
            set.add(entry.getKey());
            this.getAllAffectedVariables(set, entry.getKey());
        }
    }

    @Override
    public synchronized String getXml(String string) {
        String string2 = this.fXml.get(string);
        if (string2 == null && this.fSerializers.get(string) != null) {
            this.generateDefaults();
            string2 = this.fXml.get(string);
        }
        return string2;
    }

    @Override
    public Object getValue(String string) {
        return this.getValue(string, true);
    }

    private synchronized Object getValue(String string, boolean bl) {
        if (this.isExplicitlySet(string)) {
            return this.fExplicitValues.get(string);
        }
        return this.getDefaultValue(string, bl);
    }

    @Override
    public synchronized Object getExplicitValue(String string) {
        return this.fExplicitValues.get(string);
    }

    @Override
    public synchronized boolean isExplicitlySet(String string) {
        return this.fExplicitValues.containsKey(string);
    }

    @Override
    public synchronized void notifyPendingAsyncLoad(String string) {
        this.fVariablesWithPendingAsyncLoads.add(string);
        this.fAsyncLoadedVariables.add(string);
    }

    @Override
    public synchronized void setDefaultValue(String string, Object object) {
        this.fVariablesWithPendingAsyncLoads.remove(string);
        if (!this.isExplicitlySet(string)) {
            Object object2 = null;
            if (this.fDefaultValues.containsKey(string)) {
                object2 = this.getValue(string);
            }
            this.fDefaultValues.put(string, object);
            this.updateState(string);
            this.serialize(string);
            this.generateDefaults(this.getAllAffectedVariables(string));
            this.fPropertySupport.firePropertyChange(string, object2, object);
        } else {
            this.fDefaultValues.put(string, object);
        }
    }

    @Override
    public synchronized void lock(String string, Object object) {
        Object object2 = this.getValue(string);
        this.fLocked.add(string);
        this.fExplicitValues.put(string, object);
        this.updateState(string);
        this.serialize(string);
        this.fPropertySupport.firePropertyChange(string, object2, object);
        this.generateDefaults(this.getAllAffectedVariables(string));
    }

    @Override
    public synchronized void reset(String string) {
        Object object = this.getValue(string);
        this.fLocked.remove(string);
        this.fExplicitValues.remove(string);
        this.updateState(string);
        this.serialize(string);
        this.fPropertySupport.firePropertyChange(string, object, this.getValue(string));
        this.generateDefaults(this.getAllAffectedVariables(string));
    }

    @Override
    public synchronized void setValue(String string, Object object) {
        Object object2 = this.getValue(string);
        if (!this.fVariablesWithPendingAsyncLoads.contains(string) && DefaultVariableGraph.valueEquals(object, this.fDefaultValues.get(string))) {
            this.fExplicitValues.remove(string);
        } else if (!this.fVariablesWithPendingAsyncLoads.contains(string) || object2 == null || object != null && !object.equals(object2)) {
            this.fExplicitValues.put(string, object);
        }
        this.updateState(string);
        this.serialize(string);
        this.fPropertySupport.firePropertyChange(string, object2, object);
        this.fVariablesWithPendingAsyncLoads.remove(string);
        this.generateDefaults(this.getAllAffectedVariables(string));
    }

    @Override
    public VariableGraph.Generator getDefaultGenerator(String string) {
        return this.fDefaultGenerators.get(string);
    }

    @Override
    public synchronized Object getDefaultValue(String string, boolean bl) {
        if (!this.fDefaultValues.containsKey(string)) {
            if (this.fVariablesWithPendingAsyncLoads.contains(string)) {
                return null;
            }
            if (this.fDefaultGenerators.get(string) == null) {
                throw new IllegalArgumentException("No default generator for " + string + " or something has a non-configured dependency on it.");
            }
            this.generateDefaults();
            assert (this.fDefaultValues.containsKey(string));
        }
        Object object = this.fDefaultValues.get(string);
        VariableGraph.Generator generator = this.fDefaultGenerators.get(string);
        if (generator != null && bl) {
            return generator.access(string, this.fDefaultValues.get(string), this.getView(string));
        }
        return object;
    }

    @Override
    public synchronized void writeAllXml(XmlWriter xmlWriter) {
        for (String string : this.getKeys()) {
            String string2 = this.getXml(string);
            if (string2 == null) continue;
            xmlWriter.writeXML(string2);
        }
    }

    private synchronized void generateDefaults() {
        assert (this.fDefaultValues.isEmpty());
        this.generateDefaults(new TreeSet<String>(this.fDefaultGenerators.keySet()));
    }

    @Override
    public synchronized void generateDefaults(Set<String> set) {
        Object object;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(set);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.fDefaultValues);
        for (String object22 : linkedHashSet) {
            this.fDefaultValues.remove(object22);
        }
        ArrayList arrayList = new ArrayList();
        while (!linkedHashSet.isEmpty()) {
            final String string = this.findVariableWithSatisfiedDependencies(linkedHashSet);
            if (string == null) {
                throw new IllegalStateException("Circular dependency prevents evaluation from completing for: " + Arrays.toString(linkedHashSet.toArray()));
            }
            object = this.fDefaultGenerators.get(string).generateValue(string, this.getView(string));
            final Object v = hashMap.get(string);
            this.updateState(string);
            this.fDefaultValues.put(string, object);
            if (this.fExplicitValues.get(string) == null && object != null) {
                this.serialize(string);
                arrayList.add(new Runnable(){

                    @Override
                    public void run() {
                        if (DefaultVariableGraph.this.fExplicitValues.get(string) == null) {
                            DefaultVariableGraph.this.fPropertySupport.firePropertyChange(string, v, object);
                        }
                    }
                });
            }
            linkedHashSet.remove(string);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (Runnable)iterator.next();
            object.run();
        }
    }

    @Override
    public synchronized Set<String> getVariablesWithPendingAsyncLoads() {
        return Collections.unmodifiableSet(this.fVariablesWithPendingAsyncLoads);
    }

    private synchronized void serialize(String string) {
        this.fXml.remove(string);
        Object object = this.getValue(string, false);
        VariableGraph.XmlSerializer xmlSerializer = this.fSerializers.get(string);
        if (xmlSerializer != null) {
            this.fXml.put(string, xmlSerializer.serialize(object));
        }
    }

    private synchronized String findVariableWithSatisfiedDependencies(Set<String> set) {
        for (String string : set) {
            if (this.hasAnyUnsatisfiedDependencies(string)) continue;
            return string;
        }
        return null;
    }

    private synchronized boolean hasAnyUnsatisfiedDependencies(String string) {
        for (String string2 : this.getDependenciesOf(string)) {
            if (this.isExplicitlySet(string2) || this.fDefaultValues.containsKey(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean valueEquals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object2 != null && object.equals(object2);
    }

    @Override
    public void freeze() {
    }
}

