/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.FileReferenceMode;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.VariableGraph;
import com.mathworks.project.impl.model.XslInput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class SpecialFile {
    private final String fKey;
    private final String fName;
    private final String fDescription;
    private final String fHelpTopicKey;
    private final String fLocationPreferencePanelName;
    private final List<DynamicTargetAttribute> fPossibleLocations;
    private final List<FileReferenceMode> fSupportedReferenceModes;

    public SpecialFile(String string, String string2, String string3, String string4, String string5, List<DynamicTargetAttribute> list, List<FileReferenceMode> list2) {
        this.fKey = string;
        this.fName = string2;
        this.fHelpTopicKey = string4;
        this.fLocationPreferencePanelName = string5;
        this.fPossibleLocations = new ArrayList<DynamicTargetAttribute>(list);
        this.fSupportedReferenceModes = new ArrayList<FileReferenceMode>();
        for (FileReferenceMode fileReferenceMode : list2) {
            if (!fileReferenceMode.isSupportedOnCurrentPlatform()) continue;
            this.fSupportedReferenceModes.add(fileReferenceMode);
        }
        this.fDescription = string3;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getHelpTopicKey() {
        return this.fHelpTopicKey;
    }

    public String getLocationPreferencePanelName() {
        return this.fLocationPreferencePanelName;
    }

    public List<DynamicTargetAttribute> getLocationGenerators() {
        return new ArrayList<DynamicTargetAttribute>(this.fPossibleLocations);
    }

    public File getLocation(XmlReader xmlReader) {
        return this.getLocation(null, null, xmlReader);
    }

    public File getLocation(Configuration configuration, VariableGraph variableGraph, XmlReader xmlReader) {
        File file = null;
        for (DynamicTargetAttribute dynamicTargetAttribute : this.fPossibleLocations) {
            String string = dynamicTargetAttribute.evaluateString(new XslInput(configuration, variableGraph, xmlReader));
            if (string == null || string.trim().length() <= 0 || !(file = ProjectManager.relativeLocationToFile(string)).exists()) continue;
            return file;
        }
        return file;
    }

    public List<FileReferenceMode> getSupportedReferenceModes() {
        return new ArrayList<FileReferenceMode>(this.fSupportedReferenceModes);
    }
}

