/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.HyperlinkMJLabel;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.OptionListWithDefault;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.EnumWidgetStyle;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class EnumWidget
extends AbstractParamWidget<String> {
    private final EnumWidgetStyle fStyle;
    private final JComboBox fComboBox;
    private final MJPanel fRadioPanel;
    private final List<MJRadioButton> fRadioButtons;
    private final JComponent fComponent;
    private final List<String> fKeys;
    private final List<JComponent> fEnableDisableComponents;
    private final ParameterRunnable<String> fSelector;
    private final PropertyChangeListener fPropertyChangeListener;
    private final Project fProject;
    private final Param fParam;
    private OptionListWithDefault fOptions;
    private boolean fSuspendFiringChangeEvents;
    private String fSelectedKey;
    private PropertyChangeListener fFocusListener;
    private boolean fNeedRefresh;
    private HyperlinkMJLabel fMoreInfoLink;
    private static final String LOADING_MESSAGE = BuiltInResources.getString("enum.loading");

    public EnumWidget(EnumWidgetStyle enumWidgetStyle, final Param param, final boolean bl, final Project project) {
        OptionListWithDefault optionListWithDefault;
        this.fParam = param;
        this.fStyle = enumWidgetStyle;
        this.fKeys = new ArrayList<String>();
        this.fEnableDisableComponents = new ArrayList<JComponent>();
        this.fProject = project;
        if (this.fStyle == EnumWidgetStyle.COMBO_BOX) {
            this.fComboBox = new JComboBox(){

                @Override
                public Dimension getPreferredSize() {
                    if (bl) {
                        return new Dimension(10, (int)super.getPreferredSize().getHeight());
                    }
                    return super.getPreferredSize();
                }

                @Override
                public Dimension getMinimumSize() {
                    if (bl) {
                        return new Dimension(0, (int)super.getMinimumSize().getHeight());
                    }
                    return super.getPreferredSize();
                }
            };
            this.fComboBox.setName(param.getKey() + ".combobox");
            this.fComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    Object object = EnumWidget.this.fComboBox.getSelectedItem();
                    Object object2 = itemEvent.getItem();
                    if (object2 == object && EnumWidget.this.fComboBox.getSelectedIndex() >= 0 && object != LOADING_MESSAGE) {
                        EnumWidget.this.fSelectedKey = (String)EnumWidget.this.fKeys.get(EnumWidget.this.fComboBox.getSelectedIndex());
                        EnumWidget.this.fireListeners();
                    }
                }
            });
            this.fSelector = new ParameterRunnable<String>(){

                public void run(String string) {
                    if (EnumWidget.this.fProject.getConfiguration().isArbitraryEnumValueAllowed(EnumWidget.this.fParam.getKey()) && EnumWidget.this.fKeys.indexOf(string) < 0) {
                        EnumWidget.this.fKeys.add(string);
                        EnumWidget.this.fComboBox.addItem(string);
                    }
                    if (EnumWidget.this.fOptions != null && Configuration.isUninitialized(EnumWidget.this.fOptions)) {
                        EnumWidget.this.fComboBox.setSelectedItem(LOADING_MESSAGE);
                    } else {
                        EnumWidget.this.fComboBox.setSelectedIndex(EnumWidget.this.fKeys.indexOf(string));
                    }
                }
            };
            this.fRadioPanel = null;
            this.fRadioButtons = null;
            if (param.getMoreInfoLinkCallback() != null) {
                optionListWithDefault = new MJPanel((LayoutManager)new FormLayout("fill:d:grow, 3dlu, fill:d", "center:d"));
                optionListWithDefault.setOpaque(false);
                CellConstraints cellConstraints = new CellConstraints();
                this.fMoreInfoLink = new HyperlinkMJLabel("<html><a href=\"\">" + param.getMoreInfoLinkText() + "</a></html>", new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        new Matlab().evalConsoleOutput(param.getMoreInfoLinkCallback());
                    }
                });
                this.fMoreInfoLink.setVisible(project.getConfiguration().isMoreInfoVisible(param.getKey()));
                optionListWithDefault.add(this.fComboBox, cellConstraints.xy(1, 1));
                optionListWithDefault.add((Component)((Object)this.fMoreInfoLink), cellConstraints.xy(3, 1));
                this.registerFocusListener();
                this.fComponent = optionListWithDefault;
            } else {
                this.registerFocusListener();
                this.fComponent = this.fComboBox;
            }
        } else {
            this.fRadioButtons = new ArrayList<MJRadioButton>();
            this.fRadioPanel = new MJPanel();
            this.fRadioPanel.setOpaque(false);
            this.fSelector = new ParameterRunnable<String>(){

                public void run(String string) {
                    MJRadioButton mJRadioButton = (MJRadioButton)EnumWidget.this.fRadioButtons.get(EnumWidget.this.fKeys.indexOf(string));
                    mJRadioButton.setSelected(true);
                }
            };
            this.fComboBox = null;
            this.fComponent = this.fRadioPanel;
        }
        if (param.getOptionExpression() != null) {
            this.fPropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(Configuration.getEnumOptionsKey(param))) {
                        EnumWidget.this.updateOptions((OptionListWithDefault)propertyChangeEvent.getNewValue());
                    } else if (EnumWidget.this.fMoreInfoLink != null && Configuration.isMoreInfoVisibilityChange(propertyChangeEvent)) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                EnumWidget.this.fMoreInfoLink.setVisible(project.getConfiguration().isMoreInfoVisible(param.getKey()));
                            }
                        });
                    }
                }
            };
            project.addPropertyChangeListener(this.fPropertyChangeListener);
            optionListWithDefault = project.getConfiguration().getParamOptions(param.getKey());
            this.updateOptions(optionListWithDefault);
        } else {
            this.fPropertyChangeListener = null;
            this.installStaticOptions();
        }
    }

    private void installStaticOptions() {
        LinkedHashMap<String, String> linkedHashMap = this.fParam.getOptions();
        if (linkedHashMap != null && !linkedHashMap.isEmpty()) {
            OptionListWithDefault optionListWithDefault = new OptionListWithDefault(linkedHashMap, (String)linkedHashMap.keySet().iterator().next());
            this.updateOptions(optionListWithDefault);
        }
    }

    public void updateOptions(final OptionListWithDefault optionListWithDefault) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                EnumWidget.this.fOptions = optionListWithDefault;
                Map<String, String> map = optionListWithDefault.getOptions();
                String string = EnumWidget.this.fSelectedKey;
                String string2 = EnumWidget.this.fProject.getConfiguration().getParamAsString(EnumWidget.this.fParam.getKey());
                if ((string == null || string.length() == 0) && string2 != null) {
                    string = string2;
                }
                if (string == null || !map.containsKey(string) && !EnumWidget.this.fProject.getConfiguration().isArbitraryEnumValueAllowed(EnumWidget.this.fParam.getKey())) {
                    string = optionListWithDefault.getDefault();
                }
                EnumWidget.this.fKeys.clear();
                EnumWidget.this.fKeys.addAll(map.keySet());
                if (!EnumWidget.this.fKeys.contains(string)) {
                    EnumWidget.this.fKeys.add(string);
                }
                EnumWidget.this.fEnableDisableComponents.clear();
                if (EnumWidget.this.fStyle == EnumWidgetStyle.COMBO_BOX) {
                    EnumWidget.this.fSuspendFiringChangeEvents = true;
                    EnumWidget.this.fComboBox.removeAllItems();
                    DynamicTargetAttribute dynamicTargetAttribute = EnumWidget.this.fParam.getEnabledAttribute();
                    String string3 = EnumWidget.this.fParam.getInfrastructureAttributes().get("disable-msg");
                    String string4 = EnumWidget.this.fProject.getConfiguration().getResourceString(string3);
                    if (!EnumWidget.this.fProject.getConfiguration().isParamEnabled(EnumWidget.this.fParam.getKey()) && string4 != null && string4.length() > 0 && (map == null || map.values().isEmpty() || map.values().size() == 1 && map.values().iterator().next().length() == 0)) {
                        EnumWidget.this.fComboBox.addItem(string4);
                        EnumWidget.this.fComboBox.setSelectedItem(string4);
                    } else if (Configuration.isUninitialized(optionListWithDefault)) {
                        EnumWidget.this.fComboBox.addItem(LOADING_MESSAGE);
                        EnumWidget.this.fComboBox.setSelectedItem(LOADING_MESSAGE);
                    }
                    if (Configuration.isUninitialized(optionListWithDefault)) {
                        EnumWidget.this.fComboBox.addItem(LOADING_MESSAGE);
                        EnumWidget.this.fComboBox.setSelectedItem(LOADING_MESSAGE);
                    }
                    for (String string5 : map.values()) {
                        EnumWidget.this.fComboBox.addItem(string5);
                    }
                    if (!map.containsKey(string)) {
                        EnumWidget.this.fComboBox.addItem(string);
                    }
                    EnumWidget.this.fSuspendFiringChangeEvents = false;
                    EnumWidget.this.fEnableDisableComponents.add(EnumWidget.this.fComboBox);
                    DetailedToolTip.install((Component)EnumWidget.this.fComboBox, EnumWidget.this.fProject.getConfiguration(), EnumWidget.this.fParam);
                    EnumWidget.this.fComponent.setOpaque(false);
                } else {
                    EnumWidget.this.fRadioPanel.removeAll();
                    EnumWidget.this.fRadioPanel.revalidate();
                    EnumWidget.this.fRadioPanel.repaint();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < map.size(); ++i) {
                        arrayList.add("d");
                        if (i >= map.size() - 1) continue;
                        arrayList.add("3dlu");
                    }
                    String string6 = "d ";
                    String string7 = StringUtils.join(arrayList, (String)",");
                    FormLayout formLayout = EnumWidget.this.fStyle == EnumWidgetStyle.RADIO_HORIZONTAL ? new FormLayout(string7, string6) : new FormLayout(string6, string7);
                    EnumWidget.this.fRadioPanel.setLayout((LayoutManager)formLayout);
                    CellConstraints cellConstraints = new CellConstraints();
                    ButtonGroup buttonGroup = new ButtonGroup();
                    Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
                    EnumWidget.this.fRadioButtons.clear();
                    for (int i = 0; i < map.size(); ++i) {
                        String string8;
                        final Map.Entry<String, String> entry = iterator.next();
                        final MJRadioButton mJRadioButton = new MJRadioButton(entry.getValue());
                        EnumWidget.this.fEnableDisableComponents.add(mJRadioButton);
                        DetailedToolTip.install((Component)mJRadioButton, EnumWidget.this.fProject.getConfiguration(), EnumWidget.this.fParam);
                        mJRadioButton.setName(EnumWidget.this.fParam.getKey() + ".radio." + entry.getKey());
                        mJRadioButton.setOpaque(false);
                        if (entry.getKey().startsWith("option.") && (string8 = EnumWidget.this.fParam.getResourceProvider().getResource(entry.getKey() + ".desc")) != null) {
                            mJRadioButton.setToolTipText(string8);
                        }
                        buttonGroup.add((AbstractButton)mJRadioButton);
                        EnumWidget.this.fRadioButtons.add(mJRadioButton);
                        mJRadioButton.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent itemEvent) {
                                if (mJRadioButton.isSelected()) {
                                    EnumWidget.this.fSelectedKey = (String)entry.getKey();
                                    EnumWidget.this.fireListeners();
                                }
                            }
                        });
                        if (EnumWidget.this.fStyle == EnumWidgetStyle.RADIO_HORIZONTAL) {
                            EnumWidget.this.fRadioPanel.add((Component)mJRadioButton, (Object)cellConstraints.xy(i * 2 + 1, 1));
                            continue;
                        }
                        EnumWidget.this.fRadioPanel.add((Component)mJRadioButton, (Object)cellConstraints.xy(1, i * 2 + 1));
                    }
                    EnumWidget.this.fRadioPanel.revalidate();
                    EnumWidget.this.fRadioPanel.repaint();
                }
                if (!Configuration.isUninitialized(optionListWithDefault)) {
                    EnumWidget.this.setData(string);
                }
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fPropertyChangeListener != null) {
            this.fProject.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        for (Component component : this.fEnableDisableComponents) {
            DetailedToolTip.uninstall(component);
        }
        if (this.fFocusListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.fFocusListener);
        }
    }

    public void setData(String string) {
        this.fSelector.run((Object)string);
    }

    public String getData() {
        return this.fSelectedKey;
    }

    public void setEnabled(boolean bl) {
        for (JComponent jComponent : this.fEnableDisableComponents) {
            jComponent.setEnabled(bl);
        }
        if (this.fStyle == EnumWidgetStyle.COMBO_BOX && this.fProject != null && this.fProject.getConfiguration() != null && this.fParam != null) {
            if (this.fParam.getOptionExpression() != null) {
                OptionListWithDefault optionListWithDefault = this.fProject.getConfiguration().getParamOptions(this.fParam.getKey());
                this.updateOptions(optionListWithDefault);
            } else {
                this.installStaticOptions();
            }
        }
    }

    public Component getComponent() {
        return this.fComponent;
    }

    @Override
    public boolean isExternalLabelRequired() {
        return this.fStyle == EnumWidgetStyle.COMBO_BOX;
    }

    @Override
    protected void fireListeners() {
        if (!this.fSuspendFiringChangeEvents) {
            super.fireListeners();
        }
    }

    private void registerFocusListener() {
        this.fFocusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() != SwingUtilities.windowForComponent(EnumWidget.this.fComponent)) {
                    EnumWidget.this.fNeedRefresh = true;
                } else if (EnumWidget.this.fNeedRefresh) {
                    EnumWidget.this.fProject.getConfiguration().refreshParamOptions(EnumWidget.this.fParam.getKey());
                    EnumWidget.this.fNeedRefresh = false;
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.fFocusListener);
    }
}

