/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.table.DefaultSettingsTableCellEditorFactory;
import com.mathworks.project.impl.settingsui.table.MacSettingsTableCellEditorFactory;
import com.mathworks.project.impl.settingsui.table.ValueColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import com.mathworks.util.Holder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.SearchTextField;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import javax.swing.JComponent;

public final class SettingsTableUtils {
    private SettingsTableUtils() {
    }

    public static PropertyTable<Param> createTable(Project project, List<ParamSet> list, List<? extends PropertyTableColumn<Param>> list2) {
        return SettingsTableUtils.createTable(project, list, new ArrayList<String>(0), list2);
    }

    public static PropertyTable<Param> createTable(Configuration configuration, ParamSet paramSet, List<Param> list, List<String> list2, List<? extends PropertyTableColumn<Param>> list3) {
        return SettingsTableUtils.createTable(configuration.getProject(), Arrays.asList(new ParamSet(paramSet, list)), list2, list3);
    }

    public static PropertyTable<Param> createTable(Project project, List<ParamSet> list, List<String> list2, final List<? extends PropertyTableColumn<Param>> list3) {
        Object object;
        final Configuration configuration = project.getConfiguration();
        ArrayList arrayList = new ArrayList();
        if (list.size() == 1) {
            SettingsTableUtils.populate(configuration, null, arrayList, list.get(0), list2);
        } else {
            for (ParamSet object22 : list) {
                object = new PropertyTableNode<Param>(null, true, object22.getName());
                SettingsTableUtils.populate(configuration, object, null, object22, list2);
                arrayList.add((PropertyTableNode<Param>)object);
            }
        }
        final Holder holder = new Holder();
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (holder.get() != null) {
                    ((PropertyTableModel)holder.get()).fireChange();
                }
            }
        };
        object = new Runnable(){

            @Override
            public void run() {
                configuration.removePropertyChangeListener(propertyChangeListener);
                for (PropertyTableColumn propertyTableColumn : list3) {
                    if (!(propertyTableColumn instanceof ValueColumn)) continue;
                    ((ValueColumn)propertyTableColumn).dispose();
                }
            }
        };
        Predicate<Param> predicate = new Predicate<Param>(){

            public boolean accept(Param param) {
                return configuration.isParamVisible(param.getKey()) && configuration.isParamEnabled(param.getKey());
            }
        };
        PropertyTableSearchPredicate<Param> propertyTableSearchPredicate = new PropertyTableSearchPredicate<Param>(){

            @Override
            public boolean accept(Param param, String string) {
                return param.getName().toUpperCase(Locale.getDefault()).contains(string.toUpperCase(Locale.getDefault()));
            }
        };
        configuration.addPropertyChangeListener(propertyChangeListener);
        holder.set(new PropertyTableModel<Param>(list3, (Runnable)object, predicate, propertyTableSearchPredicate, arrayList));
        ((PropertyTableModel)holder.get()).expandAll();
        PropertyTableCellEditorFactory<Param> propertyTableCellEditorFactory = PlatformInfo.isMacintosh() ? new MacSettingsTableCellEditorFactory(configuration) : new DefaultSettingsTableCellEditorFactory(configuration);
        return new PropertyTable<Param>((PropertyTableModel)holder.get(), propertyTableCellEditorFactory);
    }

    public static <T> JComponent bindWithFilter(final PropertyTable<T> propertyTable) {
        final String string = propertyTable.getModel().getSearchText();
        SearchTextField searchTextField = new SearchTextField("");
        searchTextField.getComponent().setName("settings.search.field");
        searchTextField.setPromptText(BuiltInResources.getString("settings.search.prompt"));
        SearchTextField.Listener listener = new SearchTextField.Listener(){

            public void search(String string2) {
            }

            public void searchTextChanged(String string2) {
                propertyTable.stopEditing(PlatformInfo.isMacintosh());
                if (string2.isEmpty()) {
                    propertyTable.setSearchText(string);
                } else {
                    propertyTable.setSearchText(string2);
                }
                propertyTable.getComponent().revalidate();
                propertyTable.getComponent().repaint();
            }

            public void searchCleared() {
            }
        };
        searchTextField.addSearchTextFieldListener(listener);
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d:grow"));
        mJPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)propertyTable.getComponent(), (Object)cellConstraints.xyw(1, 4, 3));
        mJPanel.add((Component)searchTextField.getComponent(), (Object)cellConstraints.xy(2, 2));
        return mJPanel;
    }

    private static void populate(Configuration configuration, PropertyTableNode<Param> propertyTableNode, List<PropertyTableNode<Param>> list, ParamSet paramSet, List<String> list2) {
        Stack stack = new Stack();
        PropertyTableNode propertyTableNode2 = null;
        PropertyTableNode propertyTableNode3 = null;
        stack.push(propertyTableNode);
        for (List<Param> list3 : SettingsTableUtils.groupByVisibleBaseParams(configuration, configuration.getActiveProfile(), paramSet, paramSet.getParams(), list2)) {
            PropertyTableNode<Param> propertyTableNode4;
            String string = paramSet.getCategoryName(list3.get(0));
            String string2 = list3.get(0).getInstanceName();
            boolean bl = list3.get(0).getType().isFinite();
            if (list2.isEmpty() && string2 != null && (propertyTableNode2 == null || !string2.equals(propertyTableNode2.getGroupLabel()))) {
                if (propertyTableNode2 != null) {
                    stack.pop();
                }
                if ((propertyTableNode2 = new PropertyTableNode((PropertyTableNode)stack.peek(), false, string2)).getParent() == null) {
                    list.add(propertyTableNode2);
                }
                stack.push(propertyTableNode2);
            } else if (list2.isEmpty() && string2 == null && propertyTableNode2 != null) {
                propertyTableNode2 = null;
                stack.pop();
            }
            if (!(string == null || propertyTableNode3 != null && string.equals(propertyTableNode3.getGroupLabel()))) {
                if (propertyTableNode3 != null) {
                    stack.pop();
                }
                if ((propertyTableNode3 = new PropertyTableNode((PropertyTableNode)stack.peek(), false, string)).getParent() == null) {
                    list.add(propertyTableNode3);
                }
                stack.push(propertyTableNode3);
            } else if (string == null && propertyTableNode3 != null) {
                propertyTableNode3 = null;
                stack.pop();
            }
            if ((propertyTableNode4 = new PropertyTableNode<Param>((PropertyTableNode)stack.peek(), bl, list3)).getParent() != null) continue;
            list.add(propertyTableNode4);
        }
    }

    private static boolean isInvisible(Configuration configuration, Profile profile, ParamSet paramSet, Param param) {
        return Configuration.isAlwaysInvisible(paramSet, param, profile) || param.isExperimental() && !configuration.isParamVisible(param.getKey());
    }

    private static List<List<Param>> groupByVisibleBaseParams(Configuration configuration, Profile profile, ParamSet paramSet, List<Param> list, List<String> list2) {
        if (list2.isEmpty()) {
            ArrayList<List<Param>> arrayList = new ArrayList<List<Param>>();
            for (Param param : list) {
                if (SettingsTableUtils.isInvisible(configuration, profile, paramSet, param)) continue;
                arrayList.add(Arrays.asList(param));
            }
            return arrayList;
        }
        List<Object> list3 = Collections.nCopies(list2.size(), null);
        LinkedHashMap<String, ArrayList<Param>> linkedHashMap = new LinkedHashMap<String, ArrayList<Param>>();
        for (Param param : list) {
            if (SettingsTableUtils.isInvisible(configuration, profile, paramSet, param)) continue;
            for (int i = 0; i < list2.size(); ++i) {
                String string = list2.get(i);
                if (!param.getKey().endsWith(string)) continue;
                String string2 = param.getKey().substring(0, param.getKey().indexOf(string));
                ArrayList<Param> arrayList = (ArrayList<Param>)linkedHashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<Param>(list2.size());
                    arrayList.addAll(list3);
                    linkedHashMap.put(string2, arrayList);
                }
                arrayList.set(i, param);
            }
        }
        return new ArrayList<List<Param>>(linkedHashMap.values());
    }
}

