/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class AbstractComboBoxCellEditor<T>
implements PropertyTableCellEditor<T> {
    private final MJComboBox fComponent = new MJComboBox();
    private final PropertyTable<T> fTable;
    private final Map<Object, Selector> fSelectors;
    private boolean fAddedCommitListener;

    public AbstractComboBoxCellEditor(PropertyTable<T> propertyTable) {
        this(propertyTable, AbstractComboBoxCellEditor.createBooleanOptions());
    }

    public AbstractComboBoxCellEditor(PropertyTable<T> propertyTable, Class<?> clazz) {
        this(propertyTable, AbstractComboBoxCellEditor.createOptions(clazz));
    }

    public AbstractComboBoxCellEditor(PropertyTable<T> propertyTable, Map<?, String> map) {
        this.fComponent.setName(propertyTable.getComponent().getName() + ".editor");
        this.fSelectors = new HashMap<Object, Selector>();
        this.fTable = propertyTable;
        this.fComponent.setFont(this.fTable.getFont());
        this.fComponent.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && !AbstractComboBoxCellEditor.this.fComponent.isPopupVisible()) {
                    AbstractComboBoxCellEditor.this.fTable.stopEditing(true);
                    AbstractComboBoxCellEditor.this.fTable.requestFocus();
                } else if (keyEvent.getKeyCode() == 10 && !AbstractComboBoxCellEditor.this.fComponent.isPopupVisible()) {
                    AbstractComboBoxCellEditor.this.fTable.stopEditing(false);
                    AbstractComboBoxCellEditor.this.fTable.requestFocus();
                }
            }
        });
        for (Map.Entry<?, String> entry : map.entrySet()) {
            Selector selector = new Selector(entry.getKey(), entry.getValue());
            this.fSelectors.put(selector.getValue(), selector);
            this.fComponent.addItem((Object)selector);
        }
    }

    private static Map<Object, String> createBooleanOptions() {
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>();
        linkedHashMap.put(false, BuiltInResources.getString("param.boolean.false"));
        linkedHashMap.put(true, BuiltInResources.getString("param.boolean.true"));
        return linkedHashMap;
    }

    private static Map<Object, String> createOptions(Class<?> clazz) {
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return AbstractComboBoxCellEditor.createBooleanOptions();
        }
        return AbstractComboBoxCellEditor.createEnumOptions(clazz);
    }

    private static Map<Object, String> createEnumOptions(Class<?> clazz) {
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>();
        for (Object obj : clazz.getEnumConstants()) {
            linkedHashMap.put(obj, obj.toString());
        }
        return linkedHashMap;
    }

    public void setData(Object object) {
        Selector selector = this.fSelectors.get(object);
        if (selector != null) {
            this.fComponent.setSelectedItem((Object)selector);
        }
        if (!this.fAddedCommitListener) {
            this.fAddedCommitListener = true;
            this.fComponent.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    AbstractComboBoxCellEditor.this.fTable.commitEditedValue();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    public Object getData() {
        Selector selector = (Selector)this.fComponent.getSelectedItem();
        return selector == null ? null : selector.getValue();
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void activate() {
        this.fComponent.showPopup();
    }

    private static class Selector {
        private final Object fValue;
        private final String fText;

        Selector(Object object, String string) {
            this.fValue = object;
            this.fText = string;
        }

        public Object getValue() {
            return this.fValue;
        }

        public String getText() {
            return this.fText;
        }

        public String toString() {
            return this.fText;
        }
    }
}

