/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.TooltipWindow;
import com.mathworks.project.impl.table.VirtualComponent;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class VirtualComponentManager {
    private final Map<Integer, Map<Integer, List<VirtualComponent>>> fComponents;
    private final JComponent fTableComponent;
    private VirtualComponent fHovered;
    private TooltipWindow fToolTip;
    private Timer fHoverTimer;
    private static final Color TOOLTIP_BACKGROUND = new Color(254, 254, 216);
    private static final Color TOOLTIP_BORDER = PlatformInfo.isMacintosh() ? new Color(120, 115, 40) : new Color(89, 75, 6);

    public VirtualComponentManager(JComponent jComponent) {
        this.fTableComponent = jComponent;
        this.fComponents = new HashMap<Integer, Map<Integer, List<VirtualComponent>>>();
    }

    public void defineCellComponents(int n, int n2, VirtualComponent ... virtualComponentArray) {
        this.defineCellComponents(n, n2, Arrays.asList(virtualComponentArray));
    }

    public void defineCellComponents(int n, int n2, List<VirtualComponent> list) {
        List<VirtualComponent> list2 = this.getList(n, n2, true);
        list2.clear();
        list2.addAll(list);
    }

    public List<VirtualComponent> getComponents(int n, int n2) {
        LinkedList linkedList = this.getList(n, n2, false);
        return linkedList == null ? new LinkedList() : linkedList;
    }

    public void reset() {
        this.unhover();
        this.fComponents.clear();
    }

    public boolean hasAnyComponents() {
        return !this.fComponents.isEmpty();
    }

    public void mouseMove(int n, int n2, Point point) {
        List<VirtualComponent> list = this.getList(n, n2, false);
        if (list != null) {
            for (VirtualComponent virtualComponent : list) {
                if (!virtualComponent.getBounds().contains(point)) continue;
                if (this.fHovered == null || !this.fHovered.equals(virtualComponent)) {
                    this.hover(virtualComponent);
                }
                return;
            }
        }
        this.unhover();
    }

    private void unhover() {
        if (this.fHovered != null) {
            this.fHovered.setHovered(false);
            this.fHovered = null;
        }
        if (this.fToolTip != null) {
            this.fToolTip.close();
        }
        if (this.fHoverTimer != null) {
            this.fHoverTimer.stop();
            this.fHoverTimer = null;
        }
        this.fTableComponent.revalidate();
        this.fTableComponent.repaint();
    }

    private void hover(VirtualComponent virtualComponent) {
        if (this.fHovered != null) {
            this.fHovered.setHovered(false);
            this.fHovered = null;
        }
        if (this.fToolTip != null) {
            this.fToolTip.close();
        }
        this.fHovered = virtualComponent;
        virtualComponent.setHovered(true);
        JComponent jComponent = virtualComponent.getToolTipContent();
        if (jComponent != null) {
            this.fToolTip = new TooltipWindow(SwingUtilities.windowForComponent(this.fTableComponent), this.fTableComponent, false, false, true, 2, TOOLTIP_BACKGROUND, TOOLTIP_BORDER);
            int n = (int)(virtualComponent.getBounds().getX() + virtualComponent.getBounds().getWidth() / 2.0);
            int n2 = (int)(virtualComponent.getBounds().getY() + virtualComponent.getBounds().getHeight());
            Point point = new Point(n, n2);
            SwingUtilities.convertPointToScreen(point, this.fTableComponent);
            n = point.x;
            n2 = point.y;
            this.fToolTip.update(jComponent, n, n2);
            if (PlatformInfo.isMacintosh()) {
                this.fToolTip.showWithAnimation(jComponent, n, n2);
            } else {
                this.fToolTip.setFocusableWindowState(false);
                this.fToolTip.setVisible(true);
                this.fToolTip.setFocusableWindowState(true);
            }
        }
        if (this.fHoverTimer != null) {
            this.fHoverTimer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                    if (pointerInfo != null) {
                        Point point = pointerInfo.getLocation();
                        if (point == null || VirtualComponentManager.this.fHovered == null) {
                            VirtualComponentManager.this.unhover();
                        } else {
                            SwingUtilities.convertPointFromScreen(point, VirtualComponentManager.this.fTableComponent);
                            if (!VirtualComponentManager.this.fHovered.getBounds().contains(point)) {
                                VirtualComponentManager.this.unhover();
                            }
                        }
                    }
                }
            });
            this.fHoverTimer.setRepeats(true);
            this.fHoverTimer.start();
        }
        this.fTableComponent.revalidate();
        this.fTableComponent.repaint();
    }

    private List<VirtualComponent> getList(int n, int n2, boolean bl) {
        List<VirtualComponent> list;
        Map<Integer, List<VirtualComponent>> map = this.fComponents.get(n);
        if (map == null) {
            if (!bl) {
                return null;
            }
            map = new HashMap<Integer, List<VirtualComponent>>();
            this.fComponents.put(n, map);
        }
        if ((list = map.get(n2)) == null && bl) {
            list = new LinkedList<VirtualComponent>();
            map.put(n2, list);
        }
        return list;
    }
}

