/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer.utils.strategies;

import com.mathworks.peermodel.synchronizer.utils.ImageDifferenceStrategy;
import com.mathworks.peermodel.synchronizer.utils.strategies.ImageDifferenceStrategy1cByte;
import com.mathworks.peermodel.synchronizer.utils.strategies.ImageDifferenceStrategy1cInt;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Map;

public class ImageDifferenceStrategy1c
implements ImageDifferenceStrategy {
    private static final int TILE_SIZE = 300;
    private static ImageDifferenceStrategy byteStrategy = new ImageDifferenceStrategy1cByte(300);
    private static ImageDifferenceStrategy intStrategy = new ImageDifferenceStrategy1cInt(300);

    @Override
    public void diffImages(BufferedImage oldImage, BufferedImage newImage, Collection<Map<String, Object>> diffs) {
        if (oldImage.getType() != newImage.getType()) {
            throw new IllegalArgumentException("old image type " + oldImage.getType() + " != " + newImage.getType());
        }
        switch (newImage.getType()) {
            case 5: 
            case 6: {
                byteStrategy.diffImages(oldImage, newImage, diffs);
                break;
            }
            case 1: 
            case 2: {
                intStrategy.diffImages(oldImage, newImage, diffs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type " + oldImage.getType());
            }
        }
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        byteStrategy.setParameters(parameters);
        intStrategy.setParameters(parameters);
    }
}

