/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import com.mathworks.hadoop.ChunkFileRecordReader;
import com.mathworks.hadoop.MWArrayWritable;
import com.mathworks.hadoop.MWMapObject;
import com.mathworks.hadoop.MWReduceObject;
import com.mathworks.hadoop.MWSharedMCRFactory;
import com.mathworks.hadoop.MWWritableOutput;
import com.mathworks.hadoop.MapUtil;
import com.mathworks.hadoop.MxArrayWritable;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.toolbox.javabuilder.MWArray;
import com.mathworks.toolbox.javabuilder.MWCharArray;
import com.mathworks.toolbox.javabuilder.MWComponentOptions;
import com.mathworks.toolbox.javabuilder.MWCtfExtractLocation;
import com.mathworks.toolbox.javabuilder.MWCtfStreamSource;
import com.mathworks.toolbox.javabuilder.MWJavaObjectRef;
import com.mathworks.toolbox.javabuilder.internal.MWFunctionSignature;
import com.mathworks.toolbox.javabuilder.internal.MWMCR;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MWMapReduceDriver
extends Configured
implements Tool {
    private boolean mdebug = false;
    private boolean jdebug = false;
    private boolean appmode = false;

    private void parseSettings(Configuration conf) throws Exception {
        InputStream is = null;
        String tmpjars = conf.get("tmpjars");
        if (tmpjars != null && !tmpjars.isEmpty()) {
            System.out.println("tmpjars: " + tmpjars);
            String[] jars = tmpjars.split(",");
            Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            for (String jar : jars) {
                int pos = jar.indexOf(58);
                String settingjar = jar;
                System.out.println("jar: " + jar);
                if (pos >= 0) {
                    settingjar = jar.substring(pos + 1);
                }
                if (settingjar.length() <= 4) continue;
                File file = new File(settingjar);
                URL url = file.toURI().toURL();
                addURL.invoke((Object)cl, url);
            }
        }
        ZipFile CTFPackage = null;
        if (conf.get("settingfile") != null) {
            is = new FileInputStream(conf.get("settingfile"));
        } else if (conf.get("LocalCTFFileName") != null) {
            CTFPackage = new ZipFile(new File(conf.get("LocalCTFFileName")), 1);
            ZipEntry settingfile = CTFPackage.getEntry(".META/MWHadoopSettings.txt");
            if (settingfile != null) {
                is = CTFPackage.getInputStream(settingfile);
            }
        } else {
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            is = cl.getResourceAsStream("MWHadoopSettings.txt");
        }
        if (is != null) {
            String l;
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            while ((l = r.readLine()) != null) {
                int pos;
                if (l.trim().startsWith("#") || (pos = l.indexOf(61)) <= 0 || conf.get(l.substring(0, pos)) != null) continue;
                conf.set(l.substring(0, pos).trim(), l.substring(pos + 1).trim());
            }
        } else if (!this.appmode) {
            System.out.println("Warning: setting file (MWHadoopSettings.txt or -D settingfile=<file>) not found!");
        }
        if (CTFPackage != null) {
            CTFPackage.close();
        }
    }

    public static void updateLibraryPath(Configuration conf) {
        String path = System.getProperty("java.library.path");
        if (path != null) {
            path = path.trim();
        }
        String mcr = conf.get("mw.mcrroot");
        String os = System.getProperty("os.name").toLowerCase();
        String classpath = null;
        String libenv = null;
        if (os.indexOf("win") > -1) {
            libenv = "PATH=";
            classpath = System.getProperty("os.arch").toLowerCase().indexOf("64") >= 0 ? mcr + "\\runtime\\win64;" + mcr + "\\bin\\win64" : mcr + "\\runtime\\win32;" + mcr + "\\bin\\win32";
        } else if (os.indexOf("nux") > -1) {
            classpath = mcr + "/runtime/glnxa64:" + mcr + "/bin/glnxa64";
            libenv = "LD_LIBRARY_PATH=";
        } else if (os.indexOf("mac") > -1) {
            classpath = mcr + "/runtime/maci64:" + mcr + "/bin/maci64";
            libenv = "DYLD_LIBRARY_PATH=";
        } else {
            System.err.printf("Platform not supported!", new Object[0]);
            return;
        }
        String env = conf.get("mapred.child.env");
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (env == null || env.isEmpty()) {
            conf.set("mapred.child.env", "MCR_CACHE_ROOT=" + tmpdir + "," + libenv + classpath);
        } else {
            int index = env.indexOf("MCR_CACHE_ROOT=");
            if (index < 0) {
                env = env + "," + tmpdir;
            }
            if ((index = env.indexOf(libenv)) >= 0) {
                conf.set("mapred.child.env", env.replace(libenv, libenv + classpath + File.pathSeparator));
            } else {
                conf.set("mapred.child.env", env + "," + libenv + classpath);
            }
        }
        System.out.println("mapred.child.env: " + conf.get("mapred.child.env"));
        String jopts = conf.get("mapred.child.java.opts");
        if (jopts == null || jopts.isEmpty()) {
            conf.set("mapred.child.java.opts", "-Djava.library.path=" + classpath);
        } else {
            int index = jopts.indexOf("-Djava.library.path=");
            if (index >= 0) {
                conf.set("mapred.child.java.opts", jopts.replace("-Djava.library.path=", "-Djava.library.path=" + classpath + File.pathSeparator));
            } else {
                conf.set("mapred.child.java.opts", jopts + " -Djava.library.path=" + classpath);
            }
        }
        System.out.println("mapred.child.java.opts: " + conf.get("mapred.child.java.opts"));
        path = path == null || path.isEmpty() ? classpath : path + File.pathSeparator + classpath;
        try {
            System.setProperty("java.library.path", path);
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(System.class.getClassLoader(), null);
            System.out.println("New java.library.path: " + path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setMapReduceProperties(Job job, MapReduceType maptype, MapReduceType reducetype) throws Exception {
        String groupingComparator;
        String sortComparator;
        String partitioner;
        String reduceOutputValue;
        String reduceOutputKey;
        String mapOutputValue;
        String mapOutputKey;
        String outputFormat;
        Configuration conf = job.getConfiguration();
        String inputFormat = conf.get("mw.inputformat");
        if (inputFormat == null || inputFormat.isEmpty()) {
            inputFormat = null;
        }
        if ((outputFormat = conf.get("mw.outputformat")) == null || outputFormat.isEmpty()) {
            outputFormat = null;
        }
        if ((mapOutputKey = conf.get("mw.mapoutputkey")) == null || mapOutputKey.isEmpty()) {
            mapOutputKey = null;
        }
        if ((mapOutputValue = conf.get("mw.mapoutputvalue")) == null || mapOutputValue.isEmpty()) {
            mapOutputValue = null;
        }
        if ((reduceOutputKey = conf.get("mw.outputkey")) == null || reduceOutputKey.isEmpty()) {
            reduceOutputKey = null;
        }
        if ((reduceOutputValue = conf.get("mw.outputvalue")) == null || reduceOutputValue.isEmpty()) {
            reduceOutputValue = null;
        }
        if ((partitioner = conf.get("mw.partitioner")) == null || partitioner.isEmpty()) {
            partitioner = null;
        }
        if ((sortComparator = conf.get("mw.sortcomparator")) == null || sortComparator.isEmpty()) {
            sortComparator = null;
        }
        if ((groupingComparator = conf.get("mw.groupingcomparator")) == null || groupingComparator.isEmpty()) {
            groupingComparator = null;
        }
        boolean isInSequence = false;
        String dsInType = conf.get("mw.ds.in.type");
        if (dsInType != null && (dsInType.equals("seqtext") || dsInType.equals("seqraw") || dsInType.equalsIgnoreCase("binary"))) {
            isInSequence = true;
        }
        switch (maptype) {
            case MATLAB: {
                System.out.println("Using MATLAB mapper.");
                if (this.mdebug) {
                    job.setMapperClass(MWDebugMap.class);
                } else {
                    job.setMapperClass(MWMap.class);
                }
                if (inputFormat != null || isInSequence) break;
                System.out.println("Set input format class to: ChunkFileRecordReader.");
                job.setInputFormatClass(ChunkFileRecordReader.class);
                break;
            }
            case BUILTIN: {
                System.out.println("Using builtin mapper.");
                job.setMapperClass(MWBuiltinMap.class);
                break;
            }
            case DEFAULT: {
                System.out.println("Using Hadoop default mapper.");
                break;
            }
            case USERJAVA: {
                System.out.println("Using user-supplied Java mapper.");
                job.setMapperClass(Class.forName(conf.get("mw.mapper")).asSubclass(Mapper.class));
                break;
            }
            default: {
                System.out.println("Not supported map type.");
            }
        }
        if (dsInType != null && dsInType.equalsIgnoreCase("binary")) {
            System.out.println("Set input format class to: SequenceFileInputFormat.");
            job.setInputFormatClass(SequenceFileInputFormat.class);
        } else if (inputFormat != null) {
            System.out.println("Set input format class to: " + inputFormat);
            job.setInputFormatClass(Class.forName(inputFormat).asSubclass(InputFormat.class));
        } else if (isInSequence) {
            System.out.println("Set input format class to: SequenceFileInputFormat.");
            job.setInputFormatClass(SequenceFileInputFormat.class);
        }
        switch (reducetype) {
            case MATLAB: {
                System.out.println("Using MATLAB reducer.");
                if (this.mdebug) {
                    job.setReducerClass(MWDebugReduce.class);
                    break;
                }
                job.setReducerClass(MWReduce.class);
                break;
            }
            case BUILTIN: {
                System.out.println("Using builtin reducer.");
                job.setReducerClass(MWBuiltinReduce.class);
                break;
            }
            case DEFAULT: {
                System.out.println("Using Hadoop default reducer.");
                break;
            }
            case USERJAVA: {
                System.out.println("Using user-supplied Java reducer.");
                job.setReducerClass(Class.forName(conf.get("mw.reducer")).asSubclass(Reducer.class));
                break;
            }
            default: {
                System.out.println("Not supported reduce type.");
            }
        }
        if (conf.get("mw.combiner") != null) {
            System.out.println("Set combiner class");
            if (conf.get("mw.combiner").equals("built in")) {
                job.setCombinerClass(MWBuiltinCombine.class);
            } else {
                job.setCombinerClass(Class.forName(conf.get("mw.combiner")).asSubclass(Reducer.class));
            }
        }
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        if (mapOutputKey != null) {
            job.setMapOutputKeyClass(Class.forName(mapOutputKey));
        } else if (maptype == MapReduceType.MATLAB && reducetype == MapReduceType.MATLAB) {
            job.setMapOutputKeyClass(MxArrayWritable.class);
        } else if (maptype == MapReduceType.DEFAULT) {
            job.setMapOutputKeyClass(LongWritable.class);
        }
        if (mapOutputValue != null) {
            job.setMapOutputValueClass(Class.forName(mapOutputValue));
        } else if (maptype == MapReduceType.MATLAB && reducetype == MapReduceType.MATLAB) {
            job.setMapOutputValueClass(MxArrayWritable.class);
        }
        if (job.getMapOutputKeyClass().equals(MxArrayWritable.class)) {
            job.setMapOutputValueClass(MxArrayWritable.class);
        }
        if (reduceOutputKey != null) {
            job.setOutputKeyClass(Class.forName(reduceOutputKey));
        } else if (reducetype == MapReduceType.DEFAULT) {
            job.setOutputKeyClass(LongWritable.class);
        }
        if (reduceOutputValue != null) {
            job.setOutputValueClass(Class.forName(reduceOutputValue));
        }
        boolean isMLRedKey = job.getOutputKeyClass().equals(MxArrayWritable.class);
        boolean isMLRedValue = job.getOutputValueClass().equals(MxArrayWritable.class);
        String dsOutType = conf.get("mw.ds.out.type");
        if (reducetype == MapReduceType.MATLAB && (dsOutType == null || dsOutType.equalsIgnoreCase("binary") || isMLRedKey || isMLRedValue)) {
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            job.setOutputKeyClass(MxArrayWritable.class);
            job.setOutputValueClass(MxArrayWritable.class);
        } else if (outputFormat != null) {
            job.setOutputFormatClass(Class.forName(outputFormat).asSubclass(OutputFormat.class));
        }
        System.out.println("Set outputformat class to: " + job.getOutputFormatClass());
        System.out.println("Set map output key class to: " + job.getMapOutputKeyClass());
        System.out.println("Set map output value class to: " + job.getMapOutputValueClass());
        System.out.println("Set reduce output key class to: " + job.getOutputKeyClass());
        System.out.println("Set reduce output value class to: " + job.getOutputValueClass());
        if (partitioner != null) {
            System.out.println("Set partitioner to: " + partitioner);
            job.setPartitionerClass(Class.forName(partitioner).asSubclass(Partitioner.class));
        }
        if (sortComparator != null) {
            System.out.println("Set sort comparator to: " + sortComparator);
            job.setSortComparatorClass(Class.forName(sortComparator).asSubclass(RawComparator.class));
        }
        if (groupingComparator != null) {
            System.out.println("Set grouping comparator to: " + groupingComparator);
            job.setGroupingComparatorClass(Class.forName(groupingComparator).asSubclass(RawComparator.class));
        }
        int chunksize = 0;
        if (conf.get("mw.chunksize") != null && (chunksize = conf.getInt("mw.chunksize", 0)) > 0) {
            ChunkFileRecordReader.chunkSize = chunksize * 1024;
        }
    }

    static String getApplicationMementoFileNameFromDistributedCache(Configuration conf) throws Exception {
        String filename = null;
        Path[] files = DistributedCache.getLocalCacheFiles((Configuration)conf);
        if (null != files) {
            for (int i = 0; i < files.length; ++i) {
                String expectedFileName = conf.get("mw.appmemento");
                File f = new File(files[i].toUri().toString());
                if (f.getName().equals(expectedFileName)) {
                    filename = files[i].toUri().toString();
                    return filename;
                }
                if (i != files.length - 1) continue;
                throw new IOException("Couldn't find map function in distributed cache.");
            }
        } else {
            throw new IOException("Distributed cache is empty.");
        }
        return filename;
    }

    void uploadCTFToDistributeCache(Job job, Configuration conf, String CTFFileName) throws Exception {
        Path LocalCTFPath = new Path(CTFFileName);
        String CTFFileNameInDistCache = LocalCTFPath.getName();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path HDFSJobDir = new Path(fs.getHomeDirectory(), job.getJobName());
        Path HDFSCTFPath = LocalCTFPath;
        if (fs.getUri().getScheme().equals("hdfs")) {
            int index = 0;
            while (fs.exists(HDFSJobDir)) {
                HDFSJobDir = new Path(job.getJobName() + index);
                ++index;
            }
            HDFSCTFPath = new Path(HDFSJobDir, new Path(CTFFileNameInDistCache));
            System.out.println("HDFSCTFPath=" + HDFSCTFPath);
            fs.copyFromLocalFile(LocalCTFPath, HDFSCTFPath);
            DistributedCache.addCacheFile((URI)new URI(HDFSCTFPath.toString()), (Configuration)conf);
            System.out.println("Uploading CTF into distributed cache completed.");
            fs.deleteOnExit(HDFSJobDir);
        }
        conf.set("LocalCTFFileName", CTFFileName);
        conf.set("HDFSCTFFileName", HDFSCTFPath.toString());
    }

    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf(), "MWMapReduceDriver");
        job.setJarByClass(((Object)((Object)this)).getClass());
        Configuration conf = job.getConfiguration();
        this.mdebug = conf.get("mdebug") != null;
        boolean bl = this.appmode = conf.get("mw.mode") != null && conf.get("mw.mode").equals("application");
        if (!(this.appmode || args != null && args.length == 3)) {
            if (this.mdebug) {
                System.err.printf("Usage: %s <settingfile> <input1[,input2,input3...]> <output>\n", ((Object)((Object)this)).getClass().getSimpleName());
            } else {
                System.err.printf("Usage: %s [generic options] <CTF file> <input1[,input2,input3...]> <output>\n", ((Object)((Object)this)).getClass().getSimpleName());
                ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            }
            return -1;
        }
        if (job.getJar() != null && job.getJar().contains("jar" + File.separator + "a1.2.1" + File.separator)) {
            conf.set("mw.hdversion", "1");
        } else {
            conf.set("mw.hdversion", "2");
        }
        if (this.mdebug) {
            conf.set("settingfile", args[0]);
        } else {
            File localCTFFile = new File(args[0]);
            if (!localCTFFile.isFile() || !localCTFFile.exists()) {
                System.err.printf("CTF file '%s' does not exist\n", args[0]);
                return -1;
            }
            String filename = localCTFFile.getName();
            if (filename.lastIndexOf(".") > 0) {
                filename = filename.substring(0, filename.lastIndexOf("."));
            }
            job.setJobName(filename);
            this.uploadCTFToDistributeCache(job, conf, args[0]);
        }
        FileInputFormat.addInputPaths((Job)job, (String)args[1]);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[2]));
        this.parseSettings(conf);
        if (!this.mdebug) {
            String mcrroot = conf.get("mw.mcrroot");
            if (mcrroot == null || mcrroot.isEmpty()) {
                System.err.printf("MCR root is not specified with mw.mcrroot property!\n", new Object[0]);
                return -1;
            }
            MWMapReduceDriver.updateLibraryPath(conf);
        }
        this.jdebug = conf.get("jdebug") != null;
        MapReduceType maptype = MapReduceType.MATLAB;
        String mapper = conf.get("mw.mapper");
        String mapwrapper = conf.get("mw.mapwrapper");
        if (mapwrapper == null || mapwrapper.isEmpty()) {
            if (mapper == null || mapper.isEmpty()) {
                maptype = MapReduceType.DEFAULT;
            } else if (mapper.equals("built in")) {
                maptype = MapReduceType.BUILTIN;
            } else {
                try {
                    Class.forName(mapper);
                    maptype = MapReduceType.USERJAVA;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        MapReduceType reducetype = MapReduceType.MATLAB;
        String reducer = conf.get("mw.reducer");
        String redwrapper = conf.get("mw.reducewrapper");
        if (redwrapper == null || redwrapper.isEmpty()) {
            if (reducer == null) {
                reducetype = MapReduceType.DEFAULT;
            } else if (reducer.equals("built in")) {
                reducetype = MapReduceType.BUILTIN;
            } else {
                try {
                    Class.forName(reducer);
                    reducetype = MapReduceType.USERJAVA;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.jdebug) {
            for (Map.Entry en : conf) {
                System.out.println((String)en.getKey() + "=" + (String)en.getValue());
            }
        }
        if (maptype == MapReduceType.BUILTIN && reducetype == MapReduceType.DEFAULT || maptype == MapReduceType.DEFAULT && reducetype == MapReduceType.BUILTIN) {
            System.err.println("Error: can't mix builtin map/reduce function with default reduce/map function");
            return -1;
        }
        if (this.appmode) {
            maptype = MapReduceType.MATLAB;
            reducetype = MapReduceType.MATLAB;
        }
        this.setMapReduceProperties(job, maptype, reducetype);
        boolean isMLMapkey = job.getMapOutputKeyClass().equals(MxArrayWritable.class);
        boolean isMLMapValue = job.getMapOutputValueClass().equals(MxArrayWritable.class);
        if ((maptype != MapReduceType.MATLAB || reducetype != MapReduceType.MATLAB) && (isMLMapValue || isMLMapkey)) {
            System.err.println("Error: MxArrayWritable as map output key/value class is supported only if both mapper and reducer are Matlab functions.");
            return -1;
        }
        boolean isMLRedKey = job.getOutputKeyClass().equals(MxArrayWritable.class);
        boolean isMLRedValue = job.getOutputValueClass().equals(MxArrayWritable.class);
        if (reducetype != MapReduceType.MATLAB && (isMLRedKey || isMLRedValue)) {
            System.err.println("Error: MxArrayWritable as reduce output key/value class is supported only if the reducer is a Matlab function.");
            return -1;
        }
        System.out.println("*************** run ******************");
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        String path = System.getProperty("java.library.path");
        System.out.println("java.library.path: " + path);
        int exitCode = ToolRunner.run((Tool)new MWMapReduceDriver(), (String[])args);
        System.exit(exitCode);
    }

    static enum MapReduceType {
        MATLAB,
        USERJAVA,
        BUILTIN,
        DEFAULT;

    }

    public static class MWBuiltinReduce
    extends Reducer<Object, Object, Object, Object> {
        private Object obj = null;
        private Method method = null;
        private String reducefunc = null;
        private boolean debug = false;
        boolean isCombiner = false;
        private Class jmapcontext = null;
        private Object expression1 = null;
        private Object expression2 = null;
        private Method jeval = null;
        private Method jset = null;
        private Method jget = null;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.debug = conf.get("jdebug") != null;
            Object jeobj = null;
            Method ce = null;
            String exp1 = null;
            String exp2 = null;
            if (this.isCombiner) {
                if (this.debug) {
                    System.out.println("Using builtin combiner");
                }
                exp1 = conf.get("mw.combine.builtin.exp");
            } else {
                if (this.debug) {
                    System.out.println("Using builtin reducer");
                }
                exp1 = conf.get("mw.reduce.builtin.exp1");
                exp2 = conf.get("mw.reduce.builtin.exp2");
            }
            try {
                if (exp1 != null && !exp1.isEmpty()) {
                    Class<?> jje = Class.forName("org.apache.commons.jexl2.JexlEngine");
                    this.jmapcontext = Class.forName("org.apache.commons.jexl2.MapContext");
                    Class<?> je = Class.forName("org.apache.commons.jexl2.Expression");
                    Class<?> jjc = Class.forName("org.apache.commons.jexl2.JexlContext");
                    jeobj = jje.getConstructor(new Class[0]).newInstance(new Object[0]);
                    ce = jje.getMethod("createExpression", String.class);
                    this.expression1 = ce.invoke(jeobj, exp1);
                    this.jeval = je.getMethod("evaluate", jjc);
                    this.jset = this.jmapcontext.getMethod("set", String.class, Object.class);
                    this.jget = this.jmapcontext.getMethod("get", String.class);
                    String regcls = conf.get("mw.reduce.builtin.registerclasses");
                    if (regcls != null) {
                        String[] cls;
                        HashMap funcs = new HashMap();
                        for (String cl : cls = regcls.split(";")) {
                            String[] pair = cl.split(",");
                            if (pair.length != 2) continue;
                            funcs.put(pair[0], Class.forName(pair[1]));
                            if (!this.debug) continue;
                            System.out.println("Register name: " + pair[0] + " with " + pair[1]);
                        }
                        Method setfuns = jje.getMethod("setFunctions", Map.class);
                        setfuns.invoke(jeobj, funcs);
                    }
                    if (exp2 != null) {
                        this.expression2 = ce.invoke(jeobj, exp2);
                    }
                }
            }
            catch (Exception e) {
                StackTraceElement[] st = e.getStackTrace();
                String errorMsg = "";
                for (StackTraceElement el : st) {
                    errorMsg = errorMsg + el.toString() + "\n";
                    if (el.getMethodName().equals("setup") && el.getClassName().endsWith("MWBuiltinReduce")) break;
                }
                throw new IOException(errorMsg);
            }
        }

        public void reduce(Object key, Iterable<Object> values, Reducer.Context context) throws IOException, InterruptedException {
            block19: {
                if (this.debug) {
                    System.out.println("Reduce, processing key: " + key.toString());
                }
                try {
                    Object results;
                    boolean first = true;
                    if (this.expression1 == null) {
                        for (Object value : values) {
                            if (first) {
                                if (this.debug) {
                                    System.out.println("Reduce value class: " + value.getClass().getName());
                                }
                                first = false;
                            }
                            context.write((Object)new Text(key.toString()), (Object)((Writable)value));
                        }
                        break block19;
                    }
                    if (this.jmapcontext == null) break block19;
                    Object jcontext = this.jmapcontext.getConstructor(new Class[0]).newInstance(new Object[0]);
                    for (Object value : values) {
                        if (first) {
                            if (this.debug) {
                                System.out.println("Reduce value class: " + value.getClass().getName());
                            }
                            first = false;
                        }
                        this.jset.invoke(jcontext, "var1", value);
                        this.jeval.invoke(this.expression1, jcontext);
                    }
                    if (this.expression2 != null) {
                        this.jeval.invoke(this.expression2, jcontext);
                    }
                    if ((results = this.jget.invoke(jcontext, "r1")) == null) {
                        context.write((Object)new Text(key.toString()), (Object)NullWritable.get());
                        break block19;
                    }
                    MWWritableOutput adapter = null;
                    MWArrayWritable mwArray = null;
                    if (!context.getOutputValueClass().equals(MWArrayWritable.class)) {
                        adapter = new MWWritableOutput(context.getOutputValueClass());
                        adapter.setWritable(results instanceof Writable);
                    } else {
                        mwArray = new MWArrayWritable();
                    }
                    if (adapter != null) {
                        adapter.setInstance(results);
                        context.write((Object)new Text(key.toString()), (Object)adapter.getInstance());
                        break block19;
                    }
                    if (!results.getClass().isArray()) {
                        throw new IOException("The values is not an array as expected");
                    }
                    try {
                        mwArray.set(results);
                        context.write((Object)new Text(key.toString()), (Object)mwArray);
                    }
                    catch (Exception ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
                catch (Exception e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    context.getCounter((Enum)reduce.FAILED_CALLS).increment(1L);
                }
            }
        }
    }

    public static class MWBuiltinCombine
    extends MWBuiltinReduce {
        public MWBuiltinCombine() {
            this.isCombiner = true;
        }
    }

    public static class MWReduce
    extends Reducer<Object, Object, Object, Object> {
        private boolean debug = false;
        private String CTFFileName = null;
        private String reduceMethodName = null;
        private MWMCR fMCR = null;
        private String[] cachedFiles = null;
        private boolean appmode = false;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            try {
                Configuration conf = context.getConfiguration();
                this.debug = conf.get("jdebug") != null;
                boolean bl = this.appmode = conf.get("mw.mode") != null && conf.get("mw.mode").equals("application");
                if (this.debug) {
                    System.out.println("************* classpath in reducer ****************");
                    ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
                    URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
                    for (int i = 0; i < urls.length; ++i) {
                        System.out.println(urls[i].getFile());
                    }
                    System.out.println("******************************************");
                }
                this.CTFFileName = conf.get("HDFSCTFFileName");
                String redwrapper = context.getConfiguration().get("mw.reducewrapper");
                this.reduceMethodName = redwrapper == null || redwrapper.isEmpty() ? "matlab.compiler.mlhadoop.internal.reducewrapper" : redwrapper;
                if (this.CTFFileName != null) {
                    long startTimeMs = System.currentTimeMillis();
                    FileSystem fs = FileSystem.get((Configuration)conf);
                    File ctffile = new File(this.CTFFileName);
                    FSDataInputStream ctfis = fs.open(new Path(this.CTFFileName));
                    MWCtfStreamSource ctfsource = new MWCtfStreamSource((InputStream)ctfis);
                    MWComponentOptions sCtfFileCompOptions = new MWComponentOptions(MWCtfExtractLocation.EXTRACT_TO_CACHE, ctfsource);
                    this.fMCR = MWSharedMCRFactory.newInstance(sCtfFileCompOptions);
                    if (this.fMCR == null) {
                        throw new IOException("MCR initialization failed");
                    }
                    context.getCounter("Reduce MCR Creation", " Time spent (ms)").increment(System.currentTimeMillis() - startTimeMs);
                    context.getCounter("Reduce MCR Creation", "Calls").increment(1L);
                }
            }
            catch (Exception e) {
                StackTraceElement[] st = e.getStackTrace();
                String errorMsg = "";
                for (StackTraceElement el : st) {
                    errorMsg = errorMsg + el.toString() + "\n";
                    if (el.getMethodName().equals("setup") && el.getClassName().endsWith("MWReduce")) break;
                }
                throw new IOException(errorMsg);
            }
        }

        public void run(Reducer.Context context) throws IOException, InterruptedException {
            this.setup(context);
            long startTimeMs = System.currentTimeMillis();
            this.invokeReduce(context);
            context.getCounter("Reduce Invocation", "Time spent (ms)").increment(System.currentTimeMillis() - startTimeMs);
            context.getCounter("Reduce Invocation", "Calls").increment(1L);
            this.cleanup(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeReduce(Reducer.Context context) throws IOException, InterruptedException {
            try {
                Object[] results = null;
                MWReduceObject reduce2 = new MWReduceObject(context, this.cachedFiles);
                if (reduce2.getContext() == null) {
                    throw new IOException("Unable to get the reduce context object");
                }
                MWJavaObjectRef reduceRef = new MWJavaObjectRef(reduce2.getInterator());
                MWJavaObjectRef reduceCRef = new MWJavaObjectRef(reduce2.getContext());
                try {
                    Object[] args;
                    int numInputs = 2;
                    String reduceFcnFile = null;
                    if (this.appmode) {
                        Configuration conf = context.getConfiguration();
                        reduceFcnFile = MWMapReduceDriver.getApplicationMementoFileNameFromDistributedCache(conf);
                        args = new Object[]{reduceRef, reduceCRef, new MWCharArray(reduceFcnFile)};
                        numInputs = 3;
                    } else {
                        args = new Object[]{reduceRef, reduceCRef};
                    }
                    System.out.println(" ****** Using reduce function in CTF ******");
                    MWFunctionSignature sReduce_wrapperSignature = new MWFunctionSignature(0, false, this.reduceMethodName, numInputs, true);
                    results = new Object[]{};
                    this.fMCR.invoke(Arrays.asList(results), Arrays.asList(args), sReduce_wrapperSignature);
                }
                finally {
                    MWArray.disposeArray(reduceRef);
                    MWArray.disposeArray(reduceCRef);
                }
                if (this.debug) {
                    System.out.println("Done with reduce");
                }
            }
            catch (Exception e) {
                context.getCounter((Enum)reduce.FAILED_CALLS).increment(1L);
                StackTraceElement[] st = e.getStackTrace();
                String errorMsg = "";
                for (StackTraceElement el : st) {
                    errorMsg = errorMsg + el.toString() + "\n";
                    if (el.getMethodName().equals("reduce") && el.getClassName().endsWith("MWReduce")) break;
                }
                throw new IOException(errorMsg);
            }
        }
    }

    public static class MWMap
    extends Mapper<Object, Object, Object, Object> {
        private boolean debug = false;
        private String CTFFileName = null;
        private String mapMethodName = null;
        private MWMCR fMCR = null;
        private String[] cachedFiles = null;
        private boolean appmode = false;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                Configuration conf = context.getConfiguration();
                this.debug = conf.get("jdebug") != null;
                boolean bl = this.appmode = conf.get("mw.mode") != null && conf.get("mw.mode").equals("application");
                if (this.debug) {
                    System.out.println("************* classpath in reducer ****************");
                    ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
                    URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
                    for (int i = 0; i < urls.length; ++i) {
                        System.out.println(urls[i].getFile());
                    }
                    System.out.println("******************************************");
                }
                this.CTFFileName = conf.get("HDFSCTFFileName");
                String mapwrapper = conf.get("mw.mapwrapper");
                this.mapMethodName = mapwrapper == null || mapwrapper.isEmpty() ? "matlab.compiler.mlhadoop.internal.mapwrapper" : mapwrapper;
                if (this.CTFFileName != null) {
                    long startTimeMs = System.currentTimeMillis();
                    FileSystem fs = FileSystem.get((Configuration)conf);
                    File ctffile = new File(this.CTFFileName);
                    FSDataInputStream ctfis = fs.open(new Path(this.CTFFileName));
                    MWCtfStreamSource ctfsource = new MWCtfStreamSource((InputStream)ctfis);
                    MWComponentOptions sCtfFileCompOptions = new MWComponentOptions(MWCtfExtractLocation.EXTRACT_TO_CACHE, ctfsource);
                    this.fMCR = MWSharedMCRFactory.newInstance(sCtfFileCompOptions);
                    if (this.fMCR == null) {
                        throw new IOException("MCR initialization failed");
                    }
                    context.getCounter("Map MCR Creation", "Time spent (ms)").increment(System.currentTimeMillis() - startTimeMs);
                    context.getCounter("Map MCR Creation", "Calls").increment(1L);
                }
            }
            catch (Exception e) {
                StackTraceElement[] st = e.getStackTrace();
                String errorMsg = "";
                for (StackTraceElement el : st) {
                    errorMsg = errorMsg + el.toString() + "\n";
                    if (el.getMethodName().equals("setup") && el.getClassName().endsWith("MWMap")) break;
                }
                throw new IOException(errorMsg);
            }
        }

        public void run(Mapper.Context context) throws IOException, InterruptedException {
            this.setup(context);
            long startTimeMs = System.currentTimeMillis();
            this.invokeMap(context);
            context.getCounter("Map Invocation", "Time spent (ms)").increment(System.currentTimeMillis() - startTimeMs);
            context.getCounter("Map Invocation", "Calls").increment(1L);
            this.cleanup(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeMap(Mapper.Context context) throws IOException, InterruptedException {
            Object[] results = null;
            if (this.debug) {
                System.out.println(" ****** invokeMap ******");
            }
            try {
                Object[] args;
                long fileSize = 0L;
                InputSplit split = context.getInputSplit();
                if (split instanceof FileSplit) {
                    fileSize = FileSystem.get((Configuration)context.getConfiguration()).getFileStatus(((FileSplit)split).getPath()).getLen();
                }
                MWMapObject map2 = new MWMapObject(context, this.cachedFiles, fileSize);
                MWJavaObjectRef mapRef = new MWJavaObjectRef(map2.getData());
                MWJavaObjectRef mapCRef = new MWJavaObjectRef(map2.getContext());
                int numInputs = 2;
                String mapFcnFile = null;
                if (this.appmode) {
                    Configuration conf = context.getConfiguration();
                    mapFcnFile = MWMapReduceDriver.getApplicationMementoFileNameFromDistributedCache(conf);
                    args = new Object[]{mapRef, mapCRef, new MWCharArray(mapFcnFile)};
                    numInputs = 3;
                } else {
                    args = new Object[]{mapRef, mapCRef};
                }
                try {
                    System.out.println(" ****** Using map function in CTF ******");
                    MWFunctionSignature sMap_wrapperSignature = new MWFunctionSignature(0, false, this.mapMethodName, numInputs, true);
                    results = new Object[]{};
                    this.fMCR.invoke(Arrays.asList(results), Arrays.asList(args), sMap_wrapperSignature);
                }
                finally {
                    MWArray.disposeArray(mapRef);
                    MWArray.disposeArray(mapCRef);
                }
                if (this.debug) {
                    System.out.println("Done with invokeMap");
                }
            }
            catch (Exception e) {
                context.getCounter((Enum)map.FAILED_CALLS).increment(1L);
                StackTraceElement[] st = e.getStackTrace();
                String errorMsg = "";
                for (StackTraceElement el : st) {
                    errorMsg = errorMsg + el.toString() + "\n";
                    if (el.getMethodName().equals("map") && el.getClassName().endsWith("MWMap")) break;
                }
                throw new IOException(errorMsg);
            }
        }
    }

    public static class MWBuiltinMap
    extends Mapper<Object, Object, Object, Object> {
        private Object obj = null;
        private Method method = null;
        private boolean debug = false;
        private MapUtil mapUtil = null;
        private boolean first = true;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            String errorMsg = null;
            Object expression = null;
            Object jcontext = null;
            Method jeval = null;
            Method jset = null;
            Method jget = null;
            try {
                Configuration conf = context.getConfiguration();
                this.debug = conf.get("jdebug") != null;
                String expr = conf.get("mw.map.builtin.exp");
                if (expr != null) {
                    Class<?> jje = Class.forName("org.apache.commons.jexl2.JexlEngine");
                    Class<?> jmc = Class.forName("org.apache.commons.jexl2.MapContext");
                    Class<?> je = Class.forName("org.apache.commons.jexl2.Expression");
                    Class<?> jjc = Class.forName("org.apache.commons.jexl2.JexlContext");
                    Object jeobj = jje.getConstructor(new Class[0]).newInstance(new Object[0]);
                    jcontext = jmc.getConstructor(new Class[0]).newInstance(new Object[0]);
                    String regcls = conf.get("mw.map.builtin.registerclasses");
                    if (regcls != null) {
                        String[] cls;
                        HashMap funcs = new HashMap();
                        for (String cl : cls = regcls.split(";")) {
                            String[] pair = cl.split(",");
                            if (pair.length != 2) continue;
                            funcs.put(pair[0], Class.forName(pair[1]));
                            if (!this.debug) continue;
                            System.out.println("Register name: " + pair[0] + " with " + pair[1]);
                        }
                        Method setfuns = jje.getMethod("setFunctions", Map.class);
                        setfuns.invoke(jeobj, funcs);
                    }
                    Method cemethod = jje.getMethod("createExpression", String.class);
                    expression = cemethod.invoke(jeobj, expr);
                    jeval = je.getMethod("evaluate", jjc);
                    jset = jmc.getMethod("set", String.class, Object.class);
                    jget = jmc.getMethod("get", String.class);
                }
                this.mapUtil = new MapUtil(conf, expression, jcontext, jeval, jset, jget, this.debug);
            }
            catch (Exception e) {
                StackTraceElement[] st;
                for (StackTraceElement el : st = e.getStackTrace()) {
                    errorMsg = errorMsg + el.toString() + "\n";
                    if (el.getMethodName().equals("setup") && el.getClassName().endsWith("MWBuiltinMap")) break;
                }
            }
            if (errorMsg != null) {
                throw new IOException(errorMsg);
            }
        }

        public void map(Object key, Object value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.mapUtil != null) {
                if (this.first) {
                    this.first = false;
                    if (this.debug) {
                        System.out.println("Map key class: " + key.getClass().getName());
                        System.out.println("Map value class: " + value.getClass().getName());
                    }
                }
                this.mapUtil.getKeyValues(key, value, context);
            }
        }
    }

    public static class MWDebugReduce
    extends Reducer<Object, Object, Object, Object> {
        private boolean taskFailed = false;

        public void run(Reducer.Context context) throws IOException, InterruptedException {
            if (MWDebugMap.taskFailed || this.taskFailed) {
                return;
            }
            try {
                this.setup(context);
                this.invokeReduce(context);
                this.cleanup(context);
            }
            catch (Exception e) {
                StackTraceElement[] st;
                this.taskFailed = true;
                System.out.println(e.getMessage());
                System.out.println("Exception:");
                for (StackTraceElement el : st = e.getStackTrace()) {
                    System.out.println("\tat " + el.toString());
                }
            }
        }

        public void invokeReduce(Reducer.Context context) throws IOException, InterruptedException {
            MVM mvm = MvmContext.get();
            MWReduceObject reduce2 = new MWReduceObject(context, null);
            if (reduce2.getContext() == null) {
                throw new IOException("Unable to get the reduce context object");
            }
            String redwrapper = context.getConfiguration().get("mw.reducewrapper");
            String redMethodName = null;
            redMethodName = redwrapper == null || redwrapper.isEmpty() ? "matlab.compiler.mlhadoop.internal.reducewrapper" : redwrapper;
            MatlabFevalRequest request = new MatlabFevalRequest(redMethodName, Integer.valueOf(0), new Object[]{reduce2.getInterator(), reduce2.getContext()});
            FutureFevalResult res = mvm.getExecutor().submit(request);
            try {
                res.get();
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
            catch (MvmExecutionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public static class MWDebugMap
    extends Mapper<Object, Object, Object, Object> {
        private String mapfun = null;
        public static boolean taskFailed = false;

        public void run(Mapper.Context context) throws IOException, InterruptedException {
            if (taskFailed) {
                return;
            }
            try {
                this.setup(context);
                this.invokeMap(context);
                this.cleanup(context);
            }
            catch (Exception e) {
                StackTraceElement[] st;
                taskFailed = true;
                System.out.println(e.getMessage());
                System.out.println("Exception:");
                for (StackTraceElement el : st = e.getStackTrace()) {
                    System.out.println("\tat " + el.toString());
                }
            }
        }

        public void invokeMap(Mapper.Context context) throws IOException, InterruptedException {
            long fileSize = 0L;
            InputSplit split = context.getInputSplit();
            if (split instanceof FileSplit) {
                fileSize = FileSystem.get((Configuration)context.getConfiguration()).getFileStatus(((FileSplit)split).getPath()).getLen();
            }
            MWMapObject map2 = new MWMapObject(context, null, fileSize);
            MVM mvm = MvmContext.get();
            String mapwrapper = context.getConfiguration().get("mw.mapwrapper");
            String mapMethodName = null;
            mapMethodName = mapwrapper == null || mapwrapper.isEmpty() ? "matlab.compiler.mlhadoop.internal.mapwrapper" : mapwrapper;
            MatlabFevalRequest request = new MatlabFevalRequest(mapMethodName, Integer.valueOf(0), new Object[]{map2.getData(), map2.getContext()});
            FutureFevalResult res = mvm.getExecutor().submit(request);
            try {
                res.get();
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
            catch (MvmExecutionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    static enum reduce {
        FAILED_CALLS;

    }

    public static enum map {
        FAILED_CALLS;

    }
}

