/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.NativeJava;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.net.URL;
import sun.awt.image.ByteArrayImageSource;

public class ResLoader {
    private Class fOwnerClass;
    private Component fOwner;
    private MediaTracker fTracker;
    private int fNewID;

    public ResLoader(Component component) {
        this.fOwner = component;
        this.fOwnerClass = component != null ? this.fOwner.getClass() : Component.class;
        this.fNewID = 0;
        this.fTracker = null;
    }

    public ResLoader(Class clazz) {
        this.fOwner = null;
        this.fOwnerClass = clazz != null ? clazz : Object.class;
        this.fNewID = 0;
        this.fTracker = null;
    }

    public Image loadImage(String string) {
        Image image = null;
        try {
            URL uRL = this.fOwnerClass.getResource(string);
            if (uRL != null) {
                image = this.loadImage(uRL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public Image loadImage(URL uRL) {
        Image image = null;
        boolean bl = false;
        if (uRL != null) {
            try {
                byte[] byArray;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                ImageProducer imageProducer = (ImageProducer)uRL.getContent();
                if (imageProducer instanceof ByteArrayImageSource && (byArray = NativeJava.getImageData(imageProducer)) != null) {
                    if (byArray.length == 1 && byArray[0] == -1) {
                        bl = true;
                    } else {
                        imageProducer = new BypassImageFetcherSource(byArray);
                    }
                }
                if (bl) {
                    image = toolkit.createImage(imageProducer);
                    this.addImage(image);
                    if (imageProducer instanceof BypassImageFetcherSource) {
                        toolkit.prepareImage(image, -1, -1, (ImageObserver)((Object)imageProducer));
                    }
                } else {
                    image = Toolkit.getDefaultToolkit().getImage(uRL);
                }
            }
            catch (Exception exception) {
                image = Toolkit.getDefaultToolkit().getImage(uRL);
            }
        }
        return image;
    }

    public Image loadImage(ImageProducer imageProducer) {
        Image image = null;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            image = toolkit.createImage(imageProducer);
            this.addImage(image);
            toolkit.prepareImage(image, -1, -1, (ImageObserver)((Object)imageProducer));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public void addImage(Image image) {
        if (this.fOwner != null) {
            if (this.fTracker == null) {
                this.fNewID = 0;
                this.fTracker = new MediaTracker(this.fOwner);
            }
            this.fTracker.addImage(image, this.fNewID++);
        }
    }

    public void waitForPendingImages() {
        if (this.fTracker != null) {
            try {
                this.fTracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fTracker = null;
        }
    }

    private class BypassImageFetcherSource
    extends ByteArrayImageSource
    implements ImageObserver {
        public BypassImageFetcherSource(byte[] byArray) {
            super(byArray);
        }

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return true;
        }

        @Override
        public void startProduction(ImageConsumer imageConsumer) {
            this.addConsumer(imageConsumer);
            this.doFetch();
        }
    }
}

