/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawCCITTFax;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;

public class ImageLoaderFactoryRawCCITTFax
extends AbstractImageLoaderFactory {
    private transient Log log = LogFactory.getLog(ImageLoaderFactoryRawCCITTFax.class);
    private static final String[] MIMES = new String[]{"image/tiff"};
    private static final ImageFlavor[][] FLAVORS = new ImageFlavor[][]{{ImageFlavor.RAW_CCITTFAX}};

    public static String getMimeForRawFlavor(ImageFlavor imageFlavor) {
        int n = FLAVORS.length;
        for (int i = 0; i < n; ++i) {
            int n2 = FLAVORS[i].length;
            for (int j = 0; j < n2; ++j) {
                if (!FLAVORS[i][j].equals(imageFlavor)) continue;
                return MIMES[i];
            }
        }
        throw new IllegalArgumentException("ImageFlavor is not a \"raw\" flavor: " + imageFlavor);
    }

    public String[] getSupportedMIMETypes() {
        return MIMES;
    }

    public ImageFlavor[] getSupportedFlavors(String string) {
        int n = MIMES.length;
        for (int i = 0; i < n; ++i) {
            if (!MIMES[i].equals(string)) continue;
            return FLAVORS[i];
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + string);
    }

    public ImageLoader newImageLoader(ImageFlavor imageFlavor) {
        if (imageFlavor.equals(ImageFlavor.RAW_CCITTFAX)) {
            return new ImageLoaderRawCCITTFax();
        }
        throw new IllegalArgumentException("Unsupported image flavor: " + imageFlavor);
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isSupported(ImageInfo imageInfo) {
        Boolean bl = (Boolean)imageInfo.getCustomObjects().get("TIFF_TILED");
        if (Boolean.TRUE.equals(bl)) {
            this.log.trace((Object)"Raw CCITT loading not supported for tiled TIFF image");
            return false;
        }
        Integer n = (Integer)imageInfo.getCustomObjects().get("TIFF_COMPRESSION");
        if (n == null) {
            return false;
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                boolean bl2;
                Integer n2 = (Integer)imageInfo.getCustomObjects().get("TIFF_STRIP_COUNT");
                boolean bl3 = bl2 = n2 != null && n2 == 1;
                if (!bl2) {
                    this.log.trace((Object)"Raw CCITT loading not supported for multi-strip TIFF image");
                }
                return bl2;
            }
        }
        return false;
    }
}

