/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.io.InputStream;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;

public class ImageRawPNG
extends ImageRawStream {
    private ColorModel cm;
    private ICC_Profile iccProfile;
    private int bitDepth;
    private boolean isTransparent;
    private int grayTransparentAlpha;
    private int redTransparentAlpha;
    private int greenTransparentAlpha;
    private int blueTransparentAlpha;

    public ImageRawPNG(ImageInfo imageInfo, InputStream inputStream, ColorModel colorModel, int n, ICC_Profile iCC_Profile) {
        super(imageInfo, ImageFlavor.RAW_PNG, inputStream);
        this.iccProfile = iCC_Profile;
        this.cm = colorModel;
        this.bitDepth = n;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public ICC_Profile getICCProfile() {
        return this.iccProfile;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public ColorSpace getColorSpace() {
        return this.cm.getColorSpace();
    }

    protected void setGrayTransparentAlpha(int n) {
        this.isTransparent = true;
        this.grayTransparentAlpha = n;
    }

    protected void setRGBTransparentAlpha(int n, int n2, int n3) {
        this.isTransparent = true;
        this.redTransparentAlpha = n;
        this.greenTransparentAlpha = n2;
        this.blueTransparentAlpha = n3;
    }

    protected void setTransparent() {
        this.isTransparent = true;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public Color getTransparentColor() {
        Color color = null;
        if (!this.isTransparent) {
            return color;
        }
        color = this.cm.getNumColorComponents() == 3 ? new Color(this.redTransparentAlpha, this.greenTransparentAlpha, this.blueTransparentAlpha) : new Color(this.grayTransparentAlpha, 0, 0);
        return color;
    }
}

