/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.pipeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.cache.ImageCache;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.spi.ImageConverter;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;
import org.apache.xmlgraphics.image.loader.util.Penalty;

public class ImageProviderPipeline {
    protected static Log log = LogFactory.getLog(ImageProviderPipeline.class);
    private ImageCache cache;
    private ImageLoader loader;
    private List converters = new ArrayList();

    public ImageProviderPipeline(ImageCache imageCache, ImageLoader imageLoader) {
        this.cache = imageCache;
        this.setImageLoader(imageLoader);
    }

    public ImageProviderPipeline(ImageLoader imageLoader) {
        this(null, imageLoader);
    }

    public ImageProviderPipeline() {
        this(null, null);
    }

    public Image execute(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        return this.execute(imageInfo, null, map, imageSessionContext);
    }

    public Image execute(ImageInfo imageInfo, Image image, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        int n;
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        long l = System.currentTimeMillis();
        Image image2 = null;
        Image image3 = null;
        int n2 = this.converters.size();
        int n3 = 0;
        if (this.cache != null) {
            for (n = n2 - 1; n >= 0; --n) {
                ImageConverter imageConverter = this.getConverter(n);
                ImageFlavor imageFlavor = imageConverter.getTargetFlavor();
                image2 = this.cache.getImage(imageInfo, imageFlavor);
                if (image2 == null) continue;
                n3 = n + 1;
                break;
            }
            if (image2 == null && this.loader != null) {
                ImageFlavor imageFlavor = this.loader.getTargetFlavor();
                image2 = this.cache.getImage(imageInfo, imageFlavor);
            }
        }
        if (image2 == null && image != null) {
            image2 = image;
        }
        n = 1;
        if (image2 == null && this.loader != null) {
            image2 = this.loader.loadImage(imageInfo, map, imageSessionContext);
            if (log.isTraceEnabled()) {
                long l2 = System.currentTimeMillis() - l;
                log.trace((Object)("Image loading using " + this.loader + " took " + l2 + " ms."));
            }
            n = 0;
            if (image2.isCacheable()) {
                image3 = image2;
            }
        }
        if (image2 == null) {
            throw new ImageException("Pipeline fails. No ImageLoader and no original Image available.");
        }
        if (n2 > 0) {
            for (int i = n3; i < n2; ++i) {
                ImageConverter imageConverter = this.getConverter(i);
                l = System.currentTimeMillis();
                image2 = imageConverter.convert(image2, map);
                if (log.isTraceEnabled()) {
                    long l3 = System.currentTimeMillis() - l;
                    log.trace((Object)("Image conversion using " + imageConverter + " took " + l3 + " ms."));
                }
                n = 0;
                if (!image2.isCacheable()) continue;
                image3 = image2;
            }
        }
        if (this.cache != null && n == 0) {
            if (image3 == null) {
                image3 = this.forceCaching(image2);
            }
            if (image3 != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Caching image: " + image3));
                }
                this.cache.putImage(image3);
            }
        }
        return image2;
    }

    private ImageConverter getConverter(int n) {
        return (ImageConverter)this.converters.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image forceCaching(Image image) throws IOException {
        if (image instanceof ImageRawStream) {
            ImageRawStream imageRawStream = (ImageRawStream)image;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Image is made cacheable: " + image.getInfo()));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = imageRawStream.createInputStream();
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            imageRawStream.setInputStreamFactory(new ImageRawStream.ByteArrayStreamFactory(byArray));
            return imageRawStream;
        }
        return null;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.loader = imageLoader;
    }

    public void addConverter(ImageConverter imageConverter) {
        this.converters.add(imageConverter);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Loader: ").append(this.loader);
        if (this.converters.size() > 0) {
            stringBuffer.append(" Converters: ");
            stringBuffer.append(this.converters);
        }
        return stringBuffer.toString();
    }

    public int getConversionPenalty() {
        return this.getConversionPenalty(null).getValue();
    }

    public Penalty getConversionPenalty(ImageImplRegistry imageImplRegistry) {
        Penalty penalty = Penalty.ZERO_PENALTY;
        if (this.loader != null) {
            penalty = penalty.add(this.loader.getUsagePenalty());
            if (imageImplRegistry != null) {
                penalty = penalty.add(imageImplRegistry.getAdditionalPenalty(this.loader.getClass().getName()));
            }
        }
        for (ImageConverter imageConverter : this.converters) {
            penalty = penalty.add(imageConverter.getConversionPenalty());
            if (imageImplRegistry == null) continue;
            penalty = penalty.add(imageImplRegistry.getAdditionalPenalty(imageConverter.getClass().getName()));
        }
        return penalty;
    }

    public ImageFlavor getTargetFlavor() {
        if (this.converters.size() > 0) {
            return this.getConverter(this.converters.size() - 1).getTargetFlavor();
        }
        if (this.loader != null) {
            return this.loader.getTargetFlavor();
        }
        return null;
    }
}

