/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color.profile;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class ColorProfileUtil {
    private ColorProfileUtil() {
    }

    public static String getICCProfileDescription(ICC_Profile iCC_Profile) {
        byte[] byArray = iCC_Profile.getData(1684370275);
        if (byArray == null) {
            return null;
        }
        int n = byArray[8] << 24 | byArray[9] << 16 | byArray[10] << 8 | byArray[11];
        --n;
        try {
            return new String(byArray, 12, n, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException("Incompatible VM");
        }
    }

    public static boolean isDefaultsRGB(ICC_Profile iCC_Profile) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ICC_Profile iCC_Profile2 = null;
        if (colorSpace instanceof ICC_ColorSpace) {
            iCC_Profile2 = ((ICC_ColorSpace)colorSpace).getProfile();
        }
        return iCC_Profile == iCC_Profile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(byte[] byArray) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(int n) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(InputStream inputStream) throws IOException {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(String string) throws IOException {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(string);
        }
    }
}

