/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color.profile;

import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorSpaces;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.apache.xmlgraphics.java2d.color.profile.NamedColorProfile;

public class NamedColorProfileParser {
    private static final int MLUC = 1835824483;
    private static final int NCL2 = 1852009522;

    public static boolean isNamedColorProfile(ICC_Profile iCC_Profile) {
        return iCC_Profile.getProfileClass() == 6;
    }

    public NamedColorProfile parseProfile(ICC_Profile iCC_Profile, String string, String string2) throws IOException {
        if (!NamedColorProfileParser.isNamedColorProfile(iCC_Profile)) {
            throw new IllegalArgumentException("Given profile is not a named color profile (NCP)");
        }
        String string3 = this.getProfileDescription(iCC_Profile);
        String string4 = this.getCopyright(iCC_Profile);
        RenderingIntent renderingIntent = this.getRenderingIntent(iCC_Profile);
        NamedColorSpace[] namedColorSpaceArray = this.readNamedColors(iCC_Profile, string, string2);
        return new NamedColorProfile(string3, string4, namedColorSpaceArray, renderingIntent);
    }

    public NamedColorProfile parseProfile(ICC_Profile iCC_Profile) throws IOException {
        return this.parseProfile(iCC_Profile, null, null);
    }

    private String getProfileDescription(ICC_Profile iCC_Profile) throws IOException {
        byte[] byArray = iCC_Profile.getData(1684370275);
        return this.readSimpleString(byArray);
    }

    private String getCopyright(ICC_Profile iCC_Profile) throws IOException {
        byte[] byArray = iCC_Profile.getData(1668313716);
        return this.readSimpleString(byArray);
    }

    private RenderingIntent getRenderingIntent(ICC_Profile iCC_Profile) throws IOException {
        byte[] byArray = iCC_Profile.getData(1751474532);
        byte by = byArray[64];
        return RenderingIntent.fromICCValue(by);
    }

    private NamedColorSpace[] readNamedColors(ICC_Profile iCC_Profile, String string, String string2) throws IOException {
        byte[] byArray = iCC_Profile.getData(1852009522);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        int n = dataInputStream.readInt();
        if (n != 1852009522) {
            throw new UnsupportedOperationException("Unsupported structure type: " + this.toSignatureString(n) + ". Expected " + this.toSignatureString(1852009522));
        }
        dataInputStream.skipBytes(8);
        int n2 = dataInputStream.readInt();
        NamedColorSpace[] namedColorSpaceArray = new NamedColorSpace[n2];
        int n3 = dataInputStream.readInt();
        String string3 = this.readAscii(dataInputStream, 32);
        String string4 = this.readAscii(dataInputStream, 32);
        block4: for (int i = 0; i < n2; ++i) {
            String string5 = string3 + this.readAscii(dataInputStream, 32) + string4;
            int[] nArray = this.readUInt16Array(dataInputStream, 3);
            float[] fArray = new float[3];
            for (int j = 0; j < nArray.length; ++j) {
                fArray[j] = (float)nArray[j] / 32768.0f;
            }
            this.readUInt16Array(dataInputStream, n3);
            switch (iCC_Profile.getPCSType()) {
                case 0: {
                    namedColorSpaceArray[i] = new NamedColorSpace(string5, fArray, string, string2);
                    continue block4;
                }
                case 1: {
                    CIELabColorSpace cIELabColorSpace = ColorSpaces.getCIELabColorSpaceD50();
                    namedColorSpaceArray[i] = new NamedColorSpace(string5, cIELabColorSpace.toColor(fArray, 1.0f), string, string2);
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("PCS type is not supported: " + iCC_Profile.getPCSType());
                }
            }
        }
        return namedColorSpaceArray;
    }

    private int[] readUInt16Array(DataInput dataInput, int n) throws IOException {
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = dataInput.readUnsignedShort();
        }
        return nArray;
    }

    private String readAscii(DataInput dataInput, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        String string = new String(byArray, "US-ASCII");
        int n2 = string.indexOf(0);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    private String readSimpleString(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        int n = dataInputStream.readInt();
        if (n == 1835824483) {
            return this.readMLUC(dataInputStream);
        }
        return null;
    }

    private String readMLUC(DataInput dataInput) throws IOException {
        dataInput.skipBytes(16);
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = 28;
        dataInput.skipBytes(n2 - n3);
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return new String(byArray, "UTF-16BE");
    }

    private String toSignatureString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(n >> 24 & 0xFF));
        stringBuffer.append((char)(n >> 16 & 0xFF));
        stringBuffer.append((char)(n >> 8 & 0xFF));
        stringBuffer.append((char)(n & 0xFF));
        return stringBuffer.toString();
    }
}

