/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlgraphics.xmp.Metadata;
import org.xml.sax.SAXException;

public final class XMPSerializer {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private XMPSerializer() {
    }

    public static void writeXML(Metadata metadata, Result result) throws TransformerConfigurationException, SAXException {
        XMPSerializer.writeXML(metadata, result, false, false);
    }

    public static void writeXMPPacket(Metadata metadata, OutputStream outputStream, boolean bl) throws TransformerConfigurationException, SAXException {
        StreamResult streamResult = new StreamResult(outputStream);
        XMPSerializer.writeXML(metadata, streamResult, true, bl);
    }

    private static void writeXML(Metadata metadata, Result result, boolean bl, boolean bl2) throws TransformerConfigurationException, SAXException {
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
        Transformer transformer = transformerHandler.getTransformer();
        if (bl) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
        try {
            transformer.setOutputProperty("indent", "yes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        transformerHandler.setResult(result);
        transformerHandler.startDocument();
        if (bl) {
            transformerHandler.processingInstruction("xpacket", "begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"");
        }
        metadata.toSAX(transformerHandler);
        if (bl) {
            if (bl2) {
                transformerHandler.processingInstruction("xpacket", "end=\"r\"");
            } else {
                StringBuffer stringBuffer = new StringBuffer(101);
                stringBuffer.append('\n');
                for (int i = 0; i < 100; ++i) {
                    stringBuffer.append(" ");
                }
                char[] cArray = stringBuffer.toString().toCharArray();
                for (int i = 0; i < 40; ++i) {
                    transformerHandler.characters(cArray, 0, cArray.length);
                }
                transformerHandler.characters(new char[]{'\n'}, 0, 1);
                transformerHandler.processingInstruction("xpacket", "end=\"w\"");
            }
        }
        transformerHandler.endDocument();
    }
}

