/*
 * Decompiled with CFR 0.152.
 */
package ice.cert;

import java.io.Serializable;

class OID
implements Serializable {
    static final long serialVersionUID = -8846991373943335195L;
    public static final int UNKNOWN = 0;
    public static final int PBE_WITH_MD2_AND_DES_CBC = 1;
    public static final int PBE_WITH_MD5_AND_DES_CBC = 3;
    public static final int PBE_WITH_MD2_AND_RC2_CBC = 4;
    public static final int PBE_WITH_MD5_AND_RC2_CBC = 6;
    public static final int PBE_WITH_SHA1_AND_DES_CBC = 10;
    public static final int PBE_WITH_SHA1_AND_RC2_CBC = 11;
    public static final int MD2_WITH_RSA_ENCRYPTION = 11;
    public static final int MD5_WITH_RSA_ENCRYPTION = 12;
    public static final int SHA1_WITH_RSA_ENCRYPTION = 13;
    public static final int ID_DSA_WITH_SHA1 = 14;
    public static final int RSA_ENCRYPTION = 21;
    public static final int ID_DSA = 22;
    public static final int DH_PUBLIC_NUMBER = 23;
    public static final int E = 51;
    public static final int CN = 52;
    public static final int SN = 53;
    public static final int C = 54;
    public static final int L = 55;
    public static final int S = 56;
    public static final int O = 57;
    public static final int OU = 58;
    public static final int T = 59;
    public static final int N = 60;
    public static final int GN = 61;
    public static final int I = 62;
    public static final int GQ = 63;
    public static final int DN = 64;
    public static final int NETSCAPE_DATA_TYPE = 91;
    public static final int NETSCAPE_CERT_SEQUENCE = 92;
    public static final int PKCS7_DATA = 101;
    public static final int PKCS7_SIGNED_DATA = 102;
    public static final int X509_SUBJECT_KEY_ID_EXT = 14;
    public static final int X509_USAGE_EXT = 15;
    public static final int X509_PRIV_USAGE_PERIOD_EXT = 16;
    public static final int X509_SUBJECT_ALT_NAME_EXT = 17;
    public static final int X509_ISSUER_ALT_NAME_EXT = 18;
    public static final int X509_BASIC_CONSTRAINTS_EXT = 19;
    public static final int X509_NAME_CONSTRAINTS_EXT = 30;
    public static final int X509_CRL_DIST_POINTS_EXT = 31;
    public static final int X509_PRIVATE_USAGE_EXT = 32;
    public static final int X509_POLICY_MAPPINGS_EXT = 33;
    public static final int X509_OBJECT_ID_EXT = 35;
    public static final int X509_POLICY_CONSTRAINTS_EXT = 36;
    public static final int X509_EXT_KEY_USAGE_EXT = 37;
    public String oidString;
    public String oidName;
    public int oidID;

    OID() {
    }

    public static OID parse(int[] nArray) {
        OID oID = new OID();
        int n = nArray.length;
        oID.oidString = "" + nArray[0];
        int n2 = 1;
        while (n2 < n) {
            oID.oidString = oID.oidString + "." + nArray[n2];
            ++n2;
        }
        if (n > 2 && nArray[0] == 1 && nArray[1] == 2 && nArray[2] == 840) {
            if (n > 5 && nArray[3] == 113549 && nArray[4] == 1 && nArray[5] == 9) {
                if (n > 6 && nArray[6] == 1) {
                    oID.oidName = "E";
                    oID.oidID = 51;
                    return oID;
                }
            } else if (n > 5 && nArray[3] == 113549 && nArray[4] == 1 && nArray[5] == 1) {
                if (n > 6 && nArray[6] == 1) {
                    oID.oidName = "RSA";
                    oID.oidID = 21;
                    return oID;
                }
                if (n > 6 && nArray[6] == 2) {
                    oID.oidName = "MD2/RSA";
                    oID.oidID = 11;
                    return oID;
                }
                if (n > 6 && nArray[6] == 4) {
                    oID.oidName = "MD5/RSA";
                    oID.oidID = 12;
                    return oID;
                }
                if (n > 6 && nArray[6] == 5) {
                    oID.oidName = "SHA-1/RSA/PKCS#1";
                    oID.oidID = 13;
                    return oID;
                }
            } else if (n > 5 && nArray[3] == 113549 && nArray[4] == 1 && nArray[5] == 5) {
                if (n > 6 && nArray[6] == 1) {
                    oID.oidName = "MD2/DES";
                    oID.oidID = 1;
                    return oID;
                }
                if (n > 6 && nArray[6] == 3) {
                    oID.oidName = "MD5/DES";
                    oID.oidID = 3;
                    return oID;
                }
                if (n > 6 && nArray[6] == 4) {
                    oID.oidName = "MD2/RC2";
                    oID.oidID = 4;
                    return oID;
                }
                if (n > 6 && nArray[6] == 6) {
                    oID.oidName = "MD5/RC2";
                    oID.oidID = 6;
                    return oID;
                }
                if (n > 6 && nArray[6] == 10) {
                    oID.oidName = "SHA1/DES";
                    oID.oidID = 10;
                    return oID;
                }
                if (n > 6 && nArray[6] == 11) {
                    oID.oidName = "SHA1/RC2";
                    oID.oidID = 11;
                    return oID;
                }
            } else if (n > 5 && nArray[3] == 113549 && nArray[4] == 1 && nArray[5] == 7) {
                if (n > 6 && nArray[6] == 1) {
                    oID.oidName = "data";
                    oID.oidID = 101;
                    return oID;
                }
                if (n > 6 && nArray[6] == 2) {
                    oID.oidName = "signed data";
                    oID.oidID = 102;
                    return oID;
                }
            } else if (n > 4 && nArray[3] == 10040 && nArray[4] == 4) {
                if (n > 5 && nArray[5] == 1) {
                    oID.oidName = "DSA";
                    oID.oidID = 22;
                    return oID;
                }
                if (n > 5 && nArray[5] == 3) {
                    oID.oidName = "SHA/DSA";
                    oID.oidID = 14;
                    return oID;
                }
            } else if (n > 5 && nArray[3] == 10046 && nArray[4] == 2 && nArray[5] == 1) {
                oID.oidName = "DH";
                oID.oidID = 23;
                return oID;
            }
        } else if (n > 2 && nArray[0] == 2 && nArray[1] == 5 && nArray[2] == 4) {
            if (n > 3 && nArray[3] == 3) {
                oID.oidName = "CN";
                oID.oidID = 52;
                return oID;
            }
            if (n > 3 && nArray[3] == 4) {
                oID.oidName = "SN";
                oID.oidID = 53;
                return oID;
            }
            if (n > 3 && nArray[3] == 6) {
                oID.oidName = "C";
                oID.oidID = 54;
                return oID;
            }
            if (n > 3 && nArray[3] == 7) {
                oID.oidName = "L";
                oID.oidID = 55;
                return oID;
            }
            if (n > 3 && nArray[3] == 8) {
                oID.oidName = "S";
                oID.oidID = 56;
                return oID;
            }
            if (n > 3 && nArray[3] == 10) {
                oID.oidName = "O";
                oID.oidID = 57;
                return oID;
            }
            if (n > 3 && nArray[3] == 11) {
                oID.oidName = "OU";
                oID.oidID = 58;
                return oID;
            }
            if (n > 3 && nArray[3] == 12) {
                oID.oidName = "T";
                oID.oidID = 59;
                return oID;
            }
            if (n > 3 && nArray[3] == 41) {
                oID.oidName = "N";
                oID.oidID = 60;
                return oID;
            }
            if (n > 3 && nArray[3] == 42) {
                oID.oidName = "GN";
                oID.oidID = 61;
                return oID;
            }
            if (n > 3 && nArray[3] == 43) {
                oID.oidName = "I";
                oID.oidID = 62;
                return oID;
            }
            if (n > 3 && nArray[3] == 44) {
                oID.oidName = "GQ";
                oID.oidID = 63;
                return oID;
            }
            if (n > 3 && nArray[3] == 46) {
                oID.oidName = "DN";
                oID.oidID = 64;
                return oID;
            }
        } else if (n > 4 && nArray[0] == 2 && nArray[1] == 16 && nArray[2] == 840 && nArray[3] == 1 && nArray[4] == 113730) {
            if (n > 5 && nArray[5] == 2) {
                if (n == 6) {
                    oID.oidName = "netscape-data-type";
                    oID.oidID = 91;
                    return oID;
                }
                if (n > 6 && nArray[6] == 5) {
                    oID.oidName = "netscape-cert-sequence";
                    oID.oidID = 92;
                    return oID;
                }
            }
        } else if (n > 2 && nArray[0] == 2 && nArray[1] == 5 && nArray[2] == 29) {
            if (n > 3 && nArray[3] == 14) {
                oID.oidName = "X.509-subject-key-id-ext";
                oID.oidID = 14;
                return oID;
            }
            if (n > 3 && nArray[3] == 15) {
                oID.oidName = "X.509-usage-ext";
                oID.oidID = 15;
                return oID;
            }
            if (n > 3 && nArray[3] == 16) {
                oID.oidName = "X.509-priv-usage-period-ext";
                oID.oidID = 16;
                return oID;
            }
            if (n > 3 && nArray[3] == 17) {
                oID.oidName = "X.509-subject-alt-name-ext";
                oID.oidID = 17;
                return oID;
            }
            if (n > 3 && nArray[3] == 18) {
                oID.oidName = "X.509-issuer-alt-name-ext";
                oID.oidID = 18;
                return oID;
            }
            if (n > 3 && nArray[3] == 19) {
                oID.oidName = "X.509-basic-constrains-ext";
                oID.oidID = 19;
                return oID;
            }
            if (n > 3 && nArray[3] == 30) {
                oID.oidName = "X.509-name-constaints-ext";
                oID.oidID = 30;
                return oID;
            }
            if (n > 3 && nArray[3] == 31) {
                oID.oidName = "X.509-crl-dist-points-ext";
                oID.oidID = 31;
                return oID;
            }
            if (n > 3 && nArray[3] == 32) {
                oID.oidName = "X.509-private-usage-ext";
                oID.oidID = 32;
                return oID;
            }
            if (n > 3 && nArray[3] == 33) {
                oID.oidName = "X.509-policy-mapings-ext";
                oID.oidID = 33;
                return oID;
            }
            if (n > 3 && nArray[3] == 35) {
                oID.oidName = "X.509-object-id-ext";
                oID.oidID = 35;
                return oID;
            }
            if (n > 3 && nArray[3] == 36) {
                oID.oidName = "X.509-policy-constrains-ext";
                oID.oidID = 36;
                return oID;
            }
            if (n > 3 && nArray[3] == 37) {
                oID.oidName = "X.509-ext-key-usage-ext";
                oID.oidID = 37;
                return oID;
            }
        }
        oID.oidName = oID.oidString;
        oID.oidID = 0;
        return oID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof OID)) {
            return false;
        }
        return this.oidString.equals(((OID)object).oidString);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.oidName + " (" + this.oidString + ")]";
    }
}

