/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.util;

import com.mathworks.jmi.Support;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAutoShutdown;

public final class ShutdownHelpers {
    public static final long WINDOW_CLOSER_TIMEOUT_SEC = 10L;
    private static volatile Object sEvent = null;
    private static final long SAFETY_TIMEOUT = 1000L;
    private static final long AWT_TIMEOUT_MS = 1100L;
    public static final String[] EMPTY = new String[0];
    private static ResourceBundle sResources;
    private static volatile Window sWindowBeingDisposed;
    private static long sDisposeMillisStart;
    private static boolean sInJUnitTest;
    private static boolean sNoWindows;
    private static int sCount;

    private ShutdownHelpers() {
    }

    /*
     * WARNING - void declaration
     */
    private static String[] prepareForShutdown() {
        boolean bl;
        assert (!SwingUtilities.isEventDispatchThread());
        final CountDownLatch countDownLatch = new CountDownLatch(sNoWindows ? 0 : 1);
        final boolean bl2 = PlatformInfo.isMacintosh();
        StringWriter stringWriter = new StringWriter();
        final PrintWriter printWriter = new PrintWriter(stringWriter);
        if (!sNoWindows) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Window[] windowArray = Window.getWindows();
                    if (bl2 && !GraphicsEnvironment.isHeadless() && sCount == 0 && windowArray.length == 0) {
                        new Window(null).pack();
                        windowArray = Window.getWindows();
                    }
                    sCount++;
                    for (Window window : windowArray) {
                        try {
                            sWindowBeingDisposed = window;
                            sDisposeMillisStart = System.currentTimeMillis();
                            if (!window.isDisplayable()) continue;
                            window.dispose();
                        }
                        catch (Throwable throwable) {
                            ShutdownHelpers.getResources();
                            printWriter.print("\n" + MessageFormat.format(sResources.getString("unableToDispose"), window.getClass().getName()) + "\n  ");
                            throwable.printStackTrace(printWriter);
                        }
                        finally {
                            sWindowBeingDisposed = null;
                        }
                    }
                    printWriter.close();
                    if (bl2 && !GraphicsEnvironment.isHeadless() && !sInJUnitTest) {
                        NativeJava.disposeLingeringWindowsMac();
                    }
                    countDownLatch.countDown();
                }
            });
        }
        if (bl2 && !sInJUnitTest) {
            AWTAutoShutdown.notifyToolkitThreadFree();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = false;
        int n = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        String[] stringArray = new String[3];
        for (int i = 0; i < 3; ++i) {
            block38: {
                bl = false;
                for (int j = 0; j < 5; ++j) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (j == 0) {
                        try {
                            bl6 = !countDownLatch.await(9L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    bl3 = false;
                    n = -1;
                    bl4 = false;
                    arrayList.clear();
                    sEvent = null;
                    bl8 = false;
                    bl7 = false;
                    for (Map.Entry entry : Thread.getAllStackTraces().entrySet()) {
                        Thread exception = (Thread)entry.getKey();
                        Thread.State state = exception.getState();
                        String string = exception.getName();
                        if (exception == Thread.currentThread() || exception.isDaemon() || sInJUnitTest && string.equals("main") || state == Thread.State.TERMINATED || state == Thread.State.NEW) continue;
                        if (string.equals("RMI Reaper")) {
                            exception.interrupt();
                            continue;
                        }
                        StackTraceElement[] stackTraceElementArray = (StackTraceElement[])entry.getValue();
                        boolean bl9 = ShutdownHelpers.shouldReportThread(exception, stackTraceElementArray);
                        if (!bl9 && string.startsWith("AWT-EventQueue")) {
                            bl4 = true;
                            bl9 = true;
                        }
                        if (bl9) {
                            int n2 = arrayList.size();
                            String string2 = "\n   \"" + string + "\" prio=" + exception.getPriority() + " tid=" + exception.getId() + " state=" + (Object)((Object)exception.getState());
                            arrayList.add(string2);
                            if (string.contains("AWT-Shutdown")) {
                                void var27_52;
                                bl3 = true;
                                try {
                                    Method method = AWTAutoShutdown.class.getDeclaredMethod("isReadyToShutdown", new Class[0]);
                                    method.setAccessible(true);
                                    int n3 = ((Boolean)method.invoke((Object)AWTAutoShutdown.getInstance(), new Object[0])).booleanValue() ? 1 : 0;
                                    String string4 = n3 != 0 ? "ready to shut down" : "not ready to shut down";
                                    string4 = string4 + ", loop count = " + i + ", time = " + j;
                                }
                                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                                    String string5 = "Can't get isReadyToShutdown!!";
                                }
                                arrayList.set(n2, string2 + ", " + (String)var27_52);
                            } else if (string.contains("AWT-EventQueue")) {
                                n = n2;
                            } else {
                                bl8 = true;
                            }
                            for (StackTraceElement stackTraceElement : (StackTraceElement[])entry.getValue()) {
                                arrayList.add("      at " + stackTraceElement.toString());
                            }
                            continue;
                        }
                        bl = true;
                    }
                    if (arrayList.isEmpty()) {
                        if (bl) {
                            return EMPTY;
                        }
                        return null;
                    }
                    if (!bl8 && j > 2) break;
                }
                if (!bl3 || n < 0) break;
                final EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
                boolean bl10 = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        block5: {
                            if (cyclicBarrier.isBroken()) {
                                return;
                            }
                            try {
                                long l = System.currentTimeMillis();
                                long l2 = l + 1100L;
                                do {
                                    sEvent = eventQueue.peekEvent();
                                    if (sEvent != null) break;
                                    Thread.sleep(100L);
                                } while (System.currentTimeMillis() < l2);
                                cyclicBarrier.await();
                            }
                            catch (BrokenBarrierException brokenBarrierException) {
                            }
                            catch (InterruptedException interruptedException) {
                                if ($assertionsDisabled) break block5;
                                throw new AssertionError();
                            }
                        }
                    }
                });
                try {
                    cyclicBarrier.await(1375L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    if (sEvent == null && (sEvent = Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent()) == null) {
                        sEvent = "timeout";
                    }
                }
                catch (InterruptedException | BrokenBarrierException exception) {
                    if ($assertionsDisabled) break block38;
                    throw new AssertionError();
                }
            }
            if (sEvent == null || sWindowBeingDisposed != null) {
                Window[] windowArray;
                if (!stringWriter.toString().isEmpty()) {
                    arrayList.add(stringWriter.toString());
                }
                if ((windowArray = Window.getWindows()) == null || windowArray.length <= 0) break;
                ShutdownHelpers.getResources();
                arrayList.add("\n" + MessageFormat.format(sResources.getString("perhapsNotDisposed"), windowArray.length));
                bl7 = sWindowBeingDisposed != null;
                for (Window window : windowArray) {
                    String string = window instanceof Frame ? ((Frame)window).getTitle() : window.getName();
                    bl7 |= window.isDisplayable();
                    arrayList.add("   " + window.getClass().getName() + (string != null && !string.isEmpty() ? " \"" + string + "\" " : " " + sResources.getString("unnamed") + " ") + (window.isDisplayable() ? sResources.getString("displayable") : "") + (window == sWindowBeingDisposed ? " " + MessageFormat.format(sResources.getString("hungOnDispose"), System.currentTimeMillis() - sDisposeMillisStart) : ""));
                }
                break;
            }
            stringArray[i] = ShutdownHelpers.getEvent(sEvent);
        }
        if (n >= 0) {
            String string = (String)arrayList.get(n);
            if (bl6) {
                string = string + ", timed out closer!";
            }
            if (sEvent != null) {
                void var19_26;
                bl = false;
                String[] stringArray2 = stringArray;
                int n4 = stringArray2.length;
                boolean bl10 = false;
                while (var19_26 < n4) {
                    String string6 = stringArray2[var19_26];
                    if (string6 != null) {
                        string = string + "\n        Event = " + string6;
                    }
                    ++var19_26;
                }
            }
            if (!bl6 && stringArray.length == 0 && bl4 && !bl8 && !bl7) {
                return EMPTY;
            }
            arrayList.set(n, string);
        } else if (bl3 && !bl8 && !bl7) {
            return EMPTY;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String getEvent(Object object) {
        String string;
        if (object instanceof AWTEvent) {
            AWTEvent aWTEvent = (AWTEvent)object;
            string = aWTEvent.paramString();
            Object object2 = aWTEvent.getSource();
            if (aWTEvent instanceof InvocationEvent) {
                try {
                    Field field = InvocationEvent.class.getDeclaredField("runnable");
                    field.setAccessible(true);
                    Class<?> clazz = Class.forName("javax.swing.Timer$DoPostEvent");
                    Object object3 = field.get(aWTEvent);
                    if (clazz.isInstance(object3)) {
                        Method method = clazz.getDeclaredMethod("getTimer", new Class[0]);
                        method.setAccessible(true);
                        Timer timer = (Timer)method.invoke(object3, new Object[0]);
                        timer.stop();
                        ActionListener[] actionListenerArray = timer.getActionListeners();
                        string = string + "\n            ActionListener = " + actionListenerArray[0].getClass().getName();
                    }
                }
                catch (Throwable throwable) {
                    string = string + "; unknown " + aWTEvent.getClass().getName();
                }
            } else {
                string = object.toString() + "\n       (" + string + ")";
            }
        } else {
            string = object.toString();
            if (string.isEmpty()) {
                string = object.getClass().getName();
            }
        }
        return string;
    }

    private static void notifyShutdownProblem(final String string, final @Nullable String[] stringArray) {
        if (Support.useDesktop()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String[] stringArray2 = new String[stringArray != null ? stringArray.length : 1];
                        if (stringArray != null) {
                            int n = 0;
                            for (String string2 : stringArray) {
                                stringArray2[n++] = "    " + string2;
                            }
                        } else {
                            stringArray2[0] = string;
                        }
                        ShutdownHelpers.getResources();
                        ShutdownHelpers.displayExitProblemDialog(new Object[]{stringArray != null ? sResources.getString("couldNotShutDownThreadsRunning") : sResources.getString("cantExitFromNativeMethod"), stringArray2, sResources.getString("matlabWillForceExit")});
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void displayExitProblemDialog(Object[] objectArray) {
        ShutdownHelpers.getResources();
        MJOptionPane mJOptionPane = new MJOptionPane((Object)objectArray, 0, -1, null, null, null);
        final JDialog jDialog = mJOptionPane.createDialog(null, sResources.getString("matlabShutdownProblem"));
        Timer timer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        timer.setRepeats(false);
        timer.start();
        jDialog.setVisible(true);
        timer.stop();
    }

    private static void getResources() {
        sResources = ResourceBundle.getBundle("com.mathworks.jmi.resources.RES_JMI");
    }

    public static String[] testPrepareForShutdown(boolean bl) {
        sInJUnitTest = true;
        sNoWindows = bl;
        sEvent = null;
        sWindowBeingDisposed = null;
        return ShutdownHelpers.prepareForShutdown();
    }

    private static boolean shouldReportThread(Thread thread, StackTraceElement[] stackTraceElementArray) {
        String string = thread.getName();
        if (PlatformInfo.isWindows() && !PlatformInfo.is64Bit() && string.equals("XPCOMThread") && stackTraceElementArray.length == 0) {
            return false;
        }
        if (string.startsWith("AWT-EventQueue") || stackTraceElementArray.length > 3 && stackTraceElementArray[stackTraceElementArray.length - 2].getClassName().equals("java.util.concurrent.ThreadPoolExecutor$Worker") && Pattern.matches("\\Apool-\\d+-thread-\\d+\\z", string)) {
            if (!stackTraceElementArray[1].getClassName().equals("java.util.concurrent.locks.LockSupport")) {
                return true;
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!stackTraceElement.getClassName().startsWith("com.") || stackTraceElement.getClassName().startsWith("com.mathworks.jmi.util.unittest")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        sWindowBeingDisposed = null;
        sInJUnitTest = false;
        sNoWindows = false;
        sCount = 0;
    }

    private static class ShutdownEventTester
    implements Runnable {
        private ShutdownEventTester() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

