/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CharacterAttributes;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ScreenReaderStatusComponent;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.swing.AccessibleLinkIndex;
import ice.pilots.html4.swing.DocView;
import ice.util.encoding.CharIO;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class AccessibleHypertextPanel
extends AccessibleContext
implements AccessibleHypertext,
EventListener {
    protected DocView docView;
    protected ThePilot htmlPilot;
    protected AccessibleContext defaultContext;
    protected Html4DocumentAccess accessProvider;
    protected AccessibleLinkIndex linkIndex;
    protected ScreenReaderStatusComponent status;
    public static final int NONE = 0;
    public static final int NEXT = 1;
    public static final int PREVIOUS = 2;

    public AccessibleHypertextPanel(DocView docView, AccessibleContext accessibleContext) {
        this.docView = docView;
        this.defaultContext = accessibleContext;
        this.init();
    }

    protected AccessibleContext getAccessibleContext() {
        return this.defaultContext;
    }

    private void init() {
        this.htmlPilot = this.docView.getPilot();
        this.accessProvider = new Html4DocumentAccess(this.htmlPilot);
        this.htmlPilot.addPersistentDOMEventListener("load", (EventListener)this, true);
        this.htmlPilot.addPersistentDOMEventListener("unload", (EventListener)this, true);
        this.htmlPilot.addPersistentDOMEventListener("keyup", (EventListener)this, true);
        this.htmlPilot.addPersistentDOMEventListener("focus", (EventListener)this, true);
        this.htmlPilot.addPersistentDOMEventListener("goto", (EventListener)this, true);
        this.BORDER_BOTTOM_WIDTH(null);
        DDocument dDocument = this.htmlPilot.getDDocument();
        this.setAccessibleName(dDocument.getTitle());
        this.setAccessibleDescription(dDocument.getTitle());
        this.setAccessibleParent(this.defaultContext.getAccessibleParent());
    }

    public AccessibleText getAccessibleText() {
        return this;
    }

    public AccessibleComponent getAccessibleComponent() {
        return this.defaultContext.getAccessibleComponent();
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.TEXT;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        return this.defaultContext.getAccessibleStateSet();
    }

    public int getAccessibleIndexInParent() {
        return -1;
    }

    public int getAccessibleChildrenCount() {
        return this.defaultContext.getAccessibleChildrenCount();
    }

    public Accessible getAccessibleChild(int n) {
        return this.defaultContext.getAccessibleChild(n);
    }

    public Locale getLocale() throws IllegalComponentStateException {
        Locale locale = null;
        String string = this.htmlPilot.getEncoding();
        if (string != null) {
            locale = CharIO.getEncodingLocale((String)string);
        }
        if (locale == null) {
            this.defaultContext.getLocale();
        }
        if (locale == null) {
            locale = this.docView.docPanel.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public int getLinkCount() {
        return this.linkIndex.getLinkCount();
    }

    public AccessibleHyperlink getLink(int n) {
        return this.linkIndex.getLink(n, this.docView);
    }

    public int getLinkIndex(int n) {
        if (this.BORDER_BOTTOM(n)) {
            return -1;
        }
        DNode dNode = this.accessProvider.getNodeByIndex(1, n);
        if (dNode == null) {
            return -1;
        }
        if (dNode instanceof DAnchorElement) {
            return this.linkIndex.getIndexFromNode((DAnchorElement)dNode);
        }
        DNode dNode2 = dNode.getParentDNode();
        if (dNode2 instanceof DAnchorElement) {
            return this.linkIndex.getIndexFromNode((DAnchorElement)dNode2);
        }
        return -1;
    }

    public int getIndexAtPoint(Point point) {
        if (point == null) {
            return -1;
        }
        return this.accessProvider.getIndexAtPoint(point.x, point.y, this.docView.getScrollX(), this.docView.getScrollY());
    }

    public Rectangle getCharacterBounds(int n) {
        return new Rectangle();
    }

    public int getCharCount() {
        return this.accessProvider.getCount(1);
    }

    public int getCaretPosition() {
        return this.accessProvider.getCaretPosition(1);
    }

    public String getAtIndex(int n, int n2) {
        return this.B(n, n2, 0);
    }

    public String getAfterIndex(int n, int n2) {
        return this.B(n, n2, 1);
    }

    public String getBeforeIndex(int n, int n2) {
        return this.B(n, n2, 2);
    }

    private String B(int n, int n2, int n3) {
        String string = null;
        int n4 = this.mapJavaToICETextType(n);
        if (n4 < 0) {
            return string;
        }
        this.accessProvider.positionToIndex(1, n2);
        switch (n3) {
            case 0: {
                string = this.accessProvider.getCurrentText(n4);
                break;
            }
            case 2: {
                string = this.accessProvider.getPrevious(n4);
                break;
            }
            case 1: {
                string = this.accessProvider.getNext(n4);
            }
        }
        return string;
    }

    public AttributeSet getCharacterAttribute(int n) {
        if (this.BORDER_BOTTOM(n)) {
            return null;
        }
        CharacterAttributes characterAttributes = this.accessProvider.getCharAttributes(n);
        if (characterAttributes == null) {
            return null;
        }
        return this.BACKGROUND_COLOR(characterAttributes);
    }

    private AttributeSet BACKGROUND_COLOR(CharacterAttributes characterAttributes) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.BACKGROUND_COLOR, CharacterAttributes.background_color);
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.BACKGROUND_IMAGE, CharacterAttributes.background_image);
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_bottom_color);
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_bottom_style));
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_bottom_width));
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_left_color);
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_left_style));
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_left_width));
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_right_color);
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_right_style));
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_right_width));
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_top_color);
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_top_style));
        simpleAttributeSet.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_top_width));
        simpleAttributeSet.addAttribute(CSS.Attribute.FONT_FAMILY, new Integer(CharacterAttributes.font_family));
        simpleAttributeSet.addAttribute(CSS.Attribute.FONT_SIZE, new Integer(CharacterAttributes.font_size));
        simpleAttributeSet.addAttribute(CSS.Attribute.FONT_STYLE, new Integer(CharacterAttributes.font_style));
        simpleAttributeSet.addAttribute(CSS.Attribute.MARGIN_BOTTOM, new Integer(CharacterAttributes.margin_bottom));
        simpleAttributeSet.addAttribute(CSS.Attribute.MARGIN_LEFT, new Integer(CharacterAttributes.margin_left));
        simpleAttributeSet.addAttribute(CSS.Attribute.MARGIN_RIGHT, new Integer(CharacterAttributes.margin_right));
        simpleAttributeSet.addAttribute(CSS.Attribute.MARGIN_TOP, new Integer(CharacterAttributes.margin_top));
        simpleAttributeSet.addAttribute(CSS.Attribute.PADDING_BOTTOM, new Integer(CharacterAttributes.padding_bottom));
        simpleAttributeSet.addAttribute(CSS.Attribute.PADDING_LEFT, new Integer(CharacterAttributes.padding_left));
        simpleAttributeSet.addAttribute(CSS.Attribute.PADDING_RIGHT, new Integer(CharacterAttributes.padding_right));
        simpleAttributeSet.addAttribute(CSS.Attribute.PADDING_TOP, new Integer(CharacterAttributes.padding_top));
        simpleAttributeSet.addAttribute(CSS.Attribute.TEXT_ALIGN, new Integer(CharacterAttributes.text_align));
        simpleAttributeSet.addAttribute(CSS.Attribute.TEXT_DECORATION, new Byte(CharacterAttributes.text_decoration));
        simpleAttributeSet.addAttribute(CSS.Attribute.TEXT_INDENT, new Integer(CharacterAttributes.text_indent));
        simpleAttributeSet.addAttribute(CSS.Attribute.VERTICAL_ALIGN, new Integer(CharacterAttributes.vertical_align_type));
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.COLOR, CharacterAttributes.color);
        simpleAttributeSet.addAttribute(CSS.Attribute.DISPLAY, new Integer(CharacterAttributes.display));
        this.BACKGROUND_IMAGE(simpleAttributeSet, CSS.Attribute.COLOR, CharacterAttributes.outline_color);
        simpleAttributeSet.addAttribute(CSS.Attribute.HEIGHT, new Integer(CharacterAttributes.height));
        simpleAttributeSet.addAttribute(CSS.Attribute.LINE_HEIGHT, new Integer(CharacterAttributes.line_height));
        simpleAttributeSet.addAttribute(CSS.Attribute.LIST_STYLE_TYPE, new Byte(CharacterAttributes.listStyleType));
        return simpleAttributeSet;
    }

    private void BACKGROUND_IMAGE(SimpleAttributeSet simpleAttributeSet, Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        simpleAttributeSet.addAttribute(object, object2);
    }

    private boolean BORDER_BOTTOM(int n) {
        return n < 0 || n > this.getCharCount();
    }

    public int getSelectionStart() {
        return this.accessProvider.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.accessProvider.getSelectionEnd();
    }

    public String getSelectedText() {
        return this.accessProvider.getSelectedText();
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        DNode dNode = (DNode)event.getTarget();
        switch (dOMEvent.getTypeId()) {
            case 13: {
                if (dNode == null || dNode.getNameId() != 13) break;
                this.BORDER_BOTTOM_WIDTH(dNode);
                break;
            }
            case 14: {
                if (dNode == null || dNode.getNameId() != 13) break;
                this.BORDER_COLOR(dNode);
                break;
            }
            case 10: {
                DOMUIEvent dOMUIEvent = (DOMUIEvent)event;
                this.FONT_FAMILY(dOMUIEvent);
                break;
            }
            case 21: {
                if (dNode == null) break;
                this.DISPLAY(dNode);
                break;
            }
            case 30: {
                if (dNode == null) break;
                this.COLOR(dNode);
                break;
            }
        }
    }

    private void BORDER_BOTTOM_WIDTH(DNode dNode) {
        this.linkIndex = new AccessibleLinkIndex(this.accessProvider);
        this.linkIndex.processDoc(this.htmlPilot.getDDocument());
        this.firePropertyChange("AccessibleName", null, this.getAccessibleName());
        this.firePropertyChange("AccessibleText", Boolean.FALSE, Boolean.TRUE);
        this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
    }

    private void BORDER_COLOR(DNode dNode) {
        this.firePropertyChange("AccessibleName", this.getAccessibleName(), null);
        this.firePropertyChange("AccessibleText", Boolean.TRUE, Boolean.FALSE);
    }

    private void COLOR(DNode dNode) {
        this.FALSE(dNode);
    }

    private void DISPLAY(DNode dNode) {
        if (dNode != null) {
            this.FALSE(dNode);
            if (dNode instanceof DAnchorElement) {
                this.status.setScreenReaderStatus("LINK " + dNode.getInnerText());
            }
        }
    }

    private void FALSE(DNode dNode) {
        int n = this.accessProvider.getIndexOfNode(dNode);
        this.FONT_SIZE(1, this.accessProvider.getCaretPosition(1), n, 0);
    }

    private void FONT_FAMILY(DOMUIEvent dOMUIEvent) {
        int n;
        int n2;
        if (!this.docView.docPanel.hasFocus()) {
            return;
        }
        long l = dOMUIEvent.getKeyCode();
        if (l == 0L) {
            return;
        }
        if (dOMUIEvent.getCtrlKey()) {
            n2 = this.accessProvider.getCaretPosition(2);
            n = this.accessProvider.getCount(2);
            if (l == 39L && n2 < n) {
                this.FONT_SIZE(2, n2++, n2, 1);
            }
            if (l == 37L && n2 > 0) {
                this.FONT_SIZE(2, n2--, n2, 2);
            }
        } else {
            n2 = this.accessProvider.getCaretPosition(1);
            n = this.accessProvider.getCount(1);
            if (l == 39L && n2 < n) {
                this.FONT_SIZE(1, n2++, n2, 1);
            }
            if (l == 37L && n2 > 0) {
                this.FONT_SIZE(1, n2--, n2, 2);
            }
        }
        n2 = this.accessProvider.getCaretPosition(3);
        n = this.accessProvider.getCount(3);
        if (l == 38L && n2 > 0) {
            this.FONT_SIZE(3, n2--, n2, 2);
        }
        if (l == 40L && n2 < n) {
            this.FONT_SIZE(3, n2++, n2, 1);
        }
    }

    private void FONT_SIZE(int n, int n2, int n3, int n4) {
        if (n2 != n3) {
            String string = null;
            if (n4 == 1) {
                string = this.accessProvider.getNext(n);
            } else if (n4 == 2) {
                string = this.accessProvider.getPrevious(n);
            } else {
                this.accessProvider.positionToIndex(n, n3);
                string = this.accessProvider.getCurrentText(n);
            }
            if (this.status != null && string != null) {
                this.status.setScreenReaderStatus(string);
            }
            this.firePropertyChange("AccessibleCaret", new Integer(n2), new Integer(n3));
        }
    }

    public int mapJavaToICETextType(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
            }
        }
        return n2;
    }

    public void setAccessibleStatus(ScreenReaderStatusComponent screenReaderStatusComponent) {
        this.status = screenReaderStatusComponent;
    }
}

