/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.dialogs;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.toolbox.shared.computils.confinement.ThreadCheck;
import com.mathworks.toolbox.shared.computils.confinement.predicates.OnlyEDT;
import com.mathworks.toolbox.shared.computils.dialogs.resources.DialogResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.RootPaneContainer;
import javax.swing.event.MouseInputAdapter;
import org.apache.commons.lang.Validate;

@ThreadCheck(access=OnlyEDT.class)
public class ProgressBarDialog {
    private MJFrame fFrame;
    private JInternalFrame fInternalFrame;
    private JComponent fGlassPane;
    private Component fOldGlassPane;
    private RootPaneContainer fParent;
    private final MJProgressBar fProgressBar;
    private final MJLabel fStatusString;
    private final MJLabel fSpinner;
    private final MJButton fCancelButton;
    private CancellationListener fListener;
    private double fMin = 0.0;
    private double fMax = 1.0;
    private double fValue = 0.0;

    public static ProgressBarDialog createProgressBar(String string, CancellationListener cancellationListener) {
        return new ProgressBarDialog(string, false, cancellationListener);
    }

    public static ProgressBarDialog createInternalProgressBar(RootPaneContainer rootPaneContainer, String string, CancellationListener cancellationListener) {
        ProgressBarDialog progressBarDialog = new ProgressBarDialog(string, true, cancellationListener);
        progressBarDialog.initGlassPane(rootPaneContainer);
        progressBarDialog.fGlassPane.add(progressBarDialog.fInternalFrame);
        return progressBarDialog;
    }

    public static ProgressBarDialog createHeavyweightInternalProgressBar(RootPaneContainer rootPaneContainer, String string, CancellationListener cancellationListener) {
        ProgressBarDialog progressBarDialog = new ProgressBarDialog(string, true, cancellationListener);
        progressBarDialog.initGlassPane(rootPaneContainer);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add(progressBarDialog.fInternalFrame);
        progressBarDialog.fGlassPane.add(panel);
        return progressBarDialog;
    }

    private void initGlassPane(RootPaneContainer rootPaneContainer) {
        this.fParent = rootPaneContainer;
        this.fOldGlassPane = rootPaneContainer.getGlassPane();
        this.fGlassPane = new JComponent(){};
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){};
        this.fGlassPane.addMouseListener(mouseInputAdapter);
        this.fGlassPane.addMouseMotionListener(mouseInputAdapter);
        this.fGlassPane.setLayout(new GridBagLayout());
        this.fParent.setGlassPane(this.fGlassPane);
        this.fGlassPane.setVisible(true);
    }

    private ProgressBarDialog(String string, boolean bl, CancellationListener cancellationListener) {
        Object object;
        if (bl) {
            this.fInternalFrame = new JInternalFrame(string);
            this.fInternalFrame.setName("ProgressBarDialog");
            this.fInternalFrame.setFrameIcon(null);
            object = this.fInternalFrame;
        } else {
            this.fFrame = new MJFrame(string);
            this.fFrame.setName("ProgressBarDialog");
            object = this.fFrame;
            this.fFrame.setLocationRelativeTo(null);
        }
        this.fListener = cancellationListener;
        this.fProgressBar = new MJProgressBar(0, 0, Integer.MAX_VALUE);
        this.fProgressBar.setPreferredSize(new Dimension(380, 15));
        this.setValue(this.fMin);
        this.fStatusString = new MJLabel(DialogResources.getString("progressbar.please.wait", new String[0]));
        this.fSpinner = new MJLabel();
        this.fSpinner.setIcon((Icon)new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/mathworks/toolbox/shared/computils/dialogs/resources/spinner.gif"))));
        this.fCancelButton = new MJButton(DialogResources.getString("progressbar.cancel", new String[0]));
        MJPanel mJPanel = new MJPanel();
        mJPanel.add((Component)this.fCancelButton);
        this.fCancelButton.addActionListener((ActionListener)new CancelButtonListener());
        MJPanel mJPanel2 = new MJPanel(new BorderLayout(5, 5)){

            public Insets getInsets() {
                return new Insets(5, 5, 0, 5);
            }
        };
        mJPanel2.setLayout((LayoutManager)new BorderLayout(5, 5));
        mJPanel2.add((Component)this.fStatusString, (Object)"North");
        mJPanel2.add((Component)this.fProgressBar, (Object)"Center");
        mJPanel2.add((Component)mJPanel, (Object)"South");
        mJPanel2.add((Component)this.fSpinner, (Object)"East");
        object.setContentPane((Container)mJPanel2);
        if (bl) {
            this.fInternalFrame.pack();
        } else {
            this.fFrame.pack();
        }
    }

    public boolean isInternalProgressBar() {
        return this.fFrame == null;
    }

    public void showProgressBar(boolean bl) {
        this.fProgressBar.setVisible(bl);
    }

    public void setIcon(URL uRL) {
        Validate.notNull((Object)uRL);
        Validate.isTrue((boolean)ProgressBarDialog.isValidImageURL(uRL));
        this.fFrame.setIconImage(new ImageIcon(uRL).getImage());
    }

    private static boolean isValidImageURL(URL uRL) {
        try {
            uRL.getContent();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setDefaultIcon() {
        this.setIcon(this.getClass().getResource("/com/mathworks/mwswing/resources/matlabicon.gif"));
    }

    public void setLocationRelativeTo(Component component) {
        this.fFrame.setLocationRelativeTo(component);
    }

    public void setProgressStatusLabel(String string) {
        this.fStatusString.setText(string);
        this.fStatusString.repaint();
    }

    public void setCircularProgressBar(boolean bl) {
        this.fProgressBar.setIndeterminate(bl);
    }

    public void dispose() {
        this.fListener = null;
        this.fProgressBar.setIndeterminate(false);
        this.fProgressBar.updateUI();
        if (!this.isInternalProgressBar()) {
            this.fFrame.dispose();
        } else {
            this.fGlassPane.setVisible(false);
            this.fParent.setGlassPane(this.fOldGlassPane);
            this.fInternalFrame.dispose();
            this.fParent.getContentPane().revalidate();
        }
    }

    public void setVisible(boolean bl) {
        if (!this.isInternalProgressBar()) {
            this.fFrame.setVisible(bl);
        } else {
            this.fInternalFrame.setVisible(bl);
            this.fGlassPane.setVisible(bl);
        }
    }

    public void setSpinnerVisible(boolean bl) {
        this.fSpinner.setVisible(bl);
        if (!this.isInternalProgressBar()) {
            this.fFrame.pack();
        } else {
            this.fInternalFrame.pack();
        }
    }

    public void setMinimum(double d) {
        this.fMin = d;
        this.setValue(this.fValue);
    }

    public double getMinimum() {
        return this.fMin;
    }

    public void setMaximum(double d) {
        this.fMax = d;
        this.setValue(this.fValue);
    }

    public double getMaximum() {
        return this.fMax;
    }

    public void setValue(double d) {
        this.fValue = d;
        int n = (int)(2.147483647E9 * (this.fValue - this.fMin) / (this.fMax - this.fMin));
        this.fProgressBar.setString(DialogResources.getString("progressbar.please.wait", new String[0]));
        this.fProgressBar.setValue(n);
    }

    public double getValue() {
        return (double)this.fProgressBar.getValue() / 2.147483647E9 * (this.fMax - this.fMin);
    }

    public void setCancelButtonVisible(boolean bl) {
        this.fCancelButton.setVisible(bl);
        if (!this.isInternalProgressBar()) {
            this.fFrame.pack();
        } else {
            this.fInternalFrame.pack();
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProgressBarDialog.this.fListener != null) {
                ProgressBarDialog.this.fListener.cancel();
            }
            ProgressBarDialog.this.dispose();
        }
    }

    public static interface CancellationListener {
        public void cancel();
    }
}

