/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file;

import com.mathworks.toolbox.shared.computils.file.FilePermissions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileDeleter {
    private FileDeleter() {
    }

    public static void deleteDirectoryIfItExists(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
            return;
        }
        catch (IOException iOException) {
            if (file.setWritable(true) && file.delete()) {
                return;
            }
            Logger logger = new Logger();
            logger.log(String.format("Could not delete the directory: %s", file.getAbsolutePath()));
            logger.log(String.format("Recursively setting write permissions for the directory:%s", file.getAbsolutePath()));
            FilePermissions.setWritableRecursively(file);
            if (file.delete()) {
                logger.log(String.format("Deleted :%s", file.getAbsolutePath()));
                return;
            }
            logger.log(String.format("Recursively Deleting files in:%s", file.getAbsolutePath()));
            FileDeleter.recursivelyDeleteFile(file);
            return;
        }
    }

    public static void recursivelyDeleteFile(File file) throws IOException {
        FileDeleter.deleteContents(file);
        FileDeleter.deleteFile(file);
    }

    public static void deleteContents(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                FileDeleter.recursivelyDeleteFile(file2);
            }
        }
    }

    public static void deleteFile(File file) throws IOException {
        Logger logger = new Logger();
        int n = 10;
        long l = 400L;
        int n2 = 0;
        while (true) {
            if (n2 > 1) {
                logger.log(String.format("Trying to delete file %s", file.getAbsolutePath()));
            }
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!file.exists() || n2++ > n) break;
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean bl = file.exists();
        if (bl) {
            logger.log(String.format("Absolute failure to delete the file %s", file.getAbsolutePath()));
            throw new IOException(String.format("Could not delete the file/directory:\n\t%s\n", file));
        }
    }

    private static class Logger {
        private Logger() {
        }

        public String getModuleName() {
            return "File Deleter";
        }

        public void log(String string) {
            System.out.println(string);
        }
    }
}

