/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file;

import com.mathworks.toolbox.shared.computils.file.filters.ExcludeListFilter;
import com.mathworks.toolbox.shared.computils.file.filters.PassThroughFileFilter;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.NativeJava;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class FileLists {
    private FileLists() {
    }

    public static Collection<File> listAllChildren(File file, Collection<String> collection) {
        HashSet<File> hashSet = new HashSet<File>();
        FileLists.recursivelyCollectChildFilesInCollection(file, hashSet, new ExcludeListFilter(collection));
        return hashSet;
    }

    public static Collection<File> listAllChildren(File file, FileFilter fileFilter) {
        HashSet<File> hashSet = new HashSet<File>();
        FileLists.recursivelyCollectChildFilesInCollection(file, hashSet, fileFilter);
        return hashSet;
    }

    public static Collection<File> listAllChildren(File file) {
        HashSet<File> hashSet = new HashSet<File>();
        FileLists.recursivelyCollectChildFilesInCollection(file, hashSet, new PassThroughFileFilter());
        return hashSet;
    }

    private static void recursivelyCollectChildFilesInCollection(File file, Collection<File> collection, FileFilter fileFilter) {
        if (!fileFilter.accept(file)) {
            return;
        }
        Collection<File> collection2 = FileLists.listFiles(file);
        for (File file2 : collection2) {
            if (fileFilter.accept(file2)) {
                collection.add(file2);
            }
            FileLists.recursivelyCollectChildFilesInCollection(file2, collection, fileFilter);
        }
    }

    public static Collection<File> listFiles(File file) {
        final ArrayList<File> arrayList = new ArrayList<File>();
        final String string = file.getAbsolutePath();
        NativeJava.listFiles((String)string, (AsyncReceiver)new AsyncReceiver<NativeJava.StatEntry>(){

            public boolean receive(NativeJava.StatEntry statEntry) {
                arrayList.add(new File(string, statEntry.getName()));
                return true;
            }
        });
        return arrayList;
    }
}

