/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file;

import com.mathworks.toolbox.shared.computils.file.resources.FileResources;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributes;

public class FilePermissions {
    private FilePermissions() {
    }

    public static void setWriteableForAll(File file) throws IOException {
        Path path;
        Path path2;
        if (PlatformInfo.isWindows() ? Files.readAttributes(path2 = Files.setAttribute(path = file.toPath(), "dos:readonly", false, new LinkOption[0]), DosFileAttributes.class, new LinkOption[0]).isReadOnly() : !file.setWritable(true, false)) {
            throw new IOException(FileResources.getString("exception.directory.cantWrite", file.getAbsolutePath()));
        }
    }

    public static void setReadOnlyRecursively(File file) {
        FilePermissions.setFileAttributeRecursively(file, "r");
    }

    public static void setWritableRecursively(File file) {
        FilePermissions.setFileAttributeRecursively(file, "w");
    }

    private static void setFileAttributeRecursively(File file, String string) {
        NativeJava.changeFileAttribute((String)file.getAbsolutePath(), (String)string);
        if (file.isFile()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            FilePermissions.setFileAttributeRecursively(file2, string);
        }
    }
}

