/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file;

import com.mathworks.toolbox.shared.computils.file.FilePermissions;
import com.mathworks.toolbox.shared.computils.file.resources.FileResources;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;

public class FileUtil {
    private static final int BUFFER = 2048;
    private static final String SYSTEM_FILE_SEPERATOR = Matcher.quoteReplacement(File.separator);
    private static final String SERIALIZED_FILE_SEPARATOR = Matcher.quoteReplacement("/");

    private FileUtil() {
    }

    public static File fullFile(String ... stringArray) {
        return FileUtil.fullFile(Arrays.asList(stringArray));
    }

    public static void copy(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            FileUtil.makeDirIfItDoesNotExist(file2);
        } else {
            FileUtil.makeParentDirIfItDoesNotExist(file2);
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                 FileOutputStream fileOutputStream = new FileOutputStream(file2);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                int n;
                byte[] byArray = new byte[2048];
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
            }
        }
    }

    public static File addPrefixToFileName(String string, File file) {
        return new File(file.getParent(), string + file.getName());
    }

    public static File addPostfixToFileName(String string, File file) {
        return new File(file.getParent(), FileUtil.getNameWithExtensionStripped(file) + "_" + string + FileUtil.getFileExtension(file));
    }

    public static File fullFile(File file, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getAbsolutePath());
        for (String string : stringArray) {
            if (string == null) continue;
            arrayList.add(string);
        }
        return FileUtil.fullFile(arrayList);
    }

    public static void makeParentDirIfItDoesNotExist(File file) throws IOException {
        FileUtil.makeDirIfItDoesNotExist(file.getParentFile());
    }

    public static void makeDirIfItDoesNotExist(File file) throws IOException {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException(FileResources.getString("exception.directory.cantCreate", file.getAbsolutePath()));
            }
            FilePermissions.setWriteableForAll(file);
        }
    }

    public static boolean areFilesTheSame(File file, File file2) throws IOException {
        return file.getCanonicalPath().equals(file2.getCanonicalPath());
    }

    public static File fullFile(Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : iterable) {
            stringBuilder.append(string);
            stringBuilder.append(File.separator);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return new File(stringBuilder.toString());
    }

    public static File fullFile(File file, Iterable<String> iterable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getAbsolutePath());
        for (String string : iterable) {
            arrayList.add(string);
        }
        return FileUtil.fullFile(arrayList);
    }

    public static String getRelativePath(URI uRI, URI uRI2) {
        URI uRI3 = uRI.relativize(uRI2);
        return uRI3.getPath();
    }

    public static String getRelativePath(File file, File file2) throws IOException {
        Path path;
        Path path2;
        try {
            path2 = Paths.get(file2.getPath(), new String[0]);
            path = Paths.get(file.getPath(), new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException(invalidPathException.getLocalizedMessage(), invalidPathException);
        }
        if (!path2.startsWith(path)) {
            return path2.toString();
        }
        Path path3 = path.relativize(path2);
        return path3.toString();
    }

    public static String getNameWithExtensionStripped(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        int n2 = string.length();
        if (n > 0 && n < n2) {
            return string.substring(0, n);
        }
        return string;
    }

    public static File changeRoot(File file, File file2, File file3) throws IOException {
        String string = FileUtil.getRelativePath(file2, file);
        return new File(file3, string);
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return FileUtil.splitName(string).getExtension();
    }

    public static FileParts splitName(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(46);
        int n2 = string.length();
        if (n > 0 && n < n2) {
            string3 = string.substring(n, n2);
            string2 = string.substring(0, n);
        } else {
            string2 = string;
            string3 = null;
        }
        return new FileParts(){

            @Override
            public String getExtension() {
                return string3;
            }

            @Override
            public String getName() {
                return string2;
            }
        };
    }

    public static String makeRelativePathCrossPlatform(String string) {
        return string.replaceAll(SYSTEM_FILE_SEPERATOR, SERIALIZED_FILE_SEPARATOR);
    }

    public static String makeCrossPlatformRelativePathPlatformSpecific(String string) {
        return string.replaceAll(SERIALIZED_FILE_SEPARATOR, SYSTEM_FILE_SEPERATOR);
    }

    public static void writeFile(File file, String string) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(string);
        }
    }

    /*
     * Exception decompiling
     */
    public static String readFile(File var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface FileParts {
        public String getExtension();

        public String getName();
    }
}

