/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui;

import com.mathworks.toolbox.shared.computils.file.FileUtil;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ConflictExtractionParameters;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class UserDefinedConflictExtractionParameters
implements ConflictExtractionParameters {
    private static final String MINE_POSTFIX = "mine";
    private static final String THEIRS_POSTFIX = "theirs";
    private final File fConflictedFile;
    private volatile File fMineFile;
    private volatile File fTheirsFile;
    private volatile boolean fMineFixed;
    private volatile boolean fTheirsFixed;
    private final Collection<Listener> fListeners = new CopyOnWriteArrayList<Listener>();

    public UserDefinedConflictExtractionParameters(File file) {
        this.fConflictedFile = file;
        this.fMineFile = this.getDefaultMineFile();
        this.fTheirsFile = this.getDefaultTheirsFile();
    }

    private File getDefaultMineFile() {
        return FileUtil.addPostfixToFileName(MINE_POSTFIX, this.fConflictedFile);
    }

    private File getDefaultTheirsFile() {
        return FileUtil.addPostfixToFileName(THEIRS_POSTFIX, this.fConflictedFile);
    }

    public void setMineFile(File file) {
        this.fMineFile = file;
        this.broadcastConfigChange();
    }

    public void setTheirsFile(File file) {
        this.fTheirsFile = file;
        this.broadcastConfigChange();
    }

    public void add(Listener listener) {
        this.fListeners.add(listener);
    }

    public void broadcastConfigChange() {
        for (Listener listener : this.fListeners) {
            listener.configChange();
        }
    }

    @Override
    public File getConflictedFile() {
        return this.fConflictedFile;
    }

    @Override
    public File getMineFile() {
        return this.fMineFile;
    }

    public boolean isMineFileFixed() {
        return this.fMineFixed;
    }

    public boolean isTheirsFileFixed() {
        return this.fTheirsFixed;
    }

    @Override
    public File getTheirsFile() {
        return this.fTheirsFile;
    }

    public void setToExtractMineOverConflicted() {
        this.fMineFixed = true;
        this.fTheirsFixed = false;
        this.setMineFile(this.fConflictedFile);
        if (this.fTheirsFile.equals(this.fConflictedFile)) {
            this.setTheirsFile(this.getDefaultTheirsFile());
        }
    }

    public void setToExtractTheirsOverConflicted() {
        this.fMineFixed = false;
        this.fTheirsFixed = true;
        this.setTheirsFile(this.fConflictedFile);
        if (this.fMineFile.equals(this.fConflictedFile)) {
            this.setMineFile(this.getDefaultMineFile());
        }
    }

    public void setToExtractPreservingConflicted() {
        this.fMineFixed = false;
        this.fTheirsFixed = false;
        if (this.fMineFile.equals(this.fConflictedFile)) {
            this.setMineFile(this.getDefaultMineFile());
        }
        if (this.fTheirsFile.equals(this.fConflictedFile)) {
            this.setTheirsFile(this.getDefaultTheirsFile());
        }
    }

    public static interface Listener {
        public void configChange();
    }
}

